/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.disable;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class ActionDisablingStrategyObserver {
    private DockAction action;
    private Map<Dockable, DockableObserver> dockables = new HashMap<Dockable, DockableObserver>();
    private Map<DockController, ControllerObserver> controllers = new HashMap<DockController, ControllerObserver>(1);

    public ActionDisablingStrategyObserver(DockAction dockAction) {
        if (dockAction == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        this.action = dockAction;
    }

    public void bind(Dockable dockable) {
        DockableObserver dockableObserver = this.dockables.get(dockable);
        if (dockableObserver == null) {
            dockableObserver = new DockableObserver(dockable);
            this.dockables.put(dockable, dockableObserver);
        }
        dockableObserver.inc();
    }

    public void unbind(Dockable dockable) {
        DockableObserver dockableObserver = this.dockables.get(dockable);
        if (dockableObserver != null) {
            dockableObserver.dec();
            if (dockableObserver.destroy()) {
                this.dockables.remove(dockable);
            }
        }
    }

    private void set(DockController dockController, DockController dockController2, Dockable dockable) {
        if (dockController != dockController2) {
            ControllerObserver controllerObserver;
            if (dockController != null) {
                controllerObserver = this.controllers.get(dockController);
                controllerObserver.remove(dockable);
                if (controllerObserver.destroy()) {
                    this.controllers.remove(dockController);
                }
            }
            if (dockController2 != null) {
                controllerObserver = this.controllers.get(dockController2);
                if (controllerObserver == null) {
                    controllerObserver = new ControllerObserver(dockController2);
                    this.controllers.put(dockController2, controllerObserver);
                }
                controllerObserver.add(dockable);
            }
        }
    }

    protected abstract void setDisabled(Dockable var1, boolean var2);

    protected abstract void setDisabled(Set<Dockable> var1, boolean var2);

    public boolean isDisabled(Dockable dockable) {
        ControllerObserver controllerObserver;
        DockController dockController = dockable.getController();
        if (dockController != null && (controllerObserver = this.controllers.get(dockController)) != null) {
            return controllerObserver.isDisabled(dockable);
        }
        return false;
    }

    private class ControllerObserver
    extends PropertyValue<DisablingStrategy>
    implements DisablingStrategyListener {
        private Set<Dockable> dockables;

        public ControllerObserver(DockController dockController) {
            super(DisablingStrategy.STRATEGY);
            this.dockables = new HashSet<Dockable>();
            this.setProperties(dockController);
        }

        @Override
        protected void valueChanged(DisablingStrategy disablingStrategy, DisablingStrategy disablingStrategy2) {
            if (disablingStrategy != null) {
                disablingStrategy.removeDisablingStrategyListener(this);
            }
            if (disablingStrategy2 != null) {
                disablingStrategy2.addDisablingStrategyListener(this);
                HashSet<Dockable> hashSet = new HashSet<Dockable>();
                HashSet<Dockable> hashSet2 = new HashSet<Dockable>();
                for (Dockable dockable : this.dockables) {
                    if (disablingStrategy2.isDisabled(dockable, ActionDisablingStrategyObserver.this.action)) {
                        hashSet2.add(dockable);
                        continue;
                    }
                    hashSet.add(dockable);
                }
                if (!hashSet.isEmpty()) {
                    ActionDisablingStrategyObserver.this.setDisabled(hashSet, false);
                }
                if (!hashSet2.isEmpty()) {
                    ActionDisablingStrategyObserver.this.setDisabled(hashSet2, false);
                }
            } else {
                ActionDisablingStrategyObserver.this.setDisabled(this.dockables, false);
            }
        }

        @Override
        public void changed(DockElement dockElement) {
            Dockable dockable = dockElement.asDockable();
            if (dockable != null && this.dockables.contains(dockable)) {
                ActionDisablingStrategyObserver.this.setDisabled(dockable, ((DisablingStrategy)this.getValue()).isDisabled(dockable, ActionDisablingStrategyObserver.this.action));
            }
        }

        public boolean isDisabled(Dockable dockable) {
            DisablingStrategy disablingStrategy = (DisablingStrategy)this.getValue();
            if (disablingStrategy != null) {
                return disablingStrategy.isDisabled(dockable, ActionDisablingStrategyObserver.this.action);
            }
            return false;
        }

        public void add(Dockable dockable) {
            DisablingStrategy disablingStrategy = (DisablingStrategy)this.getValue();
            if (disablingStrategy != null) {
                ActionDisablingStrategyObserver.this.setDisabled(dockable, disablingStrategy.isDisabled(dockable, ActionDisablingStrategyObserver.this.action));
            }
            this.dockables.add(dockable);
        }

        public void remove(Dockable dockable) {
            ActionDisablingStrategyObserver.this.setDisabled(dockable, false);
            this.dockables.remove(dockable);
        }

        public boolean destroy() {
            if (this.dockables.isEmpty()) {
                this.setProperties((DockController)null);
                return true;
            }
            return false;
        }
    }

    private class DockableObserver
    implements DockHierarchyListener {
        private Dockable dockable;
        private DockController controller;
        private int count = 0;

        public DockableObserver(Dockable dockable) {
            this.dockable = dockable;
            dockable.addDockHierarchyListener(this);
            DockController dockController = dockable.getController();
            if (dockController != null) {
                this.bind(dockController);
            }
        }

        private void bind(DockController dockController) {
            ActionDisablingStrategyObserver.this.set(this.controller, dockController, this.dockable);
            this.controller = dockController;
        }

        public void inc() {
            ++this.count;
        }

        public void dec() {
            --this.count;
        }

        public boolean destroy() {
            if (this.count <= 0) {
                this.dockable.removeDockHierarchyListener(this);
                this.bind(null);
                return true;
            }
            return false;
        }

        @Override
        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
            this.bind(this.dockable.getController());
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
        }
    }
}

