/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import java.awt.Point;

public class MergeOperation
implements RelocateOperation {
    private DockController controller;
    private Merger merger;
    private DockStation station;
    private StationDropOperation operation;
    private StationDropItem item;

    public MergeOperation(DockController dockController, Merger merger, DockStation dockStation, StationDropOperation stationDropOperation, StationDropItem stationDropItem) {
        this.controller = dockController;
        this.merger = merger;
        this.station = dockStation;
        this.operation = stationDropOperation;
        this.item = stationDropItem;
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public StationDropOperation getOperation() {
        return this.operation;
    }

    @Override
    public void destroy(RelocateOperation relocateOperation) {
        if (relocateOperation == null) {
            this.operation.destroy(null);
        } else {
            this.operation.destroy(relocateOperation.getOperation());
        }
    }

    @Override
    public Dockable[] getImplicit(Dockable dockable) {
        DockStation dockStation = dockable.asDockStation();
        Dockable[] dockableArray = new Dockable[dockStation.getDockableCount()];
        int n = 0;
        while (n < dockableArray.length) {
            dockableArray[n] = dockStation.getDockable(n);
            ++n;
        }
        return dockableArray;
    }

    @Override
    public boolean execute(Dockable dockable, VetoableDockRelocatorListener vetoableDockRelocatorListener) {
        DockStation dockStation = dockable.asDockStation();
        DockStation dockStation2 = dockable.getDockParent();
        Dockable[] dockableArray = this.getImplicit(dockable);
        if (dockStation2 != null && dockStation2 != this.station) {
            Point point = new Point(this.item.getMouseX(), this.item.getMouseY());
            DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.controller, dockable, dockableArray, this.station, point, this.getOperation().isMove());
            vetoableDockRelocatorListener.dragging(defaultDockRelocatorEvent);
            if (defaultDockRelocatorEvent.isCanceled() || defaultDockRelocatorEvent.isForbidden()) {
                return false;
            }
        }
        this.merger.merge(this.operation, this.station, dockStation);
        dockStation2 = dockable.getDockParent();
        if (dockStation2 != null && dockStation2 != this.station) {
            dockStation2.drag(dockable);
        }
        return true;
    }
}

