/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import java.awt.Point;

public class DropOperation
implements RelocateOperation {
    private DockController controller;
    private DockStation station;
    private StationDropOperation operation;
    private StationDropItem item;

    public DropOperation(DockController dockController, DockStation dockStation, StationDropOperation stationDropOperation, StationDropItem stationDropItem) {
        this.controller = dockController;
        this.station = dockStation;
        this.operation = stationDropOperation;
        this.item = stationDropItem;
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public StationDropOperation getOperation() {
        return this.operation;
    }

    @Override
    public Dockable[] getImplicit(Dockable dockable) {
        return new Dockable[0];
    }

    @Override
    public void destroy(RelocateOperation relocateOperation) {
        if (relocateOperation == null) {
            this.operation.destroy(null);
        } else {
            this.operation.destroy(relocateOperation.getOperation());
        }
    }

    @Override
    public boolean execute(Dockable dockable, VetoableDockRelocatorListener vetoableDockRelocatorListener) {
        try {
            Point point = new Point(this.item.getMouseX(), this.item.getMouseY());
            if (this.operation.isMove()) {
                DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.controller, dockable, new Dockable[0], this.station, point, true);
                vetoableDockRelocatorListener.dragging(defaultDockRelocatorEvent);
                if (defaultDockRelocatorEvent.isCanceled() || defaultDockRelocatorEvent.isForbidden()) {
                    return false;
                }
                this.operation.execute();
                vetoableDockRelocatorListener.dragged(new DefaultDockRelocatorEvent(this.controller, dockable, new Dockable[0], this.station, point, true));
            } else {
                DockStation dockStation = dockable.getDockParent();
                if (dockStation != null) {
                    DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.controller, dockable, new Dockable[0], this.station, point, false);
                    vetoableDockRelocatorListener.dragging(defaultDockRelocatorEvent);
                    if (defaultDockRelocatorEvent.isCanceled() || defaultDockRelocatorEvent.isForbidden()) {
                        return false;
                    }
                    dockStation.drag(dockable);
                    vetoableDockRelocatorListener.dragged(new DefaultDockRelocatorEvent(this.controller, dockable, new Dockable[0], this.station, point, false));
                }
                this.operation.execute();
            }
        }
        finally {
            this.operation.destroy(null);
        }
        return true;
    }
}

