/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.DirectRemoteRelocator;
import bibliothek.gui.dock.control.GlobalMouseDispatcher;
import bibliothek.gui.dock.control.RemoteRelocator;
import bibliothek.gui.dock.control.relocator.AbstractDockRelocator;
import bibliothek.gui.dock.control.relocator.DefaultDockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.DefaultInserterSource;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.DropOperation;
import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.MergeOperation;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.MultiInserter;
import bibliothek.gui.dock.control.relocator.MultiMerger;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.control.relocator.StackMerger;
import bibliothek.gui.dock.control.relocator.TabMerger;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.dockable.MovingImage;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import bibliothek.gui.dock.station.StationDragOperation;
import bibliothek.gui.dock.station.StationDropItem;
import bibliothek.gui.dock.station.StationDropOperation;
import bibliothek.gui.dock.station.layer.OrderedLayerCollection;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Workarounds;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DefaultDockRelocator
extends AbstractDockRelocator {
    public static final PropertyKey<Boolean> AUTO_DROP_ON_ANY_MOUSE_RELEASED_EVENT = new PropertyKey<Boolean>("dock.default.relocator.autodrop", new ConstantPropertyFactory<Boolean>(true), true);
    private boolean onMove = false;
    private boolean onPut = false;
    private RelocateOperation operation;
    private StationDragOperation dragOperation;
    private ImageWindow movingImageWindow;
    private Point pressPointScreen;
    private Point pressPointLocal;
    private Point lastPoint;
    private StationDropItem lastItem;
    private Listener listeners;

    public DefaultDockRelocator(DockController dockController, ControllerSetupCollection controllerSetupCollection) {
        super(dockController);
        MultiMerger multiMerger = new MultiMerger();
        multiMerger.add(new StackMerger());
        multiMerger.add(new TabMerger());
        MultiInserter multiInserter = new MultiInserter();
        this.listeners = new Listener();
        controllerSetupCollection.add(new ControllerSetupListener(){

            @Override
            public void done(DockController dockController) {
                dockController.addRepresentativeListener(DefaultDockRelocator.this.listeners);
                GlobalMouseReleaseListener globalMouseReleaseListener = new GlobalMouseReleaseListener();
                globalMouseReleaseListener.link();
            }
        });
        this.setMerger(multiMerger);
        this.setInserter(multiInserter);
    }

    @Override
    public boolean isOnMove() {
        return this.onMove;
    }

    @Override
    public boolean isOnPut() {
        return this.onPut;
    }

    @Override
    public boolean hasTarget() {
        return this.operation != null;
    }

    @Override
    public DirectRemoteRelocator createDirectRemote(Dockable dockable) {
        return this.createDirectRemote(dockable, false);
    }

    @Override
    public DirectRemoteRelocator createDirectRemote(Dockable dockable, boolean bl) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        return new DefaultRemoteRelocator(dockable, bl);
    }

    @Override
    public RemoteRelocator createRemote(Dockable dockable) {
        return this.createRemote(dockable, false);
    }

    @Override
    public RemoteRelocator createRemote(Dockable dockable, boolean bl) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        return new DefaultRemoteRelocator(dockable, bl);
    }

    protected boolean executeOperation(Dockable dockable, RelocateOperation relocateOperation) {
        this.onPut = true;
        DockController dockController = this.getController();
        dockController.getRegister().setStalled(true);
        this.disableAllModes();
        try {
            boolean bl = relocateOperation.execute(dockable, new VetoableDockRelocatorListener(){

                @Override
                public void searched(DockRelocatorEvent dockRelocatorEvent) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                @Override
                public void grabbing(DockRelocatorEvent dockRelocatorEvent) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                @Override
                public void grabbed(DockRelocatorEvent dockRelocatorEvent) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                @Override
                public void dropping(DockRelocatorEvent dockRelocatorEvent) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                @Override
                public void dropped(DockRelocatorEvent dockRelocatorEvent) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }

                @Override
                public void dragging(DockRelocatorEvent dockRelocatorEvent) {
                    DefaultDockRelocator.this.fireDragging(dockRelocatorEvent);
                }

                @Override
                public void dragged(DockRelocatorEvent dockRelocatorEvent) {
                    DefaultDockRelocator.this.fireDragged(dockRelocatorEvent);
                }

                @Override
                public void canceled(DockRelocatorEvent dockRelocatorEvent) {
                    throw new IllegalStateException("this event must not be called from an operation");
                }
            });
            if (this.dragOperation != null) {
                if (bl) {
                    this.dragOperation.succeeded();
                } else {
                    this.dragOperation.canceled();
                }
                this.dragOperation = null;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            relocateOperation.destroy(null);
            relocateOperation = null;
            this.onPut = false;
            dockController.getRegister().setStalled(false);
        }
    }

    private StationDropItem createStationDropItem(int n, int n2, int n3, int n4, Dockable dockable) {
        this.lastItem = this.lastItem == null || this.lastItem.getDockable() != dockable ? new StationDropItem(n, n2, n3, n4, dockable) : new StationDropItem(n, n2, n3, n4, dockable, this.lastItem.getOriginalSize(), this.lastItem.getMinimumSize());
        return this.lastItem;
    }

    protected RelocateOperation preparePut(int n, int n2, int n3, int n4, Dockable dockable) {
        List<DockStation> list = this.listStationsOrdered(n, n2, dockable);
        Inserter inserter = this.getInserter();
        StationDropItem stationDropItem = this.createStationDropItem(n, n2, n3, n4, dockable);
        for (DockStation dockStation : list) {
            StationDropOperation stationDropOperation = null;
            DefaultInserterSource defaultInserterSource = new DefaultInserterSource(dockStation, stationDropItem);
            if (inserter != null) {
                stationDropOperation = inserter.before(defaultInserterSource);
            }
            if (stationDropOperation == null) {
                stationDropOperation = dockStation.prepareDrop(stationDropItem);
                if (inserter != null) {
                    defaultInserterSource.setOperation(stationDropOperation);
                    stationDropOperation = inserter.after(defaultInserterSource);
                    if (stationDropOperation == null) {
                        stationDropOperation = defaultInserterSource.getOperation();
                    }
                }
            }
            RelocateOperation relocateOperation = null;
            boolean bl = this.canMerge(stationDropOperation, dockStation, dockable);
            if (stationDropOperation != null) {
                relocateOperation = bl ? new MergeOperation(this.getController(), this.getMerger(), dockStation, stationDropOperation, stationDropItem) : new DropOperation(this.getController(), dockStation, stationDropOperation, stationDropItem);
            }
            if (relocateOperation == null) continue;
            boolean bl2 = relocateOperation.getOperation().isMove();
            DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, relocateOperation.getImplicit(dockable), dockStation, new Point(n, n2), bl2);
            this.fireSearched(defaultDockRelocatorEvent);
            if (defaultDockRelocatorEvent.isForbidden()) {
                relocateOperation = null;
            } else if (defaultDockRelocatorEvent.isCanceled()) {
                this.cancel();
                return null;
            }
            if (relocateOperation == null) continue;
            return relocateOperation;
        }
        return null;
    }

    protected boolean canMerge(StationDropOperation stationDropOperation, DockStation dockStation, Dockable dockable) {
        Merger merger = this.getMerger();
        if (merger == null) {
            return false;
        }
        DockStation dockStation2 = dockable.asDockStation();
        if (dockStation2 == null) {
            return false;
        }
        if (DockUtilities.isAncestor(dockStation2, dockStation)) {
            return false;
        }
        if (dockable.getDockParent() != null && !dockable.getDockParent().canDrag(dockable)) {
            return false;
        }
        MultiDockAcceptance multiDockAcceptance = this.getController().getAcceptance();
        int n = 0;
        int n2 = dockStation2.getDockableCount();
        while (n < n2) {
            Dockable dockable2 = dockStation2.getDockable(n);
            if (!dockStation2.canDrag(dockable2)) {
                return false;
            }
            if (!dockStation.accept(dockable2) || !dockable2.accept(dockStation)) {
                return false;
            }
            if (!multiDockAcceptance.accept(dockStation, dockable2)) {
                return false;
            }
            ++n;
        }
        return merger.canMerge(stationDropOperation, dockStation, dockStation2);
    }

    protected List<DockStation> listStationsOrdered(int n, int n2, Dockable dockable) {
        DockController dockController = this.getController();
        DisablingStrategy disablingStrategy = dockController.getProperties().get(DisablingStrategy.STRATEGY);
        OrderedLayerCollection orderedLayerCollection = new OrderedLayerCollection();
        if (disablingStrategy == null || !disablingStrategy.isDisabled(dockable)) {
            DockStation dockStation = dockable.asDockStation();
            if (!this.isCancelLocation(n, n2, dockable)) {
                DockStation[] dockStationArray = dockController.getRegister().listDockStations();
                int n3 = dockStationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    DockStation dockStation2 = dockStationArray[n4];
                    if ((disablingStrategy == null || !disablingStrategy.isDisabled(dockStation2)) && (dockStation == null || !DockUtilities.isAncestor(dockStation, dockStation2) && dockStation != dockStation2) && dockStation2.isStationShowing() && this.isStationValid(dockStation2)) {
                        orderedLayerCollection.add(dockStation2);
                    }
                    ++n4;
                }
            }
        }
        return orderedLayerCollection.sort(n, n2);
    }

    protected boolean isCancelLocation(int n, int n2, Dockable dockable) {
        if (this.isCancelLocation(n, n2, (DockElementRepresentative)dockable)) {
            return true;
        }
        DockController dockController = dockable.getController();
        DockElementRepresentative[] dockElementRepresentativeArray = dockController.getRepresentatives(dockable);
        int n3 = dockElementRepresentativeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            DockElementRepresentative dockElementRepresentative = dockElementRepresentativeArray[n4];
            if (this.isCancelLocation(n, n2, dockElementRepresentative)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    protected boolean isCancelLocation(int n, int n2, DockElementRepresentative dockElementRepresentative) {
        return false;
    }

    protected boolean isStationValid(DockStation dockStation) {
        return true;
    }

    protected void dragMousePressed(MouseEvent mouseEvent, DockTitle dockTitle, Dockable dockable) {
        if (dockable == null) {
            dockable = dockTitle.getDockable();
        }
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMousePressed(point.x, point.y, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx(), dockable, false);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            mouseEvent.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMousePressed(int n, int n2, int n3, int n4, int n5, Dockable dockable, boolean bl) {
        this.listeners.unsetLastActiveListener();
        if (!bl && dockable.getDockParent() == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        this.lastPoint = new Point(n, n2);
        int n6 = 1024;
        int n7 = 6144;
        if ((n5 & (n6 | n7)) == n6) {
            this.titleDragCancel();
            this.onMove = false;
            this.pressPointScreen = new Point(n, n2);
            this.pressPointLocal = new Point(n3, n4);
            this.checkModes(n5);
            return RemoteRelocator.Reaction.CONTINUE;
        }
        if (this.pressPointScreen != null) {
            this.titleDragCancel();
            this.disableAllModes();
            Dockable[] dockableArray = this.operation == null ? new Dockable[]{} : this.operation.getImplicit(dockable);
            boolean bl2 = this.operation != null && this.operation.getOperation().isMove();
            DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, dockableArray, this.operation == null ? null : this.operation.getStation(), new Point(n, n2), bl2);
            defaultDockRelocatorEvent.cancel();
            this.fireCanceled(defaultDockRelocatorEvent);
            return this.onBreak(defaultDockRelocatorEvent);
        }
        return RemoteRelocator.Reaction.BREAK;
    }

    protected void dragMouseDragged(MouseEvent mouseEvent, DockTitle dockTitle, Dockable dockable) {
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMouseDragged(point.x, point.y, mouseEvent.getModifiersEx(), dockTitle, dockable, false, false);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            mouseEvent.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMouseDragged(int n, int n2, int n3, DockTitle dockTitle, Dockable dockable, boolean bl, boolean bl2) {
        return this.dragMouseDragged(n, n2, n3, dockTitle, dockable, bl, bl2, true);
    }

    protected RemoteRelocator.Reaction dragMouseDragged(int n, int n2, int n3, DockTitle dockTitle, Dockable dockable, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        this.listeners.unsetLastActiveListener();
        if (this.pressPointScreen == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        this.checkModes(n3);
        if (dockable == null) {
            dockable = dockTitle.getDockable();
        }
        if (dockable == null) {
            return RemoteRelocator.Reaction.BREAK;
        }
        Point point = new Point(n, n2);
        this.lastPoint = new Point(n, n2);
        if (!this.onMove) {
            object = dockable.getDockParent();
            if (!bl2 && object != null && !object.canDrag(dockable)) {
                this.titleDragCancel();
                this.disableAllModes();
                return RemoteRelocator.Reaction.BREAK;
            }
            int n4 = Math.abs(n - this.pressPointScreen.x) + Math.abs(n2 - this.pressPointScreen.y);
            if (bl || n4 >= this.getDragDistance()) {
                RemoteRelocator.Reaction reaction = this.initiateOperation(dockable, dockTitle, point, bl3);
                if (!this.onMove && reaction != null) {
                    return reaction;
                }
            }
        }
        if (this.onMove && (object = this.selectNextTarget(dockable, dockTitle, point)) != null) {
            return object;
        }
        return RemoteRelocator.Reaction.CONTINUE;
    }

    private RemoteRelocator.Reaction initiateOperation(Dockable dockable, DockTitle dockTitle, Point point, boolean bl) {
        if (this.movingImageWindow != null) {
            this.movingImageWindow.close();
            this.movingImageWindow = null;
        }
        this.lastItem = null;
        Dockable[] dockableArray = new Dockable[]{};
        DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, dockableArray, null, point, false);
        this.fireGrabbing(defaultDockRelocatorEvent);
        if (defaultDockRelocatorEvent.isIgnored()) {
            return RemoteRelocator.Reaction.CONTINUE;
        }
        if (defaultDockRelocatorEvent.isCanceled()) {
            defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, dockableArray, null, point, false);
            defaultDockRelocatorEvent.cancel();
            this.fireCanceled(defaultDockRelocatorEvent);
            return this.onBreak(defaultDockRelocatorEvent);
        }
        if (!defaultDockRelocatorEvent.isForbidden()) {
            if (bl) {
                this.movingImageWindow = this.getTitleWindow(dockable, dockTitle);
                if (this.movingImageWindow != null) {
                    this.updateTitleWindowPosition(point);
                    this.movingImageWindow.setVisible(true);
                }
            }
            this.onMove = true;
            DockStation dockStation = dockable.getDockParent();
            if (this.dragOperation != null) {
                this.dragOperation.canceled();
                this.dragOperation = null;
            }
            if (dockStation != null) {
                this.dragOperation = dockStation.prepareDrag(dockable);
            }
            defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, dockableArray, null, point, false);
            this.fireGrabbed(defaultDockRelocatorEvent);
            if (defaultDockRelocatorEvent.isCanceled() || defaultDockRelocatorEvent.isForbidden()) {
                this.cancel(dockable);
                return RemoteRelocator.Reaction.BREAK_CONSUMED;
            }
            return this.onContinue(defaultDockRelocatorEvent);
        }
        return null;
    }

    private RemoteRelocator.Reaction selectNextTarget(Dockable dockable, DockTitle dockTitle, Point point) {
        if (this.movingImageWindow != null) {
            this.updateTitleWindowPosition(point);
        }
        RelocateOperation relocateOperation = this.preparePut(point.x, point.y, point.x - this.pressPointLocal.x, point.y - this.pressPointLocal.y, dockable);
        boolean bl = false;
        Dockable[] dockableArray = relocateOperation == null ? new Dockable[]{} : relocateOperation.getImplicit(dockable);
        boolean bl2 = relocateOperation != null && relocateOperation.getOperation().isMove();
        DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, dockableArray, relocateOperation == null ? null : relocateOperation.getStation(), point, bl2);
        this.fireDragged(defaultDockRelocatorEvent);
        if (defaultDockRelocatorEvent.isCanceled()) {
            this.cancel(dockable);
            return this.onBreak(defaultDockRelocatorEvent);
        }
        if (defaultDockRelocatorEvent.isForbidden()) {
            relocateOperation = null;
        } else if (defaultDockRelocatorEvent.isIgnored()) {
            return RemoteRelocator.Reaction.CONTINUE;
        }
        if (relocateOperation != null) {
            boolean bl3 = bl = relocateOperation != null && defaultDockRelocatorEvent.isDropping();
        }
        if (bl) {
            return this.dragMouseReleased(point.x, point.y, 0, dockable);
        }
        if (this.operation != null) {
            this.operation.destroy(relocateOperation);
        }
        this.operation = relocateOperation;
        if (relocateOperation != null) {
            relocateOperation.getOperation().draw();
        }
        return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
    }

    private void updateTitleWindowPosition(Point point) {
        MovingImage movingImage = this.movingImageWindow.getImage();
        Point point2 = null;
        if (movingImage != null) {
            point2 = movingImage.getOffset(new Point(this.pressPointLocal));
        }
        if (point2 == null) {
            int n = Math.min(25, this.movingImageWindow.getWidth());
            int n2 = Math.min(25, this.movingImageWindow.getHeight());
            int n3 = Math.min(n, n2) + 1;
            int n4 = Math.min(n, this.pressPointLocal.x);
            int n5 = Math.min(n2, this.pressPointLocal.y);
            this.movingImageWindow.setLocation(point.x - n4 + n3, point.y - n5 + n3);
        } else {
            this.movingImageWindow.setLocation(point.x + point2.x, point.y + point2.y);
        }
    }

    protected void dragMouseReleased(MouseEvent mouseEvent, DockTitle dockTitle, Dockable dockable) {
        if (dockable == null) {
            dockable = dockTitle.getDockable();
        }
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        RemoteRelocator.Reaction reaction = this.dragMouseReleased(point.x, point.y, mouseEvent.getModifiersEx(), dockable);
        if (reaction == RemoteRelocator.Reaction.BREAK_CONSUMED || reaction == RemoteRelocator.Reaction.CONTINUE_CONSUMED) {
            mouseEvent.consume();
        }
    }

    protected RemoteRelocator.Reaction dragMouseReleased(int n, int n2, int n3, Dockable dockable) {
        this.listeners.unsetLastActiveListener();
        this.checkModes(n3);
        int n4 = 7168;
        boolean bl = !this.onMove || (n3 & n4) == 0;
        Point point = new Point(n, n2);
        if (bl && this.onMove) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultDockRelocator.this.onMove = false;
                }
            });
        }
        if (!this.onMove) {
            boolean bl2 = this.pressPointScreen != null;
            this.titleDragCancel();
            this.disableAllModes();
            if (bl) {
                DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, new Dockable[0], null, point, false);
                defaultDockRelocatorEvent.cancel();
                this.fireCanceled(defaultDockRelocatorEvent);
                if (bl2) {
                    return RemoteRelocator.Reaction.BREAK_CONSUMED;
                }
                return RemoteRelocator.Reaction.BREAK;
            }
            return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
        }
        boolean bl3 = false;
        DefaultDockRelocatorEvent defaultDockRelocatorEvent = null;
        if (bl) {
            if (this.pressPointScreen != null) {
                Object object;
                Object object2 = this.operation;
                if (n != this.lastPoint.x || n2 != this.lastPoint.y) {
                    object = this.preparePut(n, n2, n - this.pressPointLocal.x, n2 - this.pressPointLocal.y, dockable);
                    if (object != null) {
                        Dockable[] dockableArray = object.getImplicit(dockable);
                        boolean bl4 = object.getOperation().isMove();
                        DefaultDockRelocatorEvent defaultDockRelocatorEvent2 = new DefaultDockRelocatorEvent(this.getController(), dockable, dockableArray, object.getStation(), point, bl4);
                        this.fireCanceled(defaultDockRelocatorEvent2);
                        if (defaultDockRelocatorEvent2.isCanceled() || defaultDockRelocatorEvent2.isForbidden()) {
                            object = null;
                        } else if (defaultDockRelocatorEvent2.isIgnored()) {
                            return RemoteRelocator.Reaction.CONTINUE;
                        }
                    }
                    if (object2 != null && (object == null || object2.getStation() != object.getStation())) {
                        object2.destroy((RelocateOperation)object);
                    }
                    object2 = object;
                }
                if (object2 != null) {
                    object = object2.getImplicit(dockable);
                    boolean bl5 = object2.getOperation().isMove();
                    DefaultDockRelocatorEvent defaultDockRelocatorEvent3 = new DefaultDockRelocatorEvent(this.getController(), dockable, (Dockable[])object, object2.getStation(), point, bl5);
                    defaultDockRelocatorEvent3.drop();
                    this.fireDropping(defaultDockRelocatorEvent3);
                    if (defaultDockRelocatorEvent3.isCanceled() || defaultDockRelocatorEvent3.isForbidden()) {
                        object2.destroy(null);
                        object2 = null;
                    } else if (defaultDockRelocatorEvent3.isIgnored()) {
                        return RemoteRelocator.Reaction.CONTINUE;
                    }
                }
                if (object2 != null) {
                    object = object2.getImplicit(dockable);
                    boolean bl6 = !this.executeOperation(dockable, (RelocateOperation)object2);
                    object2.destroy(null);
                    this.operation = null;
                    defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, (Dockable[])object, object2.getStation(), point, object2.getOperation().isMove());
                    if (bl6) {
                        defaultDockRelocatorEvent.cancel();
                        this.fireCanceled(defaultDockRelocatorEvent);
                        defaultDockRelocatorEvent = null;
                    }
                    bl3 = true;
                } else {
                    object = new DefaultDockRelocatorEvent(this.getController(), dockable, new Dockable[0], null, point, false);
                    ((DefaultDockRelocatorEvent)object).cancel();
                    this.fireCanceled((DockRelocatorEvent)object);
                }
            }
            if (this.movingImageWindow != null) {
                this.movingImageWindow.close();
            }
            this.lastItem = null;
            if (this.dragOperation != null) {
                this.dragOperation.canceled();
                this.dragOperation = null;
            }
            this.movingImageWindow = null;
            this.pressPointScreen = null;
            this.pressPointLocal = null;
        }
        if (defaultDockRelocatorEvent != null) {
            this.fireDropped(defaultDockRelocatorEvent);
        }
        if (bl) {
            this.disableAllModes();
            return bl3 ? RemoteRelocator.Reaction.BREAK_CONSUMED : RemoteRelocator.Reaction.BREAK;
        }
        return bl3 ? RemoteRelocator.Reaction.CONTINUE_CONSUMED : RemoteRelocator.Reaction.CONTINUE;
    }

    private RemoteRelocator.Reaction onBreak(DefaultDockRelocatorEvent defaultDockRelocatorEvent) {
        if (defaultDockRelocatorEvent.isIgnored()) {
            return RemoteRelocator.Reaction.BREAK;
        }
        return RemoteRelocator.Reaction.BREAK_CONSUMED;
    }

    private RemoteRelocator.Reaction onContinue(DefaultDockRelocatorEvent defaultDockRelocatorEvent) {
        if (defaultDockRelocatorEvent.isIgnored()) {
            return RemoteRelocator.Reaction.CONTINUE;
        }
        return RemoteRelocator.Reaction.CONTINUE_CONSUMED;
    }

    @Override
    public void cancel() {
        if (this.operation != null) {
            this.cancel(this.operation.getOperation().getItem());
        }
    }

    private void cancel(Dockable dockable) {
        this.titleDragCancel();
        this.onMove = false;
        DefaultDockRelocatorEvent defaultDockRelocatorEvent = new DefaultDockRelocatorEvent(this.getController(), dockable, new Dockable[0], null, null, false);
        defaultDockRelocatorEvent.cancel();
        this.fireCanceled(defaultDockRelocatorEvent);
    }

    private void titleDragCancel() {
        if (!this.isOnPut()) {
            if (this.operation != null) {
                this.operation.destroy(null);
                this.operation = null;
            }
            if (this.dragOperation != null) {
                this.dragOperation.canceled();
                this.dragOperation = null;
            }
            if (this.movingImageWindow != null) {
                this.movingImageWindow.close();
            }
            this.lastItem = null;
            this.movingImageWindow = null;
            this.pressPointScreen = null;
            this.pressPointLocal = null;
        }
    }

    private ImageWindow getTitleWindow(Dockable dockable, DockTitle dockTitle) {
        DockController dockController = this.getController();
        DockableMovingImageFactory dockableMovingImageFactory = dockController.getProperties().get(DockTheme.DOCKABLE_MOVING_IMAGE_FACTORY);
        MovingImage movingImage = dockTitle == null ? dockableMovingImageFactory.create(dockController, dockable) : dockableMovingImageFactory.create(dockController, dockTitle);
        if (movingImage == null) {
            return null;
        }
        Window window = dockTitle == null ? SwingUtilities.getWindowAncestor(dockable.getComponent()) : SwingUtilities.getWindowAncestor(dockTitle.getComponent());
        ImageWindow imageWindow = new ImageWindow(window, movingImage);
        imageWindow.pack();
        return imageWindow;
    }

    private class DefaultRemoteRelocator
    implements RemoteRelocator,
    DirectRemoteRelocator {
        private Dockable dockable;
        private DockTitle title;
        private boolean forceDrag;
        private boolean showMovingImage = true;

        public DefaultRemoteRelocator(Dockable dockable, boolean bl) {
            this.dockable = dockable;
            this.forceDrag = bl;
        }

        @Override
        public void setTitle(DockTitle dockTitle) {
            this.title = dockTitle;
        }

        @Override
        public void setShowImageWindow(boolean bl) {
            this.showMovingImage = bl;
        }

        @Override
        public void cancel() {
            DefaultDockRelocator.this.titleDragCancel();
            DefaultDockRelocator.this.onMove = false;
        }

        @Override
        public void drag(int n, int n2, boolean bl) {
            DefaultDockRelocator.this.dragMouseDragged(n, n2, 1024, this.title, this.dockable, bl, this.forceDrag, this.showMovingImage);
        }

        @Override
        public RemoteRelocator.Reaction drag(int n, int n2, int n3) {
            return DefaultDockRelocator.this.dragMouseDragged(n, n2, n3, this.title, this.dockable, false, this.forceDrag, this.showMovingImage);
        }

        @Override
        public void drop(int n, int n2) {
            this.drop(n, n2, 0);
        }

        @Override
        public RemoteRelocator.Reaction drop(int n, int n2, int n3) {
            return DefaultDockRelocator.this.dragMouseReleased(n, n2, n3, this.dockable);
        }

        @Override
        public void init(int n, int n2, int n3, int n4) {
            this.init(n, n2, n3, n4, 1024);
        }

        @Override
        public RemoteRelocator.Reaction init(int n, int n2, int n3, int n4, int n5) {
            return DefaultDockRelocator.this.dragMousePressed(n, n2, n3, n4, n5, this.dockable, this.forceDrag);
        }
    }

    private class GlobalMouseReleaseListener
    extends MouseInputAdapter {
        private boolean enabled = false;
        private PropertyValue<Boolean> autoCancel = new PropertyValue<Boolean>(AUTO_DROP_ON_ANY_MOUSE_RELEASED_EVENT){

            @Override
            protected void valueChanged(Boolean bl, Boolean bl2) {
                GlobalMouseReleaseListener.this.setEnabled(bl2);
            }
        };

        private GlobalMouseReleaseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            MouseRepresentativeListener mouseRepresentativeListener = DefaultDockRelocator.this.listeners.lastActiveListener;
            if (DefaultDockRelocator.this.isOnMove() && !DefaultDockRelocator.this.isOnPut() && !mouseEvent.isConsumed() && mouseRepresentativeListener != null) {
                mouseRepresentativeListener.mouseReleased(mouseEvent);
            }
        }

        public void link() {
            this.autoCancel.setProperties(DefaultDockRelocator.this.getController());
            this.setEnabled(this.autoCancel.getValue());
        }

        public void setEnabled(boolean bl) {
            if (this.enabled != bl) {
                this.enabled = bl;
                GlobalMouseDispatcher globalMouseDispatcher = DefaultDockRelocator.this.getController().getGlobalMouseDispatcher();
                if (bl) {
                    globalMouseDispatcher.addMouseListener(this);
                } else {
                    globalMouseDispatcher.removeMouseListener(this);
                }
            }
        }
    }

    private class ImageWindow
    extends JWindow {
        private MovingImage image;

        public ImageWindow(Window window, MovingImage movingImage) {
            super(window);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                }

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    if (ImageWindow.this != DefaultDockRelocator.this.movingImageWindow) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ImageWindow.this.close();
                            }
                        });
                    }
                }
            });
            Container container = this.getContentPane();
            container.setLayout(new GridLayout(1, 1));
            this.setFocusableWindowState(false);
            try {
                this.setAlwaysOnTop(true);
            }
            catch (SecurityException securityException) {}
            boolean bl = Workarounds.getDefault().setTranslucent(this);
            movingImage.bind(bl);
            container.add(movingImage.getComponent());
            this.image = movingImage;
        }

        public MovingImage getImage() {
            return this.image;
        }

        public void close() {
            this.dispose();
            if (this.image != null) {
                this.image.unbind();
                this.image = null;
            }
            this.getContentPane().removeAll();
        }
    }

    private class Listener
    implements DockControllerRepresentativeListener {
        private Map<DockElementRepresentative, MouseRepresentativeListener> listeners = new HashMap<DockElementRepresentative, MouseRepresentativeListener>();
        private MouseRepresentativeListener lastActiveListener = null;

        private Listener() {
        }

        @Override
        public void representativeAdded(DockController dockController, DockElementRepresentative dockElementRepresentative) {
            if (dockElementRepresentative.getElement().asDockable() != null) {
                MouseRepresentativeListener mouseRepresentativeListener = new MouseRepresentativeListener(this, dockElementRepresentative);
                this.listeners.put(dockElementRepresentative, mouseRepresentativeListener);
                dockElementRepresentative.addMouseInputListener(mouseRepresentativeListener);
            }
        }

        @Override
        public void representativeRemoved(DockController dockController, DockElementRepresentative dockElementRepresentative) {
            if (dockElementRepresentative.getElement().asDockable() != null) {
                MouseRepresentativeListener mouseRepresentativeListener = this.listeners.remove(dockElementRepresentative);
                if (mouseRepresentativeListener != null) {
                    dockElementRepresentative.removeMouseInputListener(mouseRepresentativeListener);
                }
                if (mouseRepresentativeListener == this.lastActiveListener) {
                    this.lastActiveListener = null;
                }
            }
        }

        public void unsetLastActiveListener() {
            this.lastActiveListener = null;
        }
    }

    private class MouseRepresentativeListener
    extends MouseInputAdapter {
        private DockTitle title;
        private Dockable dockable;
        private DockElementRepresentative representative;
        private Listener parent;

        public MouseRepresentativeListener(Listener listener, DockElementRepresentative dockElementRepresentative) {
            this.parent = listener;
            this.representative = dockElementRepresentative;
            if (dockElementRepresentative instanceof DockTitle) {
                this.title = (DockTitle)dockElementRepresentative;
            }
            this.dockable = dockElementRepresentative.getElement().asDockable();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitle()) {
                return;
            }
            DefaultDockRelocator.this.dragMousePressed(mouseEvent, this.title, this.dockable);
            this.setLastActiveToThis();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitle()) {
                return;
            }
            DefaultDockRelocator.this.dragMouseReleased(mouseEvent, this.title, this.dockable);
            this.setLastActiveToThis();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!this.representative.isUsedAsTitle() && DefaultDockRelocator.this.isDragOnlyTitle()) {
                return;
            }
            DefaultDockRelocator.this.dragMouseDragged(mouseEvent, this.title, this.dockable);
            this.setLastActiveToThis();
        }

        private void setLastActiveToThis() {
            this.parent.lastActiveListener = this;
        }
    }
}

