/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.DockRelocator;
import bibliothek.gui.dock.control.DockRelocatorMode;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.Inserter;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractDockRelocator
implements DockRelocator {
    private List<VetoableDockRelocatorListener> vetoableListeners = new ArrayList<VetoableDockRelocatorListener>();
    private DockController controller;
    private int dragDistance = 10;
    private boolean dragOnlyTitle = false;
    private List<DockRelocatorMode> modes = new ArrayList<DockRelocatorMode>();
    private Set<DockRelocatorMode> activeModes = new HashSet<DockRelocatorMode>();
    private Merger merger = null;
    private Inserter inserter = null;

    public AbstractDockRelocator(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addVetoableDockRelocatorListener(VetoableDockRelocatorListener vetoableDockRelocatorListener) {
        if (vetoableDockRelocatorListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.vetoableListeners.add(vetoableDockRelocatorListener);
    }

    @Override
    public void removeVetoableDockRelocatorListener(VetoableDockRelocatorListener vetoableDockRelocatorListener) {
        this.vetoableListeners.remove(vetoableDockRelocatorListener);
    }

    protected VetoableDockRelocatorListener[] vetoableListeners() {
        return this.vetoableListeners.toArray(new VetoableDockRelocatorListener[this.vetoableListeners.size()]);
    }

    protected void fireGrabbing(DockRelocatorEvent dockRelocatorEvent) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener vetoableDockRelocatorListener = vetoableDockRelocatorListenerArray[n2];
            vetoableDockRelocatorListener.grabbing(dockRelocatorEvent);
            ++n2;
        }
    }

    protected void fireGrabbed(DockRelocatorEvent dockRelocatorEvent) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener vetoableDockRelocatorListener = vetoableDockRelocatorListenerArray[n2];
            vetoableDockRelocatorListener.grabbed(dockRelocatorEvent);
            ++n2;
        }
    }

    protected void fireSearched(DockRelocatorEvent dockRelocatorEvent) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener vetoableDockRelocatorListener = vetoableDockRelocatorListenerArray[n2];
            vetoableDockRelocatorListener.searched(dockRelocatorEvent);
            ++n2;
        }
    }

    protected void fireDragged(DockRelocatorEvent dockRelocatorEvent) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener vetoableDockRelocatorListener = vetoableDockRelocatorListenerArray[n2];
            vetoableDockRelocatorListener.dragged(dockRelocatorEvent);
            ++n2;
        }
    }

    protected void fireDragging(DockRelocatorEvent dockRelocatorEvent) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener vetoableDockRelocatorListener = vetoableDockRelocatorListenerArray[n2];
            vetoableDockRelocatorListener.dragging(dockRelocatorEvent);
            ++n2;
        }
    }

    protected void fireDropping(DockRelocatorEvent dockRelocatorEvent) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener vetoableDockRelocatorListener = vetoableDockRelocatorListenerArray[n2];
            vetoableDockRelocatorListener.dropping(dockRelocatorEvent);
            ++n2;
        }
    }

    protected void fireDropped(DockRelocatorEvent dockRelocatorEvent) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener vetoableDockRelocatorListener = vetoableDockRelocatorListenerArray[n2];
            vetoableDockRelocatorListener.dropped(dockRelocatorEvent);
            ++n2;
        }
    }

    protected void fireCanceled(DockRelocatorEvent dockRelocatorEvent) {
        VetoableDockRelocatorListener[] vetoableDockRelocatorListenerArray = this.vetoableListeners();
        int n = vetoableDockRelocatorListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            VetoableDockRelocatorListener vetoableDockRelocatorListener = vetoableDockRelocatorListenerArray[n2];
            vetoableDockRelocatorListener.canceled(dockRelocatorEvent);
            ++n2;
        }
    }

    @Override
    public boolean isDragOnlyTitle() {
        return this.dragOnlyTitle;
    }

    @Override
    public void setDragOnlyTitle(boolean bl) {
        this.dragOnlyTitle = bl;
    }

    @Override
    public int getDragDistance() {
        return this.dragDistance;
    }

    @Override
    public void setDragDistance(int n) {
        this.dragDistance = n;
    }

    @Override
    public Merger getMerger() {
        return this.merger;
    }

    @Override
    public void setMerger(Merger merger) {
        this.merger = merger;
    }

    @Override
    public void setInserter(Inserter inserter) {
        this.inserter = inserter;
    }

    @Override
    public Inserter getInserter() {
        return this.inserter;
    }

    @Override
    public void addMode(DockRelocatorMode dockRelocatorMode) {
        if (dockRelocatorMode == null) {
            throw new IllegalArgumentException("Mode must not be null");
        }
        this.modes.add(dockRelocatorMode);
    }

    @Override
    public void removeMode(DockRelocatorMode dockRelocatorMode) {
        if (this.activeModes.remove(dockRelocatorMode)) {
            dockRelocatorMode.setActive(this.controller, false);
        }
        this.modes.remove(dockRelocatorMode);
    }

    protected void disableAllModes() {
        for (DockRelocatorMode dockRelocatorMode : this.activeModes) {
            dockRelocatorMode.setActive(this.controller, false);
        }
        this.activeModes.clear();
    }

    protected void checkModes(int n) {
        for (DockRelocatorMode dockRelocatorMode : this.modes) {
            boolean bl = dockRelocatorMode.shouldBeActive(this.controller, n);
            if (bl) {
                if (!this.activeModes.add(dockRelocatorMode)) continue;
                dockRelocatorMode.setActive(this.controller, true);
                continue;
            }
            if (!this.activeModes.remove(dockRelocatorMode)) continue;
            dockRelocatorMode.setActive(this.controller, false);
        }
    }
}

