/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.event.FocusVetoListener;
import java.awt.Component;
import java.awt.KeyboardFocusManager;

public class RepeatingFocusRequest
implements FocusRequest {
    private int delay;
    private int attempts;
    private DockElementRepresentative source;
    private Component component;
    private boolean hardRequest;

    public RepeatingFocusRequest(DockElementRepresentative dockElementRepresentative, Component component, boolean bl) {
        this(dockElementRepresentative, component, 10, 20, bl);
    }

    public RepeatingFocusRequest(DockElementRepresentative dockElementRepresentative, Component component, int n, int n2, boolean bl) {
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("delay must be >= 1: " + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("attempts must be >= 1: " + n2);
        }
        this.source = dockElementRepresentative;
        this.component = component;
        this.delay = n;
        this.attempts = n2;
        this.hardRequest = bl;
    }

    @Override
    public boolean validate(FocusController focusController) {
        return true;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public DockElementRepresentative getSource() {
        return this.source;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public boolean acceptable(Component component) {
        return this.component == component;
    }

    @Override
    public boolean isHardRequest() {
        return this.hardRequest;
    }

    @Override
    public void veto(FocusVetoListener.FocusVeto focusVeto) {
    }

    @Override
    public FocusRequest grant(Component component) {
        --this.attempts;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (keyboardFocusManager.getPermanentFocusOwner() != component) {
            keyboardFocusManager.clearGlobalFocusOwner();
            component.requestFocus();
        }
        if (this.attempts > 0) {
            return this;
        }
        return null;
    }
}

