/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class FocusTracker {
    private Component lastFocused;
    private Component root;
    private FocusListener focusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            FocusTracker.this.lastFocused = focusEvent.getComponent();
        }
    };
    private ContainerListener containerListener = new ContainerListener(){

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            FocusTracker.this.remove(containerEvent.getChild());
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            FocusTracker.this.add(containerEvent.getChild());
        }
    };

    public FocusTracker(Component component) {
        this.root = component;
        this.add(component);
    }

    public void destroy() {
        this.remove(this.root);
    }

    public Component getLastFocused() {
        return this.lastFocused;
    }

    protected void add(Component component) {
        component.addFocusListener(this.focusListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this.containerListener);
            int n = 0;
            int n2 = container.getComponentCount();
            while (n < n2) {
                this.add(container.getComponent(n));
                ++n;
            }
        }
    }

    protected void remove(Component component) {
        if (this.lastFocused == component) {
            this.lastFocused = null;
        }
        component.removeFocusListener(this.focusListener);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this.containerListener);
            int n = 0;
            int n2 = container.getComponentCount();
            while (n < n2) {
                this.remove(container.getComponent(n));
                ++n;
            }
        }
    }
}

