/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.control.focus.RepeatingFocusRequest;
import bibliothek.gui.dock.event.FocusVetoListener;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Stack;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;

public class EnsuringFocusRequest
implements FocusRequest {
    private Dockable dockable;
    private boolean dockableOnly;
    private Component mouseClicked;

    public EnsuringFocusRequest(Dockable dockable, boolean bl) {
        this(dockable, bl, null);
    }

    public EnsuringFocusRequest(Dockable dockable, boolean bl, Component component) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockable = dockable;
        this.dockableOnly = bl;
        this.mouseClicked = component;
    }

    @Override
    public DockElementRepresentative getSource() {
        return this.dockable;
    }

    @Override
    public Component getComponent() {
        return this.mouseClicked;
    }

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public boolean isHardRequest() {
        return false;
    }

    @Override
    public void veto(FocusVetoListener.FocusVeto focusVeto) {
    }

    @Override
    public boolean acceptable(Component component) {
        if (this.dockableOnly) {
            return SwingUtilities.isDescendingFrom(component, this.dockable.getComponent());
        }
        return true;
    }

    @Override
    public boolean validate(FocusController focusController) {
        DockElement dockElement;
        if (focusController.getFocusedDockable() != this.dockable) {
            return false;
        }
        Stack<Dockable> stack = new Stack<Dockable>();
        Dockable dockable = this.dockable;
        while (dockable != null) {
            dockElement = dockable.getDockParent();
            if (dockElement != null) {
                stack.push(dockable);
            }
            Dockable dockable2 = dockable = dockElement == null ? null : dockElement.asDockable();
        }
        while (!stack.isEmpty()) {
            dockElement = (Dockable)stack.pop();
            dockElement.getDockParent().setFrontDockable((Dockable)dockElement);
        }
        if (!this.dockableOnly) {
            dockElement = this.dockable.listBoundTitles();
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (component != null) {
                if (SwingUtilities.isDescendingFrom(component, this.dockable.getComponent())) {
                    return false;
                }
                DockElement dockElement2 = dockElement;
                int n = ((DockElement)dockElement2).length;
                int n2 = 0;
                while (n2 < n) {
                    DockElement dockElement3 = dockElement2[n2];
                    if (SwingUtilities.isDescendingFrom(component, dockElement3.getComponent())) {
                        return false;
                    }
                    ++n2;
                }
            }
        }
        return true;
    }

    @Override
    public FocusRequest grant(Component component) {
        if (component.isFocusable()) {
            component.requestFocus();
            component.requestFocusInWindow();
            return new RepeatingFocusRequest(this.dockable, component, this.isHardRequest());
        }
        if (this.mouseClicked != null && this.mouseClicked != this.dockable.getComponent()) {
            this.mouseClicked.requestFocus();
            this.mouseClicked.requestFocusInWindow();
            return new RepeatingFocusRequest(this.dockable, this.mouseClicked, this.isHardRequest());
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(component);
        return null;
    }
}

