/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.GlobalMouseDispatcher;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.FocusAwareComponent;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.control.focus.MouseFocusObserver;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class DefaultMouseFocusObserver
implements MouseFocusObserver {
    private DockController controller;
    private VetoableDockRelocatorListener relocatorListener = new VetoableDockRelocatorAdapter(){

        @Override
        public void dropped(final DockRelocatorEvent dockRelocatorEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FocusController focusController = DefaultMouseFocusObserver.this.controller.getFocusController();
                    FocusStrategy focusStrategy = focusController.getStrategy();
                    if (focusStrategy == null || focusStrategy.shouldFocusAfterDrop(dockRelocatorEvent.getDockable())) {
                        DefaultMouseFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(dockRelocatorEvent.getDockable(), null, true));
                    }
                }
            });
        }
    };
    private GlobalMouseListener listener = new GlobalMouseListener();

    public DefaultMouseFocusObserver(DockController dockController, ControllerSetupCollection controllerSetupCollection) {
        this.controller = dockController;
        controllerSetupCollection.add(new ControllerSetupListener(){

            @Override
            public void done(DockController dockController) {
                dockController.getRelocator().addVetoableDockRelocatorListener(DefaultMouseFocusObserver.this.relocatorListener);
                GlobalMouseDispatcher globalMouseDispatcher = dockController.getGlobalMouseDispatcher();
                globalMouseDispatcher.addMouseListener(DefaultMouseFocusObserver.this.listener);
                globalMouseDispatcher.addMouseMotionListener(DefaultMouseFocusObserver.this.listener);
                globalMouseDispatcher.addMouseWheelListener(DefaultMouseFocusObserver.this.listener);
            }
        });
    }

    @Override
    public void kill() {
        this.getController().getRelocator().removeVetoableDockRelocatorListener(this.relocatorListener);
        GlobalMouseDispatcher globalMouseDispatcher = this.controller.getGlobalMouseDispatcher();
        globalMouseDispatcher.removeMouseListener(this.listener);
        globalMouseDispatcher.removeMouseMotionListener(this.listener);
        globalMouseDispatcher.removeMouseWheelListener(this.listener);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    public void check(MouseEvent mouseEvent) {
        if (this.interact(mouseEvent)) {
            this.check((AWTEvent)mouseEvent);
        }
    }

    public void check(MouseWheelEvent mouseWheelEvent) {
        if (this.interact(mouseWheelEvent)) {
            this.check((AWTEvent)mouseWheelEvent);
        }
    }

    protected void check(AWTEvent aWTEvent) {
        if (this.controller.getRelocator().isOnPut() || this.controller.isOnFocusing()) {
            return;
        }
        Object object = aWTEvent.getSource();
        if (object instanceof Component) {
            Component component = (Component)object;
            if (aWTEvent.getID() == 501) {
                if (component.isFocusable() && component.isEnabled()) {
                    this.check(component, false, true, aWTEvent);
                } else {
                    this.check(component, true, false, aWTEvent);
                }
            } else {
                this.check(component, aWTEvent);
            }
        }
    }

    protected boolean interact(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        return n == 501 || n == 507;
    }

    protected void handleVeto(AWTEvent aWTEvent, FocusVetoListener.FocusVeto focusVeto) {
        if (focusVeto == FocusVetoListener.FocusVeto.VETO && aWTEvent instanceof InputEvent) {
            ((InputEvent)aWTEvent).consume();
        }
    }

    protected void check(Component component, AWTEvent aWTEvent) {
        this.check(component, true, false, aWTEvent);
    }

    protected void check(final Component component, final boolean bl, boolean bl2, final AWTEvent aWTEvent) {
        DockElementRepresentative dockElementRepresentative = this.getDockable(component, aWTEvent);
        if (dockElementRepresentative == null) {
            return;
        }
        Dockable dockable = dockElementRepresentative.getElement().asDockable();
        if (dockable == null) {
            return;
        }
        Dockable dockable2 = this.controller.getFocusedDockable();
        boolean bl3 = true;
        if (dockable2 != null) {
            boolean bl4 = bl3 = !DockUtilities.isAncestor(dockable, dockable2);
        }
        if (bl3) {
            if (component instanceof FocusAwareComponent) {
                FocusAwareComponent focusAwareComponent = (FocusAwareComponent)((Object)component);
                if (bl2) {
                    focusAwareComponent.maybeRequestFocus();
                }
                focusAwareComponent.invokeOnFocusRequest(new Runnable(){

                    @Override
                    public void run() {
                        Dockable dockable;
                        DockElementRepresentative dockElementRepresentative = DefaultMouseFocusObserver.this.getDockable(component, aWTEvent);
                        if (dockElementRepresentative != null && (dockable = dockElementRepresentative.getElement().asDockable()) != null) {
                            DefaultMouseFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(dockable, component, false, bl, dockElementRepresentative.shouldTransfersFocus()));
                        }
                    }
                });
            } else {
                if (bl2) {
                    component.requestFocusInWindow();
                }
                this.controller.setFocusedDockable(new DefaultFocusRequest(dockable, component, false, bl, dockElementRepresentative.shouldTransfersFocus()));
            }
        }
    }

    protected DockElementRepresentative getDockable(Component component, AWTEvent aWTEvent) {
        DockElementRepresentative dockElementRepresentative = this.controller.searchElement(component);
        if (dockElementRepresentative == null) {
            return null;
        }
        if ((aWTEvent instanceof MouseEvent || aWTEvent instanceof MouseWheelEvent) && !dockElementRepresentative.shouldFocus()) {
            return null;
        }
        Dockable dockable = dockElementRepresentative.getElement().asDockable();
        if (dockable == null) {
            return null;
        }
        FocusVetoListener.FocusVeto focusVeto = this.controller.getFocusController().checkFocusedDockable(dockElementRepresentative);
        if (focusVeto != null && focusVeto != FocusVetoListener.FocusVeto.NONE) {
            this.handleVeto(aWTEvent, focusVeto);
            return null;
        }
        return dockElementRepresentative;
    }

    private class GlobalMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private GlobalMouseListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            DefaultMouseFocusObserver.this.check(mouseWheelEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            DefaultMouseFocusObserver.this.check(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            DefaultMouseFocusObserver.this.check(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            DefaultMouseFocusObserver.this.check(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            DefaultMouseFocusObserver.this.check(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            DefaultMouseFocusObserver.this.check(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            DefaultMouseFocusObserver.this.check(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            DefaultMouseFocusObserver.this.check(mouseEvent);
        }
    }
}

