/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.control.focus.FocusStrategyRequest;
import bibliothek.gui.dock.control.focus.FocusTracker;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class DefaultFocusStrategy
implements FocusStrategy {
    private DockController controller;
    private Map<Component, Tracker> trackers = new HashMap<Component, Tracker>();
    private DockRegisterListener listener = new DockRegisterAdapter(){

        @Override
        public void dockableRegistered(DockController dockController, Dockable dockable) {
            DefaultFocusStrategy.this.add(dockable);
        }

        @Override
        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            DefaultFocusStrategy.this.remove(dockable);
        }
    };

    public DefaultFocusStrategy(DockController dockController) {
        this.controller = dockController;
    }

    @Override
    public boolean shouldFocusAfterDrop(Dockable dockable) {
        return !(dockable.getDockParent() instanceof FlapDockStation);
    }

    protected boolean focusable(Component component, FocusStrategyRequest focusStrategyRequest) {
        while (component != null) {
            if (component instanceof JComboBox) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    protected boolean excluded(Component component, FocusStrategyRequest focusStrategyRequest) {
        return focusStrategyRequest.excluded(component);
    }

    @Override
    public Component getFocusComponent(FocusStrategyRequest focusStrategyRequest) {
        Component component = focusStrategyRequest.getMouseClicked();
        Dockable dockable = focusStrategyRequest.getDockable();
        if (component != null && (component.isFocusable() && !this.excluded(component, focusStrategyRequest) || this.focusable(component, focusStrategyRequest))) {
            return component;
        }
        Tracker tracker = this.trackers.get(dockable.getComponent());
        if (tracker == null) {
            return null;
        }
        return tracker.getLastFocused();
    }

    @Override
    public void bind() {
        DockRegister dockRegister = this.controller.getRegister();
        dockRegister.addDockRegisterListener(this.listener);
        int n = 0;
        int n2 = dockRegister.getDockableCount();
        while (n < n2) {
            this.add(dockRegister.getDockable(n));
            ++n;
        }
    }

    @Override
    public void unbind() {
        this.controller.getRegister().removeDockRegisterListener(this.listener);
        for (Tracker tracker : this.trackers.values()) {
            tracker.destroy();
        }
        this.trackers.clear();
    }

    private void add(Dockable dockable) {
        Tracker tracker = new Tracker(dockable);
        for (Tracker tracker2 : this.trackers.values()) {
            if (!SwingUtilities.isDescendingFrom(dockable.getComponent(), tracker2.dockable.getComponent())) continue;
            tracker2.remove(dockable.getComponent());
        }
        this.trackers.put(dockable.getComponent(), tracker);
    }

    private void remove(Dockable dockable) {
        Tracker tracker = this.trackers.remove(dockable.getComponent());
        if (tracker != null) {
            tracker.destroy();
        }
    }

    private class Tracker
    extends FocusTracker {
        private Dockable dockable;

        public Tracker(Dockable dockable) {
            super(dockable.getComponent());
            this.dockable = dockable;
        }

        @Override
        protected void add(Component component) {
            if (!DefaultFocusStrategy.this.trackers.containsKey(component)) {
                super.add(component);
            }
        }
    }
}

