/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.EnsuringFocusRequest;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.control.focus.RepeatingFocusRequest;
import bibliothek.gui.dock.event.FocusVetoListener;
import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;

public class DefaultFocusRequest
implements FocusRequest {
    private DockElementRepresentative source;
    private Component component;
    private boolean force;
    private boolean ensureFocusSet;
    private boolean ensureDockableFocused;
    private boolean hardRequest;
    private FocusVetoListener.FocusVeto veto;
    private DockController controller;

    public DefaultFocusRequest(DockElementRepresentative dockElementRepresentative, boolean bl) {
        this(dockElementRepresentative, null, bl);
    }

    public DefaultFocusRequest(DockElementRepresentative dockElementRepresentative, Component component, boolean bl) {
        this(dockElementRepresentative, component, bl, true, false);
    }

    public DefaultFocusRequest(DockElementRepresentative dockElementRepresentative, Component component, boolean bl, boolean bl2, boolean bl3) {
        this(dockElementRepresentative, component, bl, bl2, bl3, false);
    }

    public DefaultFocusRequest(DockElementRepresentative dockElementRepresentative, Component component, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.source = dockElementRepresentative;
        this.component = component;
        this.force = bl;
        this.ensureFocusSet = bl2;
        this.ensureDockableFocused = bl3;
        this.hardRequest = bl4;
    }

    @Override
    public DockElementRepresentative getSource() {
        return this.source;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public int getDelay() {
        return 0;
    }

    @Override
    public boolean isHardRequest() {
        return this.hardRequest;
    }

    @Override
    public boolean acceptable(Component component) {
        Dockable dockable = this.getDockable();
        if (this.ensureDockableFocused && dockable != null) {
            return SwingUtilities.isDescendingFrom(component, dockable.getComponent());
        }
        return true;
    }

    @Override
    public boolean validate(FocusController focusController) {
        this.controller = focusController.getController();
        if (this.force) {
            return true;
        }
        return focusController.getFocusedDockable() != this.getDockable();
    }

    private Dockable getDockable() {
        if (this.source == null) {
            return null;
        }
        return this.source.getElement().asDockable();
    }

    @Override
    public void veto(FocusVetoListener.FocusVeto focusVeto) {
        this.veto = focusVeto;
    }

    public FocusVetoListener.FocusVeto getVeto() {
        return this.veto;
    }

    @Override
    public FocusRequest grant(Component component) {
        Window window;
        Dockable dockable = this.getDockable();
        if (dockable != null && (this.ensureFocusSet || this.ensureDockableFocused)) {
            return new EnsuringFocusRequest(dockable, this.ensureDockableFocused, component);
        }
        if (component == null && this.controller != null && (window = this.controller.getRootWindowProvider().searchWindow()) != null) {
            return new RepeatingFocusRequest(null, window, this.isHardRequest());
        }
        return null;
    }
}

