/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.focus.FocusHistory;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Filter;
import java.util.LinkedList;
import java.util.List;

public class DefaultFocusHistory
implements FocusHistory {
    private DockController controller;
    private List<Dockable> history = new LinkedList<Dockable>();
    private List<Dockable> unfocused = new LinkedList<Dockable>();
    private Listener listener = new Listener();

    public void setController(DockController dockController) {
        if (this.controller != null) {
            this.controller.getRegister().removeDockRegisterListener(this.listener);
            this.controller.getFocusController().removeDockableFocusListener(this.listener);
        }
        this.history.clear();
        this.controller = dockController;
        if (this.controller != null) {
            this.controller.getRegister().addDockRegisterListener(this.listener);
            this.controller.getFocusController().addDockableFocusListener(this.listener);
        }
    }

    @Override
    public Dockable[] getHistory() {
        Dockable[] dockableArray = new Dockable[this.unfocused.size() + this.history.size()];
        int n = 0;
        for (Dockable dockable : this.unfocused) {
            dockableArray[n++] = dockable;
        }
        n = dockableArray.length - 1;
        for (Dockable dockable : this.history) {
            dockableArray[n--] = dockable;
        }
        return dockableArray;
    }

    @Override
    public Dockable getNewestOn(DockStation ... dockStationArray) {
        for (Dockable dockable : this.history) {
            DockStation[] dockStationArray2 = dockStationArray;
            int n = dockStationArray.length;
            int n2 = 0;
            while (n2 < n) {
                DockStation dockStation = dockStationArray2[n2];
                if (dockable != dockStation && DockUtilities.isAncestor(dockStation, dockable)) {
                    return dockable;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public Dockable getFirst(Filter<Dockable> filter) {
        for (Dockable dockable : this.history) {
            if (!filter.includes(dockable)) continue;
            return dockable;
        }
        return null;
    }

    private class Listener
    extends DockRegisterAdapter
    implements DockableFocusListener {
        private Listener() {
        }

        @Override
        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            DefaultFocusHistory.this.history.remove(dockable);
            DefaultFocusHistory.this.unfocused.remove(dockable);
        }

        @Override
        public void dockableRegistered(DockController dockController, Dockable dockable) {
            if (!DefaultFocusHistory.this.unfocused.contains(dockable) && !DefaultFocusHistory.this.history.contains(dockable)) {
                DefaultFocusHistory.this.unfocused.add(dockable);
            }
        }

        @Override
        public void dockableFocused(DockableFocusEvent dockableFocusEvent) {
            Dockable dockable = dockableFocusEvent.getNewFocusOwner();
            if (dockable != null) {
                DefaultFocusHistory.this.unfocused.remove(dockable);
                DefaultFocusHistory.this.history.remove(dockable);
                DefaultFocusHistory.this.history.add(0, dockable);
            }
        }
    }
}

