/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.title.DockTitle;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFocusController
implements FocusController {
    private DockController controller;
    private FocusStrategy strategy;
    private List<DockableFocusListener> dockableFocusListeners = new ArrayList<DockableFocusListener>();
    private List<FocusVetoListener> vetos = new ArrayList<FocusVetoListener>();
    private int frozen = 0;

    public AbstractFocusController(DockController dockController) {
        this.controller = dockController;
    }

    @Override
    public void setStrategy(FocusStrategy focusStrategy) {
        if (this.strategy != focusStrategy) {
            if (this.strategy != null) {
                this.strategy.unbind();
            }
            this.strategy = focusStrategy;
            if (focusStrategy != null) {
                focusStrategy.bind();
            }
        }
    }

    @Override
    public FocusStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void freezeFocus() {
        ++this.frozen;
    }

    @Override
    public void meltFocus() {
        --this.frozen;
    }

    protected boolean isFrozen() {
        return this.frozen > 0;
    }

    @Override
    public void addVetoListener(FocusVetoListener focusVetoListener) {
        this.vetos.add(focusVetoListener);
    }

    @Override
    public void removeVetoListener(FocusVetoListener focusVetoListener) {
        this.vetos.remove(focusVetoListener);
    }

    protected FocusVetoListener.FocusVeto fireVetoTitle(DockTitle dockTitle) {
        FocusVetoListener[] focusVetoListenerArray = this.vetos.toArray(new FocusVetoListener[this.vetos.size()]);
        int n = focusVetoListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FocusVetoListener focusVetoListener = focusVetoListenerArray[n2];
            FocusVetoListener.FocusVeto focusVeto = focusVetoListener.vetoFocus((FocusController)this, dockTitle);
            if (focusVeto != FocusVetoListener.FocusVeto.NONE) {
                return focusVeto;
            }
            ++n2;
        }
        return FocusVetoListener.FocusVeto.NONE;
    }

    protected FocusVetoListener.FocusVeto fireVetoDockable(Dockable dockable) {
        FocusVetoListener[] focusVetoListenerArray = this.vetos.toArray(new FocusVetoListener[this.vetos.size()]);
        int n = focusVetoListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            FocusVetoListener focusVetoListener = focusVetoListenerArray[n2];
            FocusVetoListener.FocusVeto focusVeto = focusVetoListener.vetoFocus((FocusController)this, dockable);
            if (focusVeto != FocusVetoListener.FocusVeto.NONE) {
                return focusVeto;
            }
            ++n2;
        }
        return FocusVetoListener.FocusVeto.NONE;
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    @Override
    public void addDockableFocusListener(DockableFocusListener dockableFocusListener) {
        if (dockableFocusListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableFocusListeners.add(dockableFocusListener);
    }

    @Override
    public void removeDockableFocusListener(DockableFocusListener dockableFocusListener) {
        if (dockableFocusListener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.dockableFocusListeners.remove(dockableFocusListener);
    }

    protected DockableFocusListener[] dockableFocusListeners() {
        return this.dockableFocusListeners.toArray(new DockableFocusListener[this.dockableFocusListeners.size()]);
    }

    protected void fireDockableFocused(Dockable dockable, Dockable dockable2) {
        DockableFocusEvent dockableFocusEvent = new DockableFocusEvent(this.controller, dockable, dockable2);
        DockableFocusListener[] dockableFocusListenerArray = this.dockableFocusListeners();
        int n = dockableFocusListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockableFocusListener dockableFocusListener = dockableFocusListenerArray[n2];
            dockableFocusListener.dockableFocused(dockableFocusEvent);
            ++n2;
        }
    }
}

