/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockStationAdapter;

public class VisibilityFocusObserver
extends DockRegisterAdapter {
    private StationListener listener = new StationListener();
    private DockController controller;

    public VisibilityFocusObserver(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
    }

    @Override
    public void dockStationRegistered(DockController dockController, DockStation dockStation) {
        dockStation.addDockStationListener(this.listener);
    }

    @Override
    public void dockStationUnregistered(DockController dockController, DockStation dockStation) {
        dockStation.removeDockStationListener(this.listener);
    }

    @Override
    public void dockableUnregistered(DockController dockController, Dockable dockable) {
        if (dockable == dockController.getFocusedDockable()) {
            dockController.setFocusedDockable(new DefaultFocusRequest(null, null, false));
        }
    }

    private class StationListener
    extends DockStationAdapter {
        private StationListener() {
        }

        @Override
        public void dockableAdded(DockStation dockStation, Dockable dockable) {
            Dockable dockable2;
            if (!VisibilityFocusObserver.this.controller.getRelocator().isOnPut() && (dockable == (dockable2 = VisibilityFocusObserver.this.controller.getFocusedDockable()) || dockable2 == null) && dockable.isDockableShowing()) {
                VisibilityFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(dockable, null, true));
            }
        }

        @Override
        public void dockableShowingChanged(DockStation dockStation, Dockable dockable, boolean bl) {
            if (!VisibilityFocusObserver.this.controller.isOnFocusing() && !bl && VisibilityFocusObserver.this.controller.isFocused(dockable)) {
                DockStation dockStation2 = dockable.getDockParent();
                while (dockStation2 != null) {
                    dockable = dockStation2.asDockable();
                    if (dockable == null) break;
                    dockStation2 = dockable.getDockParent();
                    if (dockStation2 == null || !dockStation2.isChildShowing(dockable)) continue;
                    VisibilityFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(dockable, null, false));
                    return;
                }
                VisibilityFocusObserver.this.controller.setFocusedDockable(new DefaultFocusRequest(null, null, false));
            }
        }
    }
}

