/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.event.DockRegisterAdapter;

public class SingleParentRemover {
    private DockController controller;
    private DockRelocatorObserver dockRelocatorObserver = new DockRelocatorObserver();
    private DockRegisterObserver dockRegisterObserver = new DockRegisterObserver();
    private boolean onTest = false;

    public void install(DockController dockController) {
        if (this.controller != null) {
            throw new IllegalStateException("a controller is already installed");
        }
        this.controller = dockController;
        dockController.getRelocator().addVetoableDockRelocatorListener(this.dockRelocatorObserver);
        dockController.getRegister().addDockRegisterListener(this.dockRegisterObserver);
        this.testAll(dockController);
    }

    public void uninstall(DockController dockController) {
        if (this.controller != dockController) {
            throw new IllegalArgumentException("controller is not installed");
        }
        dockController.getRelocator().removeVetoableDockRelocatorListener(this.dockRelocatorObserver);
        dockController.getRegister().removeDockRegisterListener(this.dockRegisterObserver);
        this.controller = null;
    }

    public void testAll(DockController dockController) {
        if (this.onTest) {
            return;
        }
        try {
            this.onTest = true;
            dockController.getRegister().setStalled(true);
            int n = 0;
            while (n < dockController.getRegister().getStationCount()) {
                if (this.test(dockController.getRegister().getStation(n))) {
                    n = 0;
                    continue;
                }
                ++n;
            }
        }
        finally {
            dockController.getRegister().setStalled(false);
            this.onTest = false;
        }
    }

    protected boolean shouldTest(DockStation dockStation) {
        return true;
    }

    protected boolean test(DockStation dockStation) {
        DockController dockController = dockStation.getController();
        if (dockController != null) {
            dockController.getRegister().setStalled(true);
            dockController.getHierarchyLock().setConcurrent(true);
        }
        try {
            if (!this.shouldTest(dockStation)) {
                return false;
            }
            if (dockStation.getDockableCount() > 1) {
                return false;
            }
            Dockable dockable = dockStation.asDockable();
            if (dockable == null) {
                return false;
            }
            DockStation dockStation2 = dockable.getDockParent();
            if (dockStation2 == null) {
                return false;
            }
            if (dockStation2.getController() == null) {
                return false;
            }
            if (dockStation.getDockableCount() == 0) {
                if (!dockStation2.canDrag(dockable)) {
                    return false;
                }
                dockStation2.drag(dockable);
                return true;
            }
            Dockable dockable2 = dockStation.getDockable(0);
            if (!dockStation.canDrag(dockable2)) {
                return false;
            }
            if (!dockStation2.accept(dockable2) || !dockable2.accept(dockStation2)) {
                return false;
            }
            if (!dockStation2.canReplace(dockable, dockable2)) {
                return false;
            }
            MultiDockAcceptance multiDockAcceptance = dockStation.getController().getAcceptance();
            if (multiDockAcceptance != null && !multiDockAcceptance.accept(dockStation2, dockable2)) {
                return false;
            }
            dockStation.drag(dockable2);
            dockStation2.replace(dockable.asDockStation(), dockable2);
            return true;
        }
        finally {
            if (dockController != null) {
                dockController.getHierarchyLock().setConcurrent(false);
                dockController.getRegister().setStalled(false);
            }
        }
    }

    private class DockRegisterObserver
    extends DockRegisterAdapter {
        private DockRegisterObserver() {
        }

        @Override
        public void dockableCycledRegister(DockController dockController, Dockable dockable) {
            SingleParentRemover.this.testAll(dockController);
        }

        @Override
        public void dockableRegistered(DockController dockController, Dockable dockable) {
            if (!dockController.getRelocator().isOnPut()) {
                SingleParentRemover.this.testAll(dockController);
            }
        }

        @Override
        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            if (!dockController.getRelocator().isOnPut()) {
                SingleParentRemover.this.testAll(dockController);
            }
        }

        @Override
        public void dockStationRegistered(final DockController dockController, DockStation dockStation) {
            dockController.getHierarchyLock().onRelease(new Runnable(){

                @Override
                public void run() {
                    SingleParentRemover.this.testAll(dockController);
                }
            });
        }
    }

    private class DockRelocatorObserver
    extends VetoableDockRelocatorAdapter {
        private DockRelocatorObserver() {
        }

        @Override
        public void dropped(DockRelocatorEvent dockRelocatorEvent) {
            SingleParentRemover.this.testAll(SingleParentRemover.this.controller);
        }
    }
}

