/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.action.ActionPopup;
import bibliothek.gui.dock.action.ActionPopupSuppressor;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.popup.ActionPopupMenuFactory;
import bibliothek.gui.dock.action.popup.DefaultActionPopupMenuFactory;
import bibliothek.gui.dock.event.DockControllerRepresentativeListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class PopupController
implements DockControllerRepresentativeListener {
    private Map<DockElementRepresentative, ComponentObserver> listeners = new HashMap<DockElementRepresentative, ComponentObserver>();
    private DockController controller;
    private ActionPopupMenuFactory factory = new DefaultActionPopupMenuFactory();
    private ActionPopupSuppressor popupSuppressor = ActionPopupSuppressor.ALLOW_ALWAYS;
    private boolean allowOnMove = false;
    private boolean allowEmpty = false;

    public PopupController(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
        dockController.addRepresentativeListener(this);
    }

    @Override
    public void representativeAdded(DockController dockController, DockElementRepresentative dockElementRepresentative) {
        if (dockElementRepresentative.getElement().asDockable() != null) {
            ComponentObserver componentObserver = new ComponentObserver(dockElementRepresentative);
            this.listeners.put(dockElementRepresentative, componentObserver);
            dockElementRepresentative.addMouseInputListener(componentObserver);
        }
    }

    @Override
    public void representativeRemoved(DockController dockController, DockElementRepresentative dockElementRepresentative) {
        ComponentObserver componentObserver;
        if (dockElementRepresentative.getElement().asDockable() != null && (componentObserver = this.listeners.remove(dockElementRepresentative)) != null) {
            dockElementRepresentative.removeMouseInputListener(componentObserver);
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void setPopupMenuFactory(ActionPopupMenuFactory actionPopupMenuFactory) {
        if (actionPopupMenuFactory == null) {
            throw new IllegalArgumentException("the factory must not be null");
        }
        this.factory = actionPopupMenuFactory;
    }

    public ActionPopupMenuFactory getPopupMenuFactory() {
        return this.factory;
    }

    public ActionPopupSuppressor getPopupSuppressor() {
        return this.popupSuppressor;
    }

    public void setPopupSuppressor(ActionPopupSuppressor actionPopupSuppressor) {
        if (actionPopupSuppressor == null) {
            throw new IllegalArgumentException("suppressor must not be null");
        }
        this.popupSuppressor = actionPopupSuppressor;
    }

    public void setAllowEmptyMenu(boolean bl) {
        this.allowEmpty = bl;
    }

    public boolean isAllowEmptyMenu() {
        return this.allowEmpty;
    }

    public void setAllowOnMove(boolean bl) {
        this.allowOnMove = bl;
    }

    public boolean isAllowOnMove() {
        return this.allowOnMove;
    }

    private static class ComponentObserver
    extends ActionPopup {
        private DockElementRepresentative representative;
        private boolean onMouseClick = false;

        public ComponentObserver(DockElementRepresentative dockElementRepresentative) {
            super(true);
            this.representative = dockElementRepresentative;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.isMenuOpen()) {
                return;
            }
            if (this.isEnabled() && mouseEvent.getClickCount() == 1) {
                try {
                    this.onMouseClick = true;
                    this.popup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
                finally {
                    this.onMouseClick = false;
                }
            }
        }

        @Override
        protected Point getPopupLocation(Component component, Point point) {
            point = new Point(point);
            point = SwingUtilities.convertPoint(component, point, this.representative.getComponent());
            if ((point = this.representative.getPopupLocation(point, !this.onMouseClick)) == null) {
                return null;
            }
            point = new Point(point);
            return SwingUtilities.convertPoint(this.representative.getComponent(), point, component);
        }

        @Override
        protected Dockable getDockable() {
            return this.representative.getElement().asDockable();
        }

        @Override
        protected DockActionSource getActions() {
            return this.getDockable().getGlobalActionOffers();
        }

        @Override
        protected Object getSource() {
            return this.representative;
        }

        @Override
        protected boolean isEnabled() {
            return true;
        }
    }
}

