/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.control.AcceptanceDockRelocatorMode;
import bibliothek.gui.dock.control.ModifierMask;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;

public interface DockRelocatorMode {
    public static final PropertyKey<ModifierMask> SCREEN_MASK = new PropertyKey<ModifierMask>("DockRelocatorMode screen mask", new ConstantPropertyFactory<ModifierMask>(new ModifierMask(64)), false);
    public static final PropertyKey<ModifierMask> NO_COMBINATION_MASK = new PropertyKey<ModifierMask>("DockRelocatorMode no combination", new ConstantPropertyFactory<ModifierMask>(new ModifierMask(512)), false);
    public static final DockRelocatorMode NO_COMBINATION = new AcceptanceDockRelocatorMode(0, 0){

        @Override
        public boolean accept(DockStation dockStation, Dockable dockable) {
            return !(dockStation instanceof StackDockStation);
        }

        @Override
        public boolean accept(DockStation dockStation, Dockable dockable, Dockable dockable2) {
            return false;
        }

        @Override
        public boolean shouldBeActive(DockController dockController, int n) {
            ModifierMask modifierMask = (ModifierMask)dockController.getProperties().get(NO_COMBINATION_MASK);
            return modifierMask != null && modifierMask.matches(n);
        }
    };

    public boolean shouldBeActive(DockController var1, int var2);

    public void setActive(DockController var1, boolean var2);
}

