/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.LayoutLocked;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@LayoutLocked(locked=false)
public class DockRegister {
    private Set<DockStation> protectedStations = new HashSet<DockStation>();
    private List<DockStation> stations = new ArrayList<DockStation>();
    private List<Dockable> dockables = new ArrayList<Dockable>();
    private DockController controller;
    private List<DockRegisterListener> registerListeners = new ArrayList<DockRegisterListener>();
    private StationListener stationListener = new StationListener();
    private int stalled = 0;
    private Map<Dockable, Status> changeMap = new HashMap<Dockable, Status>();
    private LinkedList<Dockable> changeQueue = new LinkedList();

    public DockRegister(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public void addDockRegisterListener(DockRegisterListener dockRegisterListener) {
        this.registerListeners.add(dockRegisterListener);
    }

    public void removeDockRegisterListener(DockRegisterListener dockRegisterListener) {
        this.registerListeners.remove(dockRegisterListener);
    }

    public void kill() {
        ArrayList<DockStation> arrayList = new ArrayList<DockStation>(this.stations);
        for (DockStation dockStation : arrayList) {
            this.remove(dockStation);
        }
    }

    public void setProtected(DockStation dockStation, boolean bl) {
        if (this.stations.contains(dockStation)) {
            if (bl) {
                this.protectedStations.add(dockStation);
            } else {
                this.protectedStations.remove(dockStation);
            }
        }
    }

    public boolean isProtected(DockStation dockStation) {
        return this.protectedStations.contains(dockStation);
    }

    public void add(DockStation dockStation) {
        this.add(dockStation, true);
    }

    private void add(DockStation dockStation, final boolean bl) {
        if (dockStation == null) {
            throw new NullPointerException("Station must not be null");
        }
        if (!this.stations.contains(dockStation)) {
            DockController dockController = dockStation.getController();
            if (dockController != null && dockController != this.controller) {
                dockController.getRegister().remove(dockStation);
            }
            DockUtilities.visit(dockStation, new DockUtilities.DockVisitor(){

                @Override
                public void handleDockable(Dockable dockable) {
                    DockRegister.this.register(dockable);
                }

                @Override
                public void handleDockStation(DockStation dockStation) {
                    DockRegister.this.register(dockStation, bl);
                }
            });
        }
    }

    public void remove(DockStation dockStation) {
        if (this.stations.contains(dockStation)) {
            DockStation dockStation2;
            this.setProtected(dockStation, false);
            Dockable dockable = dockStation.asDockable();
            if (dockable != null && (dockStation2 = dockable.getDockParent()) != null) {
                dockStation2.drag(dockable);
            }
            DockUtilities.visit(dockStation, new DockUtilities.DockVisitor(){
                private Set<DockStation> ignored = new HashSet<DockStation>();

                @Override
                public void handleDockable(Dockable dockable) {
                    DockStation dockStation = dockable.asDockStation();
                    if (dockStation == null || !DockRegister.this.isProtected(dockStation)) {
                        for (DockStation dockStation2 : this.ignored) {
                            if (!DockUtilities.isAncestor(dockStation2, dockable)) continue;
                            return;
                        }
                        DockRegister.this.unregister(dockable);
                    }
                }

                @Override
                public void handleDockStation(DockStation dockStation) {
                    if (DockRegister.this.isProtected(dockStation)) {
                        this.ignored.add(dockStation);
                    } else {
                        DockRegister.this.unregister(dockStation);
                    }
                }
            });
        }
    }

    public int getStationCount() {
        return this.stations.size();
    }

    public DockStation getStation(int n) {
        return this.stations.get(n);
    }

    public DockStation[] listDockStations() {
        return this.stations.toArray(new DockStation[this.stations.size()]);
    }

    public DockStation[] listRoots() {
        LinkedList<DockStation> linkedList = new LinkedList<DockStation>();
        for (DockStation dockStation : this.stations) {
            Dockable dockable = dockStation.asDockable();
            if (dockable != null && dockable.getDockParent() != null) continue;
            linkedList.add(dockStation);
        }
        return linkedList.toArray(new DockStation[linkedList.size()]);
    }

    public int getDockableCount() {
        return this.dockables.size();
    }

    public Dockable getDockable(int n) {
        return this.dockables.get(n);
    }

    public boolean isRegistered(Dockable dockable) {
        return this.dockables.contains(dockable);
    }

    public boolean willBeRegistered(Dockable dockable) {
        Status status = this.changeMap.get(dockable);
        if (status == null) {
            return this.isRegistered(dockable);
        }
        switch (status) {
            case ADDED: 
            case REMOVED_AND_ADDED: {
                return true;
            }
            case REMOVED: 
            case ADDED_AND_REMOVED: {
                return false;
            }
        }
        throw new IllegalStateException("unexpected state: " + (Object)((Object)status));
    }

    public Dockable[] listDockables() {
        return this.dockables.toArray(new Dockable[this.dockables.size()]);
    }

    protected void register(Dockable dockable) {
        if (!this.dockables.contains(dockable)) {
            this.fireDockableRegistering(dockable);
            this.dockables.add(dockable);
            dockable.setController(this.controller);
            this.fireDockableRegistered(dockable);
        }
    }

    protected void unregister(Dockable dockable) {
        if (this.dockables.remove(dockable)) {
            dockable.setController(null);
            this.fireDockableUnregistered(dockable);
        }
    }

    protected void register(DockStation dockStation, boolean bl) {
        if (!this.stations.contains(dockStation)) {
            this.fireDockStationRegistering(dockStation);
            this.stations.add(dockStation);
            dockStation.setController(this.controller);
            dockStation.updateTheme();
            if (bl) {
                dockStation.addDockStationListener(this.stationListener);
            }
            this.fireDockStationRegistered(dockStation);
        }
    }

    protected void unregister(DockStation dockStation) {
        if (this.stations.remove(dockStation)) {
            dockStation.setController(null);
            dockStation.removeDockStationListener(this.stationListener);
            this.fireDockStationUnregistered(dockStation);
        }
    }

    protected DockRegisterListener[] listDockRegisterListeners() {
        return this.registerListeners.toArray(new DockRegisterListener[this.registerListeners.size()]);
    }

    protected void fireDockableRegistering(Dockable dockable) {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.dockableRegistering(this.controller, dockable);
            ++n2;
        }
    }

    protected void fireDockableRegistered(Dockable dockable) {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.dockableRegistered(this.controller, dockable);
            ++n2;
        }
    }

    protected void fireDockableUnregistered(Dockable dockable) {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.dockableUnregistered(this.controller, dockable);
            ++n2;
        }
    }

    protected void fireDockStationRegistering(DockStation dockStation) {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.dockStationRegistering(this.controller, dockStation);
            ++n2;
        }
    }

    protected void fireDockStationRegistered(DockStation dockStation) {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.dockStationRegistered(this.controller, dockStation);
            ++n2;
        }
    }

    protected void fireDockStationUnregistered(DockStation dockStation) {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.dockStationUnregistered(this.controller, dockStation);
            ++n2;
        }
    }

    protected void fireStalledChange(Dockable dockable) {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.dockableCycledRegister(this.controller, dockable);
            ++n2;
        }
    }

    protected void fireStalled() {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.registerStalled(this.controller);
            ++n2;
        }
    }

    protected void fireUnstalled() {
        DockRegisterListener[] dockRegisterListenerArray = this.listDockRegisterListeners();
        int n = dockRegisterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DockRegisterListener dockRegisterListener = dockRegisterListenerArray[n2];
            dockRegisterListener.registerUnstalled(this.controller);
            ++n2;
        }
    }

    public void setStalled(boolean bl) {
        if (bl) {
            boolean bl2 = this.isStalled();
            ++this.stalled;
            if (!bl2) {
                this.fireStalled();
            }
        } else {
            --this.stalled;
            if (!this.isStalled()) {
                this.fireUnstalled();
            }
        }
        if (this.stalled < 0) {
            this.stalled = 0;
        }
        if (this.stalled == 0) {
            this.stationListener.fire();
        }
    }

    public boolean isStalled() {
        return this.stalled > 0;
    }

    private class StationListener
    extends DockStationAdapter {
        private boolean firing = false;

        private StationListener() {
        }

        public void fire() {
            if (!this.firing) {
                try {
                    this.firing = true;
                    while (!DockRegister.this.changeQueue.isEmpty()) {
                        Dockable dockable = (Dockable)DockRegister.this.changeQueue.removeFirst();
                        Status status = (Status)((Object)DockRegister.this.changeMap.remove(dockable));
                        switch (status) {
                            case ADDED: {
                                this.addDockable(dockable, false);
                                break;
                            }
                            case REMOVED: {
                                this.removeDockable(dockable);
                                break;
                            }
                            case ADDED_AND_REMOVED: 
                            case REMOVED_AND_ADDED: {
                                DockRegister.this.fireStalledChange(dockable);
                            }
                        }
                    }
                }
                finally {
                    this.firing = false;
                }
            }
        }

        @Override
        public void dockableAdding(DockStation dockStation, Dockable dockable) {
            if (DockRegister.this.stalled > 0) {
                DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){
                    private DockStation protectedAncestor;

                    @Override
                    public void handleDockable(Dockable dockable) {
                        if (this.protectedAncestor == null || !DockUtilities.isAncestor(this.protectedAncestor, dockable)) {
                            DockStation dockStation = dockable.asDockStation();
                            if (dockStation != null && DockRegister.this.isProtected(dockStation)) {
                                this.protectedAncestor = dockStation;
                            } else {
                                Status status = (Status)((Object)DockRegister.this.changeMap.get(dockable));
                                if (status == null) {
                                    DockRegister.this.changeMap.put(dockable, Status.ADDED);
                                    DockRegister.this.changeQueue.add(dockable);
                                } else {
                                    switch (status) {
                                        case REMOVED: {
                                            DockRegister.this.changeMap.put(dockable, Status.REMOVED_AND_ADDED);
                                            break;
                                        }
                                        case ADDED_AND_REMOVED: {
                                            DockRegister.this.changeMap.put(dockable, Status.ADDED);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public void handleDockStation(DockStation dockStation) {
                        if (this.protectedAncestor == null || !DockUtilities.isAncestor(this.protectedAncestor, dockStation)) {
                            dockStation.addDockStationListener(StationListener.this);
                        }
                    }
                });
            } else {
                this.addDockable(dockable, true);
            }
        }

        private void addDockable(Dockable dockable, boolean bl) {
            DockStation dockStation = dockable.asDockStation();
            if (dockStation != null) {
                DockRegister.this.add(dockStation, bl);
            } else {
                DockRegister.this.register(dockable);
            }
        }

        @Override
        public void dockableRemoving(DockStation dockStation, Dockable dockable) {
            if (DockRegister.this.stalled > 0) {
                DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){
                    private DockStation protectedAncestor;

                    @Override
                    public void handleDockable(Dockable dockable) {
                        if (this.protectedAncestor == null || !DockUtilities.isAncestor(this.protectedAncestor, dockable)) {
                            DockStation dockStation = dockable.asDockStation();
                            if (dockStation != null && DockRegister.this.isProtected(dockStation)) {
                                this.protectedAncestor = dockStation;
                            } else {
                                Status status = (Status)((Object)DockRegister.this.changeMap.get(dockable));
                                if (status == null) {
                                    DockRegister.this.changeMap.put(dockable, Status.REMOVED);
                                    DockRegister.this.changeQueue.add(dockable);
                                } else {
                                    switch (status) {
                                        case ADDED: {
                                            DockRegister.this.changeMap.put(dockable, Status.ADDED_AND_REMOVED);
                                            break;
                                        }
                                        case REMOVED_AND_ADDED: {
                                            DockRegister.this.changeMap.put(dockable, Status.REMOVED);
                                        }
                                    }
                                }
                            }
                        }
                    }

                    @Override
                    public void handleDockStation(DockStation dockStation) {
                        if (this.protectedAncestor == null || !DockUtilities.isAncestor(this.protectedAncestor, dockStation)) {
                            dockStation.removeDockStationListener(StationListener.this);
                        }
                    }
                });
            }
        }

        @Override
        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            if (dockable.getDockParent() != null && dockable.getDockParent() != dockStation) {
                throw new IllegalStateException("the parent of dockable is wrong: it is neither null nor '" + dockStation + "'");
            }
            dockable.setDockParent(null);
            if (DockRegister.this.stalled == 0) {
                this.removeDockable(dockable);
            }
        }

        private void removeDockable(Dockable dockable) {
            DockStation dockStation = dockable.asDockStation();
            if (dockStation != null) {
                if (!DockRegister.this.isProtected(dockStation)) {
                    DockRegister.this.remove(dockStation);
                }
            } else {
                DockRegister.this.unregister(dockable);
            }
        }
    }

    private static enum Status {
        ADDED,
        REMOVED,
        ADDED_AND_REMOVED,
        REMOVED_AND_ADDED;

    }
}

