/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.AbstractKeyboardController;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.event.ComponentHierarchyObserverEvent;
import bibliothek.gui.dock.event.ComponentHierarchyObserverListener;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;

public class DefaultKeyboardController
extends AbstractKeyboardController {
    private AWTEventListener awtListener;
    private KeyListener keyListener;
    private ComponentHierarchyObserverListener hierarchyListener;
    private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

        @Override
        protected void valueChanged(Boolean bl, Boolean bl2) {
            DefaultKeyboardController.this.updateRestricted();
        }
    };

    public DefaultKeyboardController(DockController dockController, ControllerSetupCollection controllerSetupCollection) {
        super(dockController);
        controllerSetupCollection.add(new ControllerSetupListener(){

            @Override
            public void done(DockController dockController) {
                DefaultKeyboardController.this.restricted.setProperties(dockController);
                DefaultKeyboardController.this.updateRestricted();
            }
        });
    }

    private void updateRestricted() {
        if (this.restricted.getProperties() != null) {
            boolean bl = this.restricted.getValue();
            this.setListeningAWT(!bl);
            this.setListeningKey(bl);
        }
    }

    private void setListeningAWT(boolean bl) {
        if (bl) {
            if (this.awtListener == null) {
                this.awtListener = this.createAwtListener();
                try {
                    Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 8L);
                }
                catch (SecurityException securityException) {
                    System.err.println("Can't register AWTEventListener, support for global KeyEvents disabled");
                    securityException.printStackTrace();
                }
            }
        } else if (this.awtListener != null) {
            try {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
            }
            catch (SecurityException securityException) {}
            this.awtListener = null;
        }
    }

    private void setListeningKey(boolean bl) {
        if (bl) {
            if (this.keyListener == null) {
                this.keyListener = this.createKeyListener();
                this.hierarchyListener = this.createHierarchyListener();
                for (Component component : this.getController().getComponentHierarchyObserver().getComponents()) {
                    component.addKeyListener(this.keyListener);
                }
                this.getController().getComponentHierarchyObserver().addListener(this.hierarchyListener);
            }
        } else if (this.keyListener != null) {
            this.getController().getComponentHierarchyObserver().removeListener(this.hierarchyListener);
            for (Component component : this.getController().getComponentHierarchyObserver().getComponents()) {
                component.removeKeyListener(this.keyListener);
            }
            this.hierarchyListener = null;
            this.keyListener = null;
        }
    }

    @Override
    public void kill() {
        this.setListeningAWT(false);
        this.setListeningKey(false);
        this.restricted.setProperties((DockController)null);
    }

    private AWTEventListener createAwtListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof KeyEvent) {
                    KeyEvent keyEvent = (KeyEvent)aWTEvent;
                    if (keyEvent.getID() == 401) {
                        DefaultKeyboardController.this.fireKeyPressed(keyEvent);
                    } else if (keyEvent.getID() == 402) {
                        DefaultKeyboardController.this.fireKeyReleased(keyEvent);
                    } else if (keyEvent.getID() == 400) {
                        DefaultKeyboardController.this.fireKeyTyped(keyEvent);
                    }
                }
            }
        };
    }

    private KeyListener createKeyListener() {
        return new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                DefaultKeyboardController.this.fireKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DefaultKeyboardController.this.fireKeyReleased(keyEvent);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                DefaultKeyboardController.this.fireKeyTyped(keyEvent);
            }
        };
    }

    private ComponentHierarchyObserverListener createHierarchyListener() {
        return new ComponentHierarchyObserverListener(){

            @Override
            public void added(ComponentHierarchyObserverEvent componentHierarchyObserverEvent) {
                List<Component> list = componentHierarchyObserverEvent.getComponents();
                if (DefaultKeyboardController.this.keyListener != null) {
                    for (Component component : list) {
                        component.addKeyListener(DefaultKeyboardController.this.keyListener);
                    }
                }
            }

            @Override
            public void removed(ComponentHierarchyObserverEvent componentHierarchyObserverEvent) {
                List<Component> list = componentHierarchyObserverEvent.getComponents();
                if (DefaultKeyboardController.this.keyListener != null) {
                    for (Component component : list) {
                        component.removeKeyListener(DefaultKeyboardController.this.keyListener);
                    }
                }
            }
        };
    }
}

