/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.GlobalMouseDispatcher;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;

public class DefaultGlobalMouseDispatcher
implements GlobalMouseDispatcher {
    private AWTEventListener listener;
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private MouseListener[] mouseListenersCache = null;
    private List<MouseMotionListener> mouseMotionListeners = new ArrayList<MouseMotionListener>();
    private MouseMotionListener[] mouseMotionListenersCache = null;
    private List<MouseWheelListener> mouseWheelListeners = new ArrayList<MouseWheelListener>();
    private MouseWheelListener[] mouseWheelListenersCache = null;
    private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

        @Override
        protected void valueChanged(Boolean bl, Boolean bl2) {
            DefaultGlobalMouseDispatcher.this.updateRestricted();
        }
    };

    public DefaultGlobalMouseDispatcher(DockController dockController, ControllerSetupCollection controllerSetupCollection) {
        controllerSetupCollection.add(new ControllerSetupListener(){

            @Override
            public void done(DockController dockController) {
                DefaultGlobalMouseDispatcher.this.restricted.setProperties(dockController);
                DefaultGlobalMouseDispatcher.this.updateRestricted();
            }
        });
    }

    @Override
    public void dispatch(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 500: {
                MouseListener[] mouseListenerArray = this.getMouseListeners();
                int n = mouseListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MouseListener mouseListener = mouseListenerArray[n2];
                    mouseListener.mouseClicked(mouseEvent);
                    ++n2;
                }
                break;
            }
            case 506: {
                MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
                int n = mouseMotionListenerArray.length;
                int n3 = 0;
                while (n3 < n) {
                    MouseMotionListener mouseMotionListener = mouseMotionListenerArray[n3];
                    mouseMotionListener.mouseDragged(mouseEvent);
                    ++n3;
                }
                break;
            }
            case 504: {
                MouseListener[] mouseListenerArray = this.getMouseListeners();
                int n = mouseListenerArray.length;
                int n4 = 0;
                while (n4 < n) {
                    MouseListener mouseListener = mouseListenerArray[n4];
                    mouseListener.mouseEntered(mouseEvent);
                    ++n4;
                }
                break;
            }
            case 505: {
                MouseListener[] mouseListenerArray = this.getMouseListeners();
                int n = mouseListenerArray.length;
                int n5 = 0;
                while (n5 < n) {
                    MouseListener mouseListener = mouseListenerArray[n5];
                    mouseListener.mouseExited(mouseEvent);
                    ++n5;
                }
                break;
            }
            case 503: {
                MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
                int n = mouseMotionListenerArray.length;
                int n6 = 0;
                while (n6 < n) {
                    MouseMotionListener mouseMotionListener = mouseMotionListenerArray[n6];
                    mouseMotionListener.mouseMoved(mouseEvent);
                    ++n6;
                }
                break;
            }
            case 501: {
                MouseListener[] mouseListenerArray = this.getMouseListeners();
                int n = mouseListenerArray.length;
                int n7 = 0;
                while (n7 < n) {
                    MouseListener mouseListener = mouseListenerArray[n7];
                    mouseListener.mousePressed(mouseEvent);
                    ++n7;
                }
                break;
            }
            case 502: {
                MouseListener[] mouseListenerArray = this.getMouseListeners();
                int n = mouseListenerArray.length;
                int n8 = 0;
                while (n8 < n) {
                    MouseListener mouseListener = mouseListenerArray[n8];
                    mouseListener.mouseReleased(mouseEvent);
                    ++n8;
                }
                break;
            }
            case 507: {
                MouseWheelListener[] mouseWheelListenerArray = this.getMouseWheelListeners();
                int n = mouseWheelListenerArray.length;
                int n9 = 0;
                while (n9 < n) {
                    MouseWheelListener mouseWheelListener = mouseWheelListenerArray[n9];
                    mouseWheelListener.mouseWheelMoved((MouseWheelEvent)mouseEvent);
                    ++n9;
                }
                break;
            }
            default: {
                throw new IllegalStateException("unknown type of MouseEvent: " + mouseEvent);
            }
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.mouseListeners.add(mouseListener);
        this.mouseListenersCache = null;
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        this.mouseListeners.remove(mouseListener);
        this.mouseListenersCache = null;
    }

    protected synchronized MouseListener[] getMouseListeners() {
        if (this.mouseListenersCache == null) {
            this.mouseListenersCache = this.mouseListeners.toArray(new MouseListener[this.mouseListeners.size()]);
        }
        return this.mouseListenersCache;
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.add(mouseMotionListener);
        this.mouseMotionListenersCache = null;
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.remove(mouseMotionListener);
        this.mouseMotionListenersCache = null;
    }

    protected synchronized MouseMotionListener[] getMouseMotionListeners() {
        if (this.mouseMotionListenersCache == null) {
            this.mouseMotionListenersCache = this.mouseMotionListeners.toArray(new MouseMotionListener[this.mouseMotionListeners.size()]);
        }
        return this.mouseMotionListenersCache;
    }

    @Override
    public synchronized void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListeners.add(mouseWheelListener);
        this.mouseWheelListenersCache = null;
    }

    @Override
    public synchronized void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.mouseWheelListeners.remove(mouseWheelListener);
        this.mouseWheelListenersCache = null;
    }

    protected synchronized MouseWheelListener[] getMouseWheelListeners() {
        if (this.mouseWheelListenersCache == null) {
            this.mouseWheelListenersCache = this.mouseWheelListeners.toArray(new MouseWheelListener[this.mouseWheelListeners.size()]);
        }
        return this.mouseWheelListenersCache;
    }

    private void updateRestricted() {
        if (this.restricted.getProperties() != null) {
            if (!this.restricted.getValue().booleanValue()) {
                if (this.listener == null) {
                    this.listener = this.createListener();
                    try {
                        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 131120L);
                    }
                    catch (SecurityException securityException) {
                        System.err.println("Can't register AWTEventListener, support for global MouseEvents disabled");
                        securityException.printStackTrace();
                    }
                }
            } else if (this.listener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
                this.listener = null;
            }
        }
    }

    @Override
    public void kill() {
        if (this.listener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
            this.listener = null;
        }
        this.restricted.setProperties((DockController)null);
    }

    protected AWTEventListener createListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof MouseEvent) {
                    DefaultGlobalMouseDispatcher.this.dispatch((MouseEvent)aWTEvent);
                }
            }
        };
    }
}

