/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.AbstractFocusController;
import bibliothek.gui.dock.control.focus.DefaultFocusRequest;
import bibliothek.gui.dock.control.focus.EnsuringFocusRequest;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.control.focus.FocusStrategyRequest;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Timer;

public class DefaultFocusController
extends AbstractFocusController {
    private Dockable focusedDockable = null;
    private boolean onFocusing = false;
    private List<Request> pendingRequests = new ArrayList<Request>();
    private List<Runnable> pendingCompletionRequests = new LinkedList<Runnable>();

    public DefaultFocusController(DockController dockController) {
        super(dockController);
    }

    @Override
    public boolean isOnFocusing() {
        return this.onFocusing;
    }

    @Override
    public Dockable getFocusedDockable() {
        return this.focusedDockable;
    }

    @Override
    public FocusVetoListener.FocusVeto checkFocusedDockable(DockElementRepresentative dockElementRepresentative) {
        if (dockElementRepresentative == null) {
            return null;
        }
        Dockable dockable = dockElementRepresentative.getElement().asDockable();
        if (dockable == null) {
            return null;
        }
        FocusVetoListener.FocusVeto focusVeto = dockElementRepresentative instanceof DockTitle ? this.fireVetoTitle((DockTitle)dockElementRepresentative) : this.fireVetoDockable(dockable);
        if (focusVeto == null) {
            return FocusVetoListener.FocusVeto.NONE;
        }
        return focusVeto;
    }

    @Override
    public FocusVetoListener.FocusVeto setFocusedDockable(DockElementRepresentative dockElementRepresentative, Component component, boolean bl, boolean bl2, boolean bl3) {
        DefaultFocusRequest defaultFocusRequest = new DefaultFocusRequest(dockElementRepresentative, component, bl, bl2, bl3);
        this.focus(defaultFocusRequest);
        return defaultFocusRequest.getVeto();
    }

    @Override
    public void ensureFocusSet(boolean bl) {
        Dockable dockable = this.focusedDockable;
        if (dockable != null) {
            this.focus(new EnsuringFocusRequest(dockable, bl));
        }
    }

    @Override
    public void focus(FocusRequest focusRequest) {
        Request request = new Request(focusRequest, false);
        request.enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFocusRequestCompletion(final Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            List<Request> list = this.pendingRequests;
            synchronized (list) {
                if (this.pendingRequests.isEmpty() || this.isFrozen()) {
                    runnable.run();
                } else {
                    this.pendingCompletionRequests.add(runnable);
                }
            }
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DefaultFocusController.this.onFocusRequestCompletion(runnable);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private void checkCompletionRequests() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = DefaultFocusController.this.pendingRequests;
                synchronized (list) {
                    Iterator iterator = DefaultFocusController.this.pendingCompletionRequests.iterator();
                    while (DefaultFocusController.this.pendingRequests.isEmpty() && iterator.hasNext()) {
                        Runnable runnable = (Runnable)iterator.next();
                        iterator.remove();
                        runnable.run();
                    }
                }
            }
        });
    }

    protected Component accept(final FocusRequest focusRequest, final Dockable dockable) {
        Component component;
        if (this.isFrozen()) {
            return null;
        }
        if (!focusRequest.validate(this)) {
            return null;
        }
        FocusVetoListener.FocusVeto focusVeto = this.checkFocusedDockable(focusRequest.getSource());
        if (focusVeto == null) {
            focusVeto = FocusVetoListener.FocusVeto.NONE;
        }
        focusRequest.veto(focusVeto);
        if (focusVeto != FocusVetoListener.FocusVeto.NONE) {
            return null;
        }
        FocusStrategy focusStrategy = this.getStrategy();
        Component component2 = focusRequest.getComponent();
        if (focusStrategy != null && dockable != null && (component = focusStrategy.getFocusComponent(new FocusStrategyRequest(){

            @Override
            public Component getMouseClicked() {
                return focusRequest.getComponent();
            }

            @Override
            public Dockable getDockable() {
                return dockable;
            }

            @Override
            public boolean excluded(Component component) {
                return !focusRequest.acceptable(component);
            }
        })) != null) {
            component2 = component;
        }
        if (component2 == null && dockable != null) {
            component2 = dockable.getComponent();
        }
        if (!(component2 == null || this.pendingRequests.size() <= 1 || focusRequest.isHardRequest() || component2.isVisible() && component2.isShowing())) {
            component2 = null;
        }
        return component2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(final FocusRequest focusRequest, Dockable dockable, final Component component) {
        List<Request> list = this.pendingRequests;
        synchronized (list) {
            for (Request object : this.pendingRequests) {
                object.cancel();
            }
            this.pendingRequests.clear();
        }
        boolean bl = true;
        if (EventQueue.isDispatchThread()) {
            bl = this.grant(focusRequest, component);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DefaultFocusController.this.grant(focusRequest, component);
                }
            });
        }
        if (bl && dockable != this.focusedDockable) {
            Dockable dockable2 = this.focusedDockable;
            this.focusedDockable = dockable;
            this.fireDockableFocused(dockable2, this.focusedDockable);
        }
        this.checkCompletionRequests();
    }

    private boolean grant(FocusRequest focusRequest, Component component) {
        FocusRequest focusRequest2;
        try {
            this.onFocusing = true;
            focusRequest2 = focusRequest.grant(component);
        }
        finally {
            this.onFocusing = false;
        }
        if (focusRequest2 != null) {
            boolean bl = focusRequest.getSource() == focusRequest2.getSource() && component == focusRequest2.getComponent();
            Request request = new Request(focusRequest2, bl);
            return request.enqueue();
        }
        return true;
    }

    private class Request
    implements ActionListener {
        private boolean accepted = false;
        private FocusRequest request;
        private boolean canceled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request(FocusRequest focusRequest, boolean bl) {
            this.request = focusRequest;
            this.accepted = bl;
            List list = DefaultFocusController.this.pendingRequests;
            synchronized (list) {
                DefaultFocusController.this.pendingRequests.add(this);
            }
        }

        public boolean enqueue() {
            if (this.request.getDelay() <= 0) {
                this.run();
                return true;
            }
            Timer timer = new Timer(this.request.getDelay(), this);
            timer.setRepeats(false);
            timer.start();
            return false;
        }

        public void cancel() {
            this.canceled = true;
        }

        public Dockable getDockable() {
            DockElementRepresentative dockElementRepresentative = this.request.getSource();
            if (dockElementRepresentative == null) {
                return null;
            }
            return dockElementRepresentative.getElement().asDockable();
        }

        private Component accept() {
            if (this.accepted) {
                return this.request.getComponent();
            }
            return DefaultFocusController.this.accept(this.request, this.getDockable());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void run() {
            if (!this.canceled) {
                Component component = this.accept();
                if (component != null) {
                    DefaultFocusController.this.execute(this.request, this.getDockable(), component);
                } else if (this.request.getSource() == null && this.request.getComponent() == null && DefaultFocusController.this.pendingRequests.size() == 1) {
                    DefaultFocusController.this.execute(this.request, null, null);
                } else {
                    List list = DefaultFocusController.this.pendingRequests;
                    synchronized (list) {
                        DefaultFocusController.this.pendingRequests.remove(this);
                    }
                }
            }
        }
    }
}

