/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ActionBinder
extends DockRegisterAdapter {
    private Map<Dockable, SourceObserver> observers = new HashMap<Dockable, SourceObserver>();
    private DockController controller;

    public ActionBinder(DockController dockController) {
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    @Override
    public void dockableRegistered(DockController dockController, Dockable dockable) {
        this.observers.put(dockable, new SourceObserver(dockable));
    }

    @Override
    public void dockableUnregistered(DockController dockController, Dockable dockable) {
        this.observers.remove(dockable).destroy();
    }

    private static class SourceObserver
    implements DockActionSourceListener {
        private List<DockAction> actions = new LinkedList<DockAction>();
        private Dockable dockable;

        public SourceObserver(Dockable dockable) {
            this.dockable = dockable;
            DockActionSource dockActionSource = dockable.getGlobalActionOffers();
            this.actionsAdded(dockActionSource, 0, dockActionSource.getDockActionCount() - 1);
            dockActionSource.addDockActionSourceListener(this);
        }

        public void destroy() {
            DockActionSource dockActionSource = this.dockable.getGlobalActionOffers();
            dockActionSource.removeDockActionSourceListener(this);
            this.actionsRemoved(dockActionSource, 0, dockActionSource.getDockActionCount() - 1);
        }

        @Override
        public void actionsAdded(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n;
            while (n3 <= n2) {
                DockAction dockAction = dockActionSource.getDockAction(n3);
                this.actions.add(n3, dockAction);
                dockAction.bind(this.dockable);
                ++n3;
            }
        }

        @Override
        public void actionsRemoved(DockActionSource dockActionSource, int n, int n2) {
            int n3 = n2;
            while (n3 >= n) {
                DockAction dockAction = this.actions.remove(n3);
                dockAction.unbind(this.dockable);
                --n3;
            }
        }
    }
}

