/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.control.KeyboardController;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.event.LocatedListenerList;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractKeyboardController
implements KeyboardController {
    private LocatedListenerList<KeyboardListener> keyListeners = new LocatedListenerList();
    private List<KeyListener> globalListeners = new ArrayList<KeyListener>();
    private DockController controller;

    public AbstractKeyboardController(DockController dockController) {
        this.controller = dockController;
    }

    @Override
    public void addGlobalListener(KeyListener keyListener) {
        if (keyListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.globalListeners.add(keyListener);
    }

    @Override
    public void removeGlobalListener(KeyListener keyListener) {
        this.globalListeners.remove(keyListener);
    }

    @Override
    public void addListener(KeyboardListener keyboardListener) {
        if (keyboardListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.keyListeners.addListener(keyboardListener);
    }

    @Override
    public void removeListener(KeyboardListener keyboardListener) {
        this.keyListeners.removeListener(keyboardListener);
    }

    @Override
    public DockController getController() {
        return this.controller;
    }

    protected void fireKeyPressed(KeyEvent keyEvent) {
        Object object2;
        if (!keyEvent.isConsumed() && (object2 = this.controller.searchElement(keyEvent.getComponent())) != null) {
            DockElement dockElement = object2.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(dockElement);
            for (KeyboardListener object3 : list) {
                if (!object3.keyPressed(dockElement, keyEvent)) continue;
                keyEvent.consume();
                break;
            }
        }
        KeyListener[] keyListenerArray = this.globalListeners.toArray(new KeyListener[this.globalListeners.size()]);
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = keyListenerArray[n2];
            object2.keyPressed(keyEvent);
            ++n2;
        }
    }

    protected void fireKeyReleased(KeyEvent keyEvent) {
        Object object2;
        if (!keyEvent.isConsumed() && (object2 = this.controller.searchElement(keyEvent.getComponent())) != null) {
            DockElement dockElement = object2.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(dockElement);
            for (KeyboardListener object3 : list) {
                if (!object3.keyReleased(dockElement, keyEvent)) continue;
                keyEvent.consume();
                break;
            }
        }
        KeyListener[] keyListenerArray = this.globalListeners.toArray(new KeyListener[this.globalListeners.size()]);
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = keyListenerArray[n2];
            object2.keyReleased(keyEvent);
            ++n2;
        }
    }

    protected void fireKeyTyped(KeyEvent keyEvent) {
        Object object2;
        if (!keyEvent.isConsumed() && (object2 = this.controller.searchElement(keyEvent.getComponent())) != null) {
            DockElement dockElement = object2.getElement();
            List<KeyboardListener> list = this.keyListeners.affected(dockElement);
            for (KeyboardListener object3 : list) {
                if (!object3.keyTyped(dockElement, keyEvent)) continue;
                keyEvent.consume();
                break;
            }
        }
        KeyListener[] keyListenerArray = this.globalListeners.toArray(new KeyListener[this.globalListeners.size()]);
        int n = keyListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = keyListenerArray[n2];
            object2.keyTyped(keyEvent);
            ++n2;
        }
    }
}

