/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.component;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentConfigurationEvent;
import bibliothek.gui.dock.component.DockComponentRoot;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.HashSet;
import java.util.Set;

public abstract class DockComponentRootHandler {
    private DockComponentRoot root;
    private DockComponentConfiguration configuration;
    private DockController controller;
    private Listener listener = new Listener();
    private Set<Component> handledComponents = new HashSet<Component>();

    public DockComponentRootHandler(DockComponentRoot dockComponentRoot) {
        if (dockComponentRoot == null) {
            throw new IllegalArgumentException("root must not be null");
        }
        this.root = dockComponentRoot;
    }

    public void setConfiguration(DockComponentConfiguration dockComponentConfiguration) {
        if (this.configuration != dockComponentConfiguration) {
            DockComponentConfigurationEvent dockComponentConfigurationEvent;
            if (this.configuration != null) {
                for (Component component : this.handledComponents) {
                    dockComponentConfigurationEvent = new DockComponentConfigurationEvent(this.root, component);
                    this.configuration.unconfigure(dockComponentConfigurationEvent);
                }
            }
            this.configuration = dockComponentConfiguration;
            if (this.configuration != null) {
                for (Component component : this.handledComponents) {
                    dockComponentConfigurationEvent = new DockComponentConfigurationEvent(this.root, component);
                    this.configuration.configure(dockComponentConfigurationEvent);
                }
            }
        }
    }

    public DockComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                this.controller.getDockComponentManager().unregister(this.root);
            }
            this.controller = dockController;
            if (this.controller != null) {
                this.controller.getDockComponentManager().register(this.root);
            }
        }
    }

    public void addRoot(Component component) {
        this.add(component);
    }

    public void removeRoot(Component component) {
        this.remove(component);
    }

    private void add(Component component) {
        Object object;
        TraverseResult traverseResult = this.shouldTraverse(component);
        if (traverseResult == TraverseResult.EXCLUDE_CHILDREN || traverseResult == TraverseResult.INCLUDE_CHILDREN) {
            object = new DockComponentConfigurationEvent(this.root, component);
            if (this.configuration != null) {
                this.configuration.configure((DockComponentConfigurationEvent)object);
            }
            this.handledComponents.add(component);
        }
        if (traverseResult == TraverseResult.INCLUDE_CHILDREN && component instanceof Container) {
            object = (Container)component;
            ((Container)object).addContainerListener(this.listener);
            int n = 0;
            int n2 = ((Container)object).getComponentCount();
            while (n < n2) {
                this.add(((Container)object).getComponent(n));
                ++n;
            }
        }
    }

    private void remove(Component component) {
        if (this.handledComponents.remove(component)) {
            DockComponentConfigurationEvent dockComponentConfigurationEvent = new DockComponentConfigurationEvent(this.root, component);
            if (this.configuration != null) {
                this.configuration.unconfigure(dockComponentConfigurationEvent);
            }
            if (component instanceof Container) {
                Container container = (Container)component;
                container.removeContainerListener(this.listener);
                int n = 0;
                int n2 = container.getComponentCount();
                while (n < n2) {
                    this.remove(container.getComponent(n));
                    ++n;
                }
            }
        }
    }

    protected abstract TraverseResult shouldTraverse(Component var1);

    private class Listener
    implements ContainerListener {
        private Listener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            DockComponentRootHandler.this.add(containerEvent.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            DockComponentRootHandler.this.remove(containerEvent.getChild());
        }
    }

    protected static enum TraverseResult {
        INCLUDE_CHILDREN,
        EXCLUDE_CHILDREN,
        EXCLUDE;

    }
}

