/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.component;

import bibliothek.gui.dock.component.DockComponentConfiguration;
import bibliothek.gui.dock.component.DockComponentManager;
import bibliothek.gui.dock.component.DockComponentRoot;
import bibliothek.util.Filter;
import bibliothek.util.container.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultDockComponentManager
implements DockComponentManager {
    private DockComponentConfiguration defaultConfiguration;
    private List<Tuple<Filter<DockComponentRoot>, DockComponentConfiguration>> configurations = new ArrayList<Tuple<Filter<DockComponentRoot>, DockComponentConfiguration>>();
    private Map<DockComponentRoot, Handle> roots = new HashMap<DockComponentRoot, Handle>();

    @Override
    public void setDefaultConfiguration(DockComponentConfiguration dockComponentConfiguration) {
        this.defaultConfiguration = dockComponentConfiguration;
        this.reconfigure();
    }

    @Override
    public void addConfiguration(Filter<DockComponentRoot> filter, DockComponentConfiguration dockComponentConfiguration) {
        this.configurations.add(Tuple.of(filter, dockComponentConfiguration));
        this.reconfigure();
    }

    @Override
    public void removeConfiguration(DockComponentConfiguration dockComponentConfiguration) {
        Iterator<Tuple<Filter<DockComponentRoot>, DockComponentConfiguration>> iterator = this.configurations.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getB() != dockComponentConfiguration) continue;
            iterator.remove();
            this.reconfigure();
            return;
        }
    }

    private void reconfigure() {
        for (Handle handle : this.roots.values()) {
            handle.reconfigure();
        }
    }

    @Override
    public void register(DockComponentRoot dockComponentRoot) {
        if (!this.roots.containsKey(dockComponentRoot)) {
            Handle handle = new Handle(dockComponentRoot);
            this.roots.put(dockComponentRoot, handle);
            handle.reconfigure();
        }
    }

    @Override
    public void unregister(DockComponentRoot dockComponentRoot) {
        Handle handle = this.roots.remove(dockComponentRoot);
        if (handle != null) {
            handle.destroy();
        }
    }

    private DockComponentConfiguration getConfigurationFor(DockComponentRoot dockComponentRoot) {
        for (Tuple<Filter<DockComponentRoot>, DockComponentConfiguration> tuple : this.configurations) {
            if (!((Filter)tuple.getA()).includes(dockComponentRoot)) continue;
            return tuple.getB();
        }
        return this.defaultConfiguration;
    }

    private class Handle {
        private DockComponentRoot root;

        public Handle(DockComponentRoot dockComponentRoot) {
            this.root = dockComponentRoot;
        }

        public void reconfigure() {
            DockComponentConfiguration dockComponentConfiguration;
            DockComponentConfiguration dockComponentConfiguration2 = DefaultDockComponentManager.this.getConfigurationFor(this.root);
            if (dockComponentConfiguration2 != (dockComponentConfiguration = this.root.getComponentConfiguration())) {
                this.root.setComponentConfiguration(dockComponentConfiguration2);
            }
        }

        public void destroy() {
            this.root.setComponentConfiguration(null);
        }
    }
}

