/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme.eclipse;

import bibliothek.extension.gui.dock.theme.eclipse.DefaultEclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabDockAction;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabDockActionLocation;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseTabStateInfo;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnectorListener;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.core.CommonDockAction;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;

public class CommonEclipseThemeConnector
extends DefaultEclipseThemeConnector {
    private CControl control;
    private boolean listening = false;
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        @Override
        public void singleTabShownChanged(CDockable cDockable) {
            this.fire(cDockable);
        }

        @Override
        public void titleShownChanged(CDockable cDockable) {
            this.fire(cDockable);
        }

        private void fire(CDockable cDockable) {
            CommonDockable commonDockable = cDockable.intern();
            EclipseThemeConnector.TitleBar titleBar = CommonEclipseThemeConnector.this.getTitleBarKind(commonDockable.getDockParent(), commonDockable);
            EclipseThemeConnectorListener[] eclipseThemeConnectorListenerArray = CommonEclipseThemeConnector.this.listeners();
            int n = eclipseThemeConnectorListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                EclipseThemeConnectorListener eclipseThemeConnectorListener = eclipseThemeConnectorListenerArray[n2];
                eclipseThemeConnectorListener.titleBarChanged(CommonEclipseThemeConnector.this, commonDockable, titleBar);
                ++n2;
            }
        }
    };

    public CommonEclipseThemeConnector(CControl cControl) {
        this.control = cControl;
    }

    @Override
    public void addEclipseThemeConnectorListener(EclipseThemeConnectorListener eclipseThemeConnectorListener) {
        super.addEclipseThemeConnectorListener(eclipseThemeConnectorListener);
        this.updateListening();
    }

    @Override
    public void removeEclipseThemeConnectorListener(EclipseThemeConnectorListener eclipseThemeConnectorListener) {
        super.removeEclipseThemeConnectorListener(eclipseThemeConnectorListener);
        this.updateListening();
    }

    private void updateListening() {
        if (this.hasListeners()) {
            if (!this.listening) {
                this.listening = true;
                this.control.addPropertyListener(this.propertyListener);
            }
        } else if (this.listening) {
            this.listening = false;
            this.control.removePropertyListener(this.propertyListener);
        }
    }

    @Override
    protected EclipseTabDockActionLocation getLocation(DockAction dockAction, EclipseTabStateInfo eclipseTabStateInfo) {
        CAction cAction;
        EclipseTabDockActionLocation eclipseTabDockActionLocation;
        if (dockAction instanceof CommonDockAction && (eclipseTabDockActionLocation = this.getLocation(cAction = ((CommonDockAction)dockAction).getAction(), eclipseTabStateInfo)) != null) {
            return eclipseTabDockActionLocation;
        }
        return super.getLocation(dockAction, eclipseTabStateInfo);
    }

    protected EclipseTabDockActionLocation getLocation(CAction cAction, EclipseTabStateInfo eclipseTabStateInfo) {
        EclipseTabDockAction eclipseTabDockAction = cAction.getClass().getAnnotation(EclipseTabDockAction.class);
        if (eclipseTabDockAction != null) {
            return this.getLocation(eclipseTabDockAction, eclipseTabStateInfo);
        }
        return null;
    }

    @Override
    public EclipseThemeConnector.TitleBar getTitleBarKind(DockStation dockStation, Dockable dockable) {
        boolean bl;
        boolean bl2;
        if (dockStation instanceof StackDockStation) {
            return EclipseThemeConnector.TitleBar.NONE;
        }
        if (dockable instanceof CommonDockable && !(bl2 = ((CommonDockable)dockable).getDockable().isTitleShown()) && !(bl = ((CommonDockable)dockable).getDockable().isSingleTabShown())) {
            return EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        }
        return super.getTitleBarKind(dockStation, dockable);
    }
}

