/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.theme.CBasicTheme;
import bibliothek.gui.dock.common.theme.CDockThemeFactory;
import bibliothek.gui.dock.common.theme.CEclipseTheme;
import bibliothek.gui.dock.common.theme.ThemeMapListener;
import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ThemeFactory;
import bibliothek.gui.dock.themes.ThemePropertyFactory;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ThemeMap {
    public static final String KEY_BASIC_THEME = "basic";
    public static final String KEY_BUBBLE_THEME = "bubble";
    public static final String KEY_ECLIPSE_THEME = "eclipse";
    public static final String KEY_FLAT_THEME = "flat";
    public static final String KEY_SMOOTH_THEME = "smooth";
    private List<ThemeMapListener> listeners = new ArrayList<ThemeMapListener>();
    private List<Entry> factories = new ArrayList<Entry>();
    private Entry selected;

    public ThemeMap() {
    }

    public ThemeMap(final CControl cControl) {
        this.init(cControl);
        this.addThemeMapListener(new ThemeMapListener(){

            @Override
            public void changed(ThemeMap themeMap, int n, String string, ThemeFactory themeFactory, ThemeFactory themeFactory2) {
            }

            @Override
            public void selectionChanged(ThemeMap themeMap, String string, String string2) {
                ThemeFactory themeFactory = null;
                if (string2 != null) {
                    themeFactory = ThemeMap.this.getFactory(string2);
                }
                DockTheme dockTheme = themeFactory == null ? new CBasicTheme(cControl) : themeFactory.create(cControl.getController());
                cControl.intern().getController().setTheme(dockTheme);
            }
        });
        try {
            cControl.getResources().put("dock.ui.ThemeMap", new ApplicationResource(){

                @Override
                public void read(DataInputStream dataInputStream) throws IOException {
                    Version.read(dataInputStream).checkCurrent();
                    if (dataInputStream.readBoolean()) {
                        ThemeMap.this.select(dataInputStream.readUTF());
                    } else {
                        ThemeMap.this.select(-1);
                    }
                }

                @Override
                public void readXML(XElement xElement) {
                    String string = null;
                    XElement xElement2 = xElement.getElement("key");
                    if (xElement2 != null) {
                        string = xElement2.getString();
                    }
                    ThemeMap.this.select(string);
                }

                @Override
                public void write(DataOutputStream dataOutputStream) throws IOException {
                    Version.write(dataOutputStream, Version.VERSION_1_0_6);
                    String string = ThemeMap.this.getSelectedKey();
                    if (string == null) {
                        dataOutputStream.writeBoolean(false);
                    } else {
                        dataOutputStream.writeBoolean(true);
                        dataOutputStream.writeUTF(string);
                    }
                }

                @Override
                public void writeXML(XElement xElement) {
                    String string = ThemeMap.this.getSelectedKey();
                    if (string != null) {
                        xElement.addElement("key").setString(string);
                    }
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.getSelectedKey() == null) {
            this.select(KEY_BASIC_THEME);
        }
    }

    private void init(CControl cControl) {
        CDockThemeFactory<EclipseTheme> cDockThemeFactory = new CDockThemeFactory<EclipseTheme>(new ThemePropertyFactory<EclipseTheme>(EclipseTheme.class), cControl){

            @Override
            public DockTheme create(CControl cControl) {
                return new CEclipseTheme(cControl);
            }
        };
        CDockThemeFactory<BasicTheme> cDockThemeFactory2 = new CDockThemeFactory<BasicTheme>(new ThemePropertyFactory<BasicTheme>(BasicTheme.class), cControl){

            @Override
            public DockTheme create(CControl cControl) {
                return new CBasicTheme(cControl);
            }
        };
        this.add(KEY_BASIC_THEME, cDockThemeFactory2);
        this.add(KEY_ECLIPSE_THEME, cDockThemeFactory);
    }

    public void addThemeMapListener(ThemeMapListener themeMapListener) {
        if (themeMapListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(themeMapListener);
    }

    public void removeThemeMapListener(ThemeMapListener themeMapListener) {
        this.listeners.remove(themeMapListener);
    }

    protected ThemeMapListener[] listeners() {
        return this.listeners.toArray(new ThemeMapListener[this.listeners.size()]);
    }

    public void select(String string) {
        this.select(string, false);
    }

    public void select(String string, boolean bl) {
        if (string == null) {
            this.select(-1, bl);
        } else {
            this.select(this.indexOf(string), bl);
        }
    }

    public void select(ThemeFactory themeFactory) {
        int n = this.indexOf(themeFactory);
        if (n < 0) {
            throw new IllegalArgumentException("factory not known " + themeFactory);
        }
        this.select(n);
    }

    public void select(int n) {
        this.select(n, false);
    }

    public void select(int n, boolean bl) {
        Entry entry = null;
        if (n >= 0) {
            entry = this.factories.get(n);
        }
        if (entry != this.selected || bl) {
            String string = this.selected == null ? null : this.selected.key;
            String string2 = entry == null ? null : entry.key;
            this.selected = entry;
            ThemeMapListener[] themeMapListenerArray = this.listeners();
            int n2 = themeMapListenerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ThemeMapListener themeMapListener = themeMapListenerArray[n3];
                themeMapListener.selectionChanged(this, string, string2);
                ++n3;
            }
        }
    }

    public String getSelectedKey() {
        return this.selected == null ? null : this.selected.key;
    }

    public ThemeFactory getSelectedFactory() {
        return this.selected == null ? null : this.selected.factory;
    }

    public int size() {
        return this.factories.size();
    }

    public void put(String string, ThemeFactory themeFactory) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (themeFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        int n = this.indexOf(string);
        if (n < 0) {
            this.add(string, themeFactory);
        } else {
            Entry entry = this.factories.get(n);
            ThemeFactory themeFactory2 = entry.factory;
            entry.factory = themeFactory;
            ThemeMapListener[] themeMapListenerArray = this.listeners();
            int n2 = themeMapListenerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ThemeMapListener themeMapListener = themeMapListenerArray[n3];
                themeMapListener.changed(this, n, string, themeFactory2, themeFactory);
                ++n3;
            }
        }
    }

    public void add(String string, ThemeFactory themeFactory) {
        this.insert(this.size(), string, themeFactory);
    }

    public void insert(int n, String string, ThemeFactory themeFactory) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (themeFactory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        if (n < 0 || n > this.factories.size()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.indexOf(string);
        if (n2 >= 0) {
            this.remove(n2);
            if (n > n2) {
                --n;
            }
        }
        Entry entry = new Entry();
        entry.key = string;
        entry.factory = themeFactory;
        this.factories.add(n, entry);
        ThemeMapListener[] themeMapListenerArray = this.listeners();
        int n3 = themeMapListenerArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ThemeMapListener themeMapListener = themeMapListenerArray[n4];
            themeMapListener.changed(this, n, string, null, themeFactory);
            ++n4;
        }
    }

    public void remove(int n) {
        Entry entry = this.factories.remove(n);
        ThemeMapListener[] themeMapListenerArray = this.listeners();
        int n2 = themeMapListenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ThemeMapListener themeMapListener = themeMapListenerArray[n3];
            themeMapListener.changed(this, n, entry.key, entry.factory, null);
            ++n3;
        }
    }

    public boolean remove(String string) {
        int n = this.indexOf(string);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public int indexOf(ThemeFactory themeFactory) {
        int n = 0;
        for (Entry entry : this.factories) {
            if (entry.factory == themeFactory) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(String string) {
        int n = 0;
        for (Entry entry : this.factories) {
            if (entry.key.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String getKey(int n) {
        return this.factories.get((int)n).key;
    }

    public ThemeFactory getFactory(int n) {
        return this.factories.get((int)n).factory;
    }

    public ThemeFactory getFactory(String string) {
        Entry entry = this.getEntry(string);
        if (entry == null) {
            return null;
        }
        return entry.factory;
    }

    private Entry getEntry(String string) {
        for (Entry entry : this.factories) {
            if (!entry.key.equals(string)) continue;
            return entry;
        }
        return null;
    }

    private static class Entry {
        public String key;
        public ThemeFactory factory;

        private Entry() {
        }
    }
}

