/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.dock.dockable.DockableMovingImageFactory;
import bibliothek.gui.dock.focus.DockableSelection;
import bibliothek.gui.dock.station.Combiner;
import bibliothek.gui.dock.station.DisplayerFactory;
import bibliothek.gui.dock.station.StationPaint;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CDockTheme<D extends DockTheme>
implements DockTheme {
    private D theme;
    private DockTheme delegate;
    private Map<Path, ColorBridgeFactory> colorBridgeFactories = new HashMap<Path, ColorBridgeFactory>();
    private List<Controller> controllers = new ArrayList<Controller>();

    public CDockTheme(D d) {
        this(d, (DockTheme)d);
    }

    public CDockTheme(D d, DockTheme dockTheme) {
        if (d == null) {
            throw new IllegalArgumentException("theme must not be null");
        }
        if (dockTheme == null) {
            throw new IllegalArgumentException("delegate must not be null");
        }
        this.theme = d;
        this.delegate = dockTheme;
    }

    public D intern() {
        return this.theme;
    }

    @Override
    public Combiner getCombiner(DockStation dockStation) {
        return this.delegate.getCombiner(dockStation);
    }

    @Override
    public DisplayerFactory getDisplayFactory(DockStation dockStation) {
        return this.delegate.getDisplayFactory(dockStation);
    }

    @Override
    public DockableMovingImageFactory getMovingImageFactory(DockController dockController) {
        return this.delegate.getMovingImageFactory(dockController);
    }

    @Override
    public StationPaint getPaint(DockStation dockStation) {
        return this.delegate.getPaint(dockStation);
    }

    @Override
    public DockTitleFactory getTitleFactory(DockController dockController) {
        return this.delegate.getTitleFactory(dockController);
    }

    @Override
    public DockableSelection getDockableSelection(DockController dockController) {
        return this.delegate.getDockableSelection(dockController);
    }

    public void putColorBridgeFactory(Path path, ColorBridgeFactory colorBridgeFactory) {
        this.colorBridgeFactories.put(path, colorBridgeFactory);
        for (Controller controller : this.controllers) {
            ColorBridge colorBridge;
            ColorManager colorManager = controller.controller.getColors();
            ColorBridge colorBridge2 = controller.colors.remove(path);
            ColorBridge colorBridge3 = colorBridge = colorBridgeFactory == null ? null : colorBridgeFactory.create(colorManager);
            if (colorBridge == null) {
                controller.colors.remove(path);
                if (colorBridge2 == null) continue;
                colorManager.unpublish(Priority.DEFAULT, path);
                continue;
            }
            controller.colors.put(path, colorBridge);
            colorManager.publish(Priority.DEFAULT, path, colorBridge);
        }
    }

    @Override
    public void install(DockController dockController) {
        this.delegate.install(dockController);
        Controller controller = new Controller();
        controller.controller = dockController;
        this.controllers.add(controller);
    }

    @Override
    public void uninstall(DockController dockController) {
        this.delegate.uninstall(dockController);
        int n = 0;
        int n2 = this.controllers.size();
        while (n < n2) {
            Controller controller = this.controllers.get(n);
            if (controller.controller == dockController) {
                this.controllers.remove(n--);
                --n2;
                ColorManager colorManager = dockController.getColors();
                for (ColorBridge colorBridge : controller.colors.values()) {
                    colorManager.unpublish(Priority.DEFAULT, colorBridge);
                }
            }
            ++n;
        }
    }

    private class Controller {
        public DockController controller;
        public Map<Path, ColorBridge> colors = new HashMap<Path, ColorBridge>();

        private Controller() {
        }
    }
}

