/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.intern.action.panel.BasicPanelPopupGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelDropDownGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelMenuGenerator;
import bibliothek.gui.dock.common.intern.color.BasicButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.BasicTabTransmitter;
import bibliothek.gui.dock.common.intern.color.BasicTitleTransmitter;
import bibliothek.gui.dock.common.theme.CDockTheme;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;

public class CBasicTheme
extends CDockTheme<BasicTheme> {
    public CBasicTheme(CControl cControl, BasicTheme basicTheme) {
        super(basicTheme);
        this.init(cControl);
    }

    public CBasicTheme(CControl cControl) {
        this(new BasicTheme());
        this.init(cControl);
    }

    private CBasicTheme(BasicTheme basicTheme) {
        super(basicTheme, new NoStackTheme(basicTheme));
    }

    private void init(final CControl cControl) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            @Override
            public ColorBridge create(ColorManager colorManager) {
                BasicTabTransmitter basicTabTransmitter = new BasicTabTransmitter(colorManager);
                basicTabTransmitter.setControl(cControl);
                return basicTabTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_TITLE_COLOR, new ColorBridgeFactory(){

            @Override
            public ColorBridge create(ColorManager colorManager) {
                BasicTitleTransmitter basicTitleTransmitter = new BasicTitleTransmitter(colorManager);
                basicTitleTransmitter.setControl(cControl);
                return basicTitleTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            @Override
            public ColorBridge create(ColorManager colorManager) {
                BasicButtonTitleTransmitter basicButtonTitleTransmitter = new BasicButtonTitleTransmitter(colorManager);
                basicButtonTitleTransmitter.setControl(cControl);
                return basicButtonTitleTransmitter;
            }
        });
    }

    @Override
    public void install(DockController dockController) {
        super.install(dockController);
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, new BasicPanelPopupGenerator());
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, new PanelMenuGenerator());
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, new PanelDropDownGenerator());
    }

    @Override
    public void uninstall(DockController dockController) {
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, null);
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, null);
        super.uninstall(dockController);
    }
}

