/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective.mode;

import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.LocationHistory;
import bibliothek.gui.dock.common.perspective.MultipleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.CLocationModeSettings;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationSettingConverter;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LocationModeManagerPerspective {
    private CPerspective perspective;
    private Map<ExtendedMode, LocationModePerspective> modes = new HashMap<ExtendedMode, LocationModePerspective>();
    private Map<Path, ModeSettingFactory<Location>> settingFactories = new HashMap<Path, ModeSettingFactory<Location>>();

    public LocationModeManagerPerspective(CPerspective cPerspective, CControlAccess cControlAccess) {
        this.perspective = cPerspective;
        for (ModeSettingFactory modeSettingFactory : cControlAccess.getLocationManager().getFactories()) {
            this.settingFactories.put(modeSettingFactory.getModeId(), modeSettingFactory);
        }
    }

    public ExtendedMode getMode(Path path) {
        for (ExtendedMode extendedMode : this.modes.keySet()) {
            if (!extendedMode.getModeIdentifier().equals(path)) continue;
            return extendedMode;
        }
        return null;
    }

    public void addMode(LocationModePerspective locationModePerspective) {
        this.modes.put(locationModePerspective.getIdentifier(), locationModePerspective);
        locationModePerspective.setPerspective(this.perspective);
    }

    public LocationModePerspective getMode(ExtendedMode extendedMode) {
        return this.modes.get(extendedMode);
    }

    public ExtendedMode[] getModes() {
        return this.modes.keySet().toArray(new ExtendedMode[this.modes.size()]);
    }

    public ExtendedMode getMode(PerspectiveDockable perspectiveDockable) {
        while (perspectiveDockable != null) {
            for (LocationModePerspective locationModePerspective : this.modes.values()) {
                if (!locationModePerspective.isCurrentMode(perspectiveDockable)) continue;
                return locationModePerspective.getIdentifier();
            }
            PerspectiveStation object2 = perspectiveDockable.getParent();
            PerspectiveDockable perspectiveDockable2 = perspectiveDockable = object2 == null ? null : object2.asDockable();
        }
        return null;
    }

    public ExtendedMode getMode(String string, DockableProperty dockableProperty) {
        for (LocationModePerspective locationModePerspective : this.modes.values()) {
            if (!locationModePerspective.isCurrentMode(string, dockableProperty)) continue;
            return locationModePerspective.getIdentifier();
        }
        return null;
    }

    public CStationPerspective getRoot(PerspectiveDockable perspectiveDockable) {
        while (perspectiveDockable != null) {
            CStationPerspective cStationPerspective;
            PerspectiveStation perspectiveStation = perspectiveDockable.getParent();
            if (perspectiveStation == null) {
                return null;
            }
            if (perspectiveStation instanceof CommonElementPerspective && this.perspective.getStation((cStationPerspective = ((CommonElementPerspective)((Object)perspectiveStation)).getElement().asStation()).getUniqueId()) != null) {
                return cStationPerspective;
            }
            perspectiveDockable = perspectiveStation.asDockable();
        }
        return null;
    }

    public Location getLocation(CDockablePerspective cDockablePerspective) {
        return this.getLocation(cDockablePerspective.intern().asDockable());
    }

    public Location getLocation(PerspectiveDockable perspectiveDockable) {
        CStationPerspective cStationPerspective = this.getRoot(perspectiveDockable);
        if (cStationPerspective == null) {
            return null;
        }
        ExtendedMode extendedMode = this.getMode(perspectiveDockable);
        if (extendedMode == null) {
            return null;
        }
        DockableProperty dockableProperty = DockUtilities.getPropertyChain(cStationPerspective.intern().asStation(), perspectiveDockable);
        if (dockableProperty == null) {
            return null;
        }
        return new Location(extendedMode.getModeIdentifier(), cStationPerspective.getUniqueId(), dockableProperty, false);
    }

    public ModeSettings<Location, Location> writeModes(CControlAccess cControlAccess) {
        Object object;
        ModeSettingFactory<Location> modeSettingFactory;
        Object object2;
        Object object3;
        CLocationModeSettings<Location> cLocationModeSettings = new CLocationModeSettings<Location>(new LocationSettingConverter(cControlAccess.getOwner().getController()));
        LocationModeManagerPerspective locationModeManagerPerspective = this.perspective.getLocationManager();
        Iterator<PerspectiveElement> iterator = this.perspective.elements();
        while (iterator.hasNext()) {
            CDockablePerspective cDockablePerspective;
            object3 = iterator.next();
            if (!(object3 instanceof CommonElementPerspective) || (cDockablePerspective = ((CommonElementPerspective)object3).getElement().asDockable()) == null) continue;
            String string = null;
            if (cDockablePerspective instanceof SingleCDockablePerspective) {
                string = cControlAccess.getRegister().toSingleId(((SingleCDockablePerspective)cDockablePerspective).getUniqueId());
            } else if (cDockablePerspective instanceof MultipleCDockablePerspective) {
                string = ((MultipleCDockablePerspective)cDockablePerspective).getUniqueId();
                if (string != null) {
                    string = cControlAccess.getRegister().toMultiId(string);
                } else {
                    throw new IllegalStateException("detected dockable with no identifier");
                }
            }
            if (string == null) continue;
            object2 = locationModeManagerPerspective.getMode(cDockablePerspective.intern().asDockable());
            modeSettingFactory = cDockablePerspective.getLocationHistory();
            object = ((LocationHistory)((Object)modeSettingFactory)).getOrder();
            Map<Path, Location> map = ((LocationHistory)((Object)modeSettingFactory)).getLocations();
            cLocationModeSettings.add(string, object2 == null ? null : ((ExtendedMode)object2).getModeIdentifier(), map, (Collection<Path>)object);
        }
        object2 = locationModeManagerPerspective.getModes();
        int n = ((ExtendedMode[])object2).length;
        int n2 = 0;
        while (n2 < n) {
            object3 = object2[n2];
            modeSettingFactory = this.settingFactories.get(((ExtendedMode)object3).getModeIdentifier());
            if (modeSettingFactory != null) {
                object = modeSettingFactory.create();
                this.getMode((ExtendedMode)object3).writeSetting((ModeSetting<Location>)object);
                cLocationModeSettings.add(object);
            }
            ++n2;
        }
        return cLocationModeSettings;
    }

    public void readModes(ModeSettings<Location, ?> modeSettings, CPerspective cPerspective, CControlAccess cControlAccess) {
        Path[] pathArray;
        Object object;
        Iterator<PerspectiveElement> iterator = cPerspective.elements();
        while (iterator.hasNext()) {
            int n;
            CDockablePerspective cDockablePerspective;
            object = iterator.next();
            if (!(object instanceof CommonElementPerspective) || (cDockablePerspective = ((CommonElementPerspective)object).getElement().asDockable()) == null) continue;
            String string = null;
            if (cDockablePerspective instanceof SingleCDockablePerspective) {
                string = ((SingleCDockablePerspective)cDockablePerspective).getUniqueId();
                string = cControlAccess.getRegister().toSingleId(string);
            } else if (cDockablePerspective instanceof MultipleCDockablePerspective) {
                string = ((MultipleCDockablePerspective)cDockablePerspective).getUniqueId();
                string = cControlAccess.getRegister().toMultiId(string);
            }
            if (string == null || (n = modeSettings.indexOf(string)) == -1) continue;
            pathArray = modeSettings.getHistory(n);
            Map<Path, Location> map = modeSettings.getProperties(n);
            LocationHistory locationHistory = cDockablePerspective.getLocationHistory();
            Path[] pathArray2 = pathArray;
            int n2 = pathArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Path path = pathArray2[n3];
                ExtendedMode extendedMode = this.getMode(path);
                if (extendedMode == null) {
                    throw new IllegalStateException("unknown ExtendedMode with id='" + path + "'");
                }
                Location location = map.get(path);
                if (location != null) {
                    locationHistory.add(extendedMode, location);
                }
                ++n3;
            }
        }
        ExtendedMode[] extendedModeArray = this.getModes();
        int n = extendedModeArray.length;
        int n4 = 0;
        while (n4 < n) {
            object = extendedModeArray[n4];
            pathArray = modeSettings.getSettings(((ExtendedMode)object).getModeIdentifier());
            if (pathArray != null) {
                this.getMode((ExtendedMode)object).readSetting((ModeSetting<Location>)pathArray);
            }
            ++n4;
        }
    }
}

