/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective.mode;

import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.mode.AbstractModePerspective;
import bibliothek.gui.dock.common.perspective.mode.CMaximizedModeAreaPerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedModeSetting;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.util.Path;
import java.util.HashMap;
import java.util.Map;

public class CMaximizedModePerspective
extends AbstractModePerspective<CMaximizedModeAreaPerspective> {
    private Map<String, Path> lastMaximizedMode = new HashMap<String, Path>();
    private Map<String, Location> lastMaximizedLocation = new HashMap<String, Location>();

    @Override
    public ExtendedMode getIdentifier() {
        return ExtendedMode.MAXIMIZED;
    }

    @Override
    public void add(CMaximizedModeAreaPerspective cMaximizedModeAreaPerspective) {
        super.add(cMaximizedModeAreaPerspective);
        this.forward(cMaximizedModeAreaPerspective);
    }

    private void forward(CMaximizedModeAreaPerspective cMaximizedModeAreaPerspective) {
        Path path = this.lastMaximizedMode.remove(cMaximizedModeAreaPerspective.getUniqueId());
        Location location = this.lastMaximizedLocation.remove(cMaximizedModeAreaPerspective.getUniqueId());
        cMaximizedModeAreaPerspective.setUnmaximize(path, location);
    }

    @Override
    public void readSetting(ModeSetting<Location> modeSetting) {
        if (modeSetting instanceof MaximizedModeSetting) {
            this.lastMaximizedLocation.clear();
            this.lastMaximizedMode.clear();
            this.lastMaximizedLocation.putAll(((MaximizedModeSetting)modeSetting).getLastMaximizedLocation());
            this.lastMaximizedMode.putAll(((MaximizedModeSetting)modeSetting).getLastMaximizedMode());
            int n = 0;
            int n2 = this.getAreaCount();
            while (n < n2) {
                this.forward((CMaximizedModeAreaPerspective)this.getArea(n));
                ++n;
            }
        }
    }

    @Override
    public void writeSetting(ModeSetting<Location> modeSetting) {
        if (modeSetting instanceof MaximizedModeSetting) {
            MaximizedModeSetting maximizedModeSetting = (MaximizedModeSetting)modeSetting;
            int n = 0;
            int n2 = this.getAreaCount();
            while (n < n2) {
                CMaximizedModeAreaPerspective cMaximizedModeAreaPerspective = (CMaximizedModeAreaPerspective)this.getArea(n);
                Path path = cMaximizedModeAreaPerspective.getUnmaximizeMode();
                if (path != null) {
                    maximizedModeSetting.getLastMaximizedMode().put(cMaximizedModeAreaPerspective.getUniqueId(), path);
                    Location location = cMaximizedModeAreaPerspective.getUnmaximizeLocation();
                    if (location != null) {
                        maximizedModeSetting.getLastMaximizedLocation().put(cMaximizedModeAreaPerspective.getUniqueId(), location);
                    }
                }
                ++n;
            }
        }
    }
}

