/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LocationHistory {
    private Map<ExtendedMode, Location> locations = new HashMap<ExtendedMode, Location>();
    private List<ExtendedMode> order = new LinkedList<ExtendedMode>();

    public void add(ExtendedMode extendedMode, Location location) {
        if (!extendedMode.getModeIdentifier().equals(location.getMode())) {
            throw new IllegalArgumentException("mode and location do not fit together");
        }
        this.locations.put(extendedMode, location);
        this.order.remove(extendedMode);
        this.order.add(extendedMode);
    }

    public void insert(int n, ExtendedMode extendedMode, Location location) {
        if (!extendedMode.getModeIdentifier().equals(location.getMode())) {
            throw new IllegalArgumentException("mode and location do not fit together");
        }
        this.locations.put(extendedMode, location);
        int n2 = this.order.indexOf(extendedMode);
        if (n2 > 0) {
            if (n2 < n) {
                --n;
            }
            this.order.remove(n2);
        }
        this.order.add(n, extendedMode);
    }

    public Location get(ExtendedMode extendedMode) {
        return this.locations.get(extendedMode);
    }

    public void remove(ExtendedMode extendedMode) {
        this.locations.remove(extendedMode);
        this.order.remove(extendedMode);
    }

    public int getSize() {
        return this.order.size();
    }

    public ExtendedMode getMode(int n) {
        return this.order.get(n);
    }

    public ExtendedMode getLastMode() {
        int n = this.getSize();
        if (n == 0) {
            return null;
        }
        return this.getMode(n - 1);
    }

    public List<Path> getOrder() {
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (ExtendedMode extendedMode : this.order) {
            arrayList.add(extendedMode.getModeIdentifier());
        }
        return arrayList;
    }

    public Map<Path, Location> getLocations() {
        HashMap<Path, Location> hashMap = new HashMap<Path, Location>();
        for (Location location : this.locations.values()) {
            hashMap.put(location.getMode(), location);
        }
        return hashMap;
    }
}

