/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.perspective.CContentPerspective;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.MultipleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.ShrinkablePerspectiveStation;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModeManagerPerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class CPerspective {
    private Map<String, CStationPerspective> stations = new HashMap<String, CStationPerspective>();
    private Map<String, CDockablePerspective> dockables = new HashMap<String, CDockablePerspective>();
    private LocationModeManagerPerspective locationModeManager;
    private CControlAccess control;

    public CPerspective(CControlAccess cControlAccess) {
        this.control = cControlAccess;
        this.initLocations();
    }

    private void initLocations() {
        this.locationModeManager = new LocationModeManagerPerspective(this, this.control);
        CLocationModeManager cLocationModeManager = this.control.getLocationManager();
        for (CLocationMode cLocationMode : cLocationModeManager.modes()) {
            LocationModePerspective locationModePerspective = cLocationMode.createPerspective();
            if (locationModePerspective != null) {
                this.locationModeManager.addMode(locationModePerspective);
                continue;
            }
            System.err.println("warning: mode " + cLocationMode.getClass() + " does not provide perspective");
        }
    }

    public LocationModeManagerPerspective getLocationManager() {
        return this.locationModeManager;
    }

    public void storeLocations() {
        Iterator<PerspectiveElement> iterator = this.elements();
        while (iterator.hasNext()) {
            CDockablePerspective cDockablePerspective;
            PerspectiveElement perspectiveElement = iterator.next();
            if (!(perspectiveElement instanceof CommonElementPerspective) || (cDockablePerspective = ((CommonElementPerspective)perspectiveElement).getElement().asDockable()) == null) continue;
            this.storeLocation(cDockablePerspective);
        }
    }

    public Location storeLocation(CDockablePerspective cDockablePerspective) {
        Location location = this.getLocationManager().getLocation(cDockablePerspective);
        if (location != null) {
            cDockablePerspective.getLocationHistory().add(this.getLocationManager().getMode(location.getMode()), location);
            String string = this.getId(cDockablePerspective);
            if (string != null) {
                this.dockables.put(string, cDockablePerspective);
            }
        }
        return location;
    }

    private String getId(CDockablePerspective cDockablePerspective) {
        String string = null;
        if (cDockablePerspective instanceof SingleCDockablePerspective) {
            string = ((SingleCDockablePerspective)cDockablePerspective).getUniqueId();
            if (string != null) {
                string = this.control.getRegister().toSingleId(string);
            }
        } else if (cDockablePerspective instanceof MultipleCDockablePerspective && (string = ((MultipleCDockablePerspective)cDockablePerspective).getUniqueId()) != null) {
            string = this.control.getRegister().toMultiId(string);
        }
        return string;
    }

    public void addStation(CStationPerspective cStationPerspective) {
        if (cStationPerspective == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.stations.put(cStationPerspective.getUniqueId(), cStationPerspective);
        cStationPerspective.setPerspective(this);
    }

    public CStationPerspective getStation(String string) {
        return this.stations.get(string);
    }

    public CDockablePerspective getDockable(String string) {
        return this.dockables.get(string);
    }

    public String[] getDockableKeys() {
        return this.dockables.keySet().toArray(new String[this.dockables.size()]);
    }

    public CDockablePerspective removeDockable(String string) {
        return this.dockables.remove(string);
    }

    public void putDockable(CDockablePerspective cDockablePerspective) {
        if (cDockablePerspective == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        String string = this.getId(cDockablePerspective);
        if (string != null) {
            this.dockables.put(string, cDockablePerspective);
        }
    }

    public String[] getStationKeys() {
        return this.stations.keySet().toArray(new String[this.stations.size()]);
    }

    public CContentPerspective getContentArea() {
        return this.getContentArea("ccontrol");
    }

    public CContentPerspective getContentArea(String string) {
        return new CContentPerspective(this, string);
    }

    public void shrink() {
        ArrayList<ShrinkablePerspectiveStation> arrayList = new ArrayList<ShrinkablePerspectiveStation>();
        Iterator<PerspectiveElement> iterator = this.elements();
        while (iterator.hasNext()) {
            PerspectiveElement perspectiveElement = iterator.next();
            if (!(perspectiveElement instanceof ShrinkablePerspectiveStation)) continue;
            arrayList.add((ShrinkablePerspectiveStation)perspectiveElement);
        }
        for (ShrinkablePerspectiveStation shrinkablePerspectiveStation : arrayList) {
            shrinkablePerspectiveStation.shrink();
        }
    }

    public Iterator<PerspectiveElement> elements() {
        return new ElementIterator();
    }

    private static class ElementFrame {
        public PerspectiveElement[] items;
        public int offset;

        public ElementFrame(PerspectiveElement[] perspectiveElementArray) {
            this.items = perspectiveElementArray;
        }
    }

    private class ElementIterator
    implements Iterator<PerspectiveElement> {
        private LinkedList<ElementFrame> stack = new LinkedList();

        public ElementIterator() {
            ArrayList<CommonElementPerspective> arrayList = new ArrayList<CommonElementPerspective>();
            for (CStationPerspective cStationPerspective : CPerspective.this.stations.values()) {
                if (cStationPerspective.asDockable() != null && cStationPerspective.asDockable().getParent() != null) continue;
                arrayList.add(cStationPerspective.intern());
            }
            this.stack.addFirst(new ElementFrame(arrayList.toArray(new PerspectiveElement[arrayList.size()])));
        }

        @Override
        public boolean hasNext() {
            for (ElementFrame elementFrame : this.stack) {
                if (elementFrame.offset >= elementFrame.items.length) continue;
                return true;
            }
            return false;
        }

        @Override
        public PerspectiveElement next() {
            while (this.stack.size() > 0) {
                ElementFrame elementFrame = this.stack.peek();
                if (elementFrame.offset < elementFrame.items.length) {
                    PerspectiveElement perspectiveElement;
                    PerspectiveStation perspectiveStation;
                    if ((perspectiveStation = (perspectiveElement = elementFrame.items[elementFrame.offset++]).asStation()) != null) {
                        PerspectiveElement[] perspectiveElementArray = new PerspectiveElement[perspectiveStation.getDockableCount()];
                        int n = 0;
                        while (n < perspectiveElementArray.length) {
                            perspectiveElementArray[n] = perspectiveStation.getDockable(n);
                            ++n;
                        }
                        this.stack.addFirst(new ElementFrame(perspectiveElementArray));
                    }
                    return perspectiveElement;
                }
                this.stack.poll();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

