/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.intern.CPlaceholderStrategy;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStackPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonDockStationPerspective;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.common.perspective.mode.CMaximizedModeAreaPerspective;
import bibliothek.gui.dock.common.perspective.mode.CMaximizedModePerspective;
import bibliothek.gui.dock.common.perspective.mode.CModeAreaPerspective;
import bibliothek.gui.dock.common.perspective.mode.CNormalModePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModeManagerPerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.split.GridNode;
import bibliothek.gui.dock.station.split.PerspectiveSplitDockGrid;
import bibliothek.gui.dock.station.split.PerspectiveSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPerspective;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;
import java.util.List;

public class CGridPerspective
extends SingleCDockablePerspective
implements CStationPerspective {
    private CommonSplitDockPerspective delegate;
    private PerspectiveSplitDockGrid grid;
    private boolean autoDeploy = true;
    private boolean gridChanges = false;
    private boolean onDeploy = false;
    private CPerspective perspective;
    private Path unmaximizeMode;
    private Location unmaximizeLocation;
    private boolean workingArea;
    private Path typeId;
    private boolean root = true;
    private CModeAreaPerspective normalMode = new CModeAreaPerspective(){

        @Override
        public String getUniqueId() {
            return CGridPerspective.this.getUniqueId();
        }

        @Override
        public boolean isChild(PerspectiveDockable perspectiveDockable) {
            if (perspectiveDockable.getParent() == CGridPerspective.this.intern()) {
                return CGridPerspective.this.delegate().getFullscreen() != perspectiveDockable;
            }
            return false;
        }

        @Override
        public boolean isChildLocation(DockableProperty dockableProperty) {
            return dockableProperty instanceof SplitDockProperty || dockableProperty instanceof SplitDockPathProperty || dockableProperty instanceof SplitDockPlaceholderProperty;
        }
    };
    private CMaximizedModeAreaPerspective maximalMode = new CMaximizedModeAreaPerspective(){

        @Override
        public String getUniqueId() {
            return CGridPerspective.this.getUniqueId();
        }

        @Override
        public boolean isChild(PerspectiveDockable perspectiveDockable) {
            if (perspectiveDockable.getParent() == CGridPerspective.this.intern()) {
                return CGridPerspective.this.delegate().getFullscreen() == perspectiveDockable;
            }
            return false;
        }

        @Override
        public void setUnmaximize(Path path, Location location) {
            CGridPerspective.this.unmaximizeLocation = location;
            CGridPerspective.this.unmaximizeMode = path;
        }

        @Override
        public Location getUnmaximizeLocation() {
            return CGridPerspective.this.unmaximizeLocation;
        }

        @Override
        public Path getUnmaximizeMode() {
            return CGridPerspective.this.unmaximizeMode;
        }

        @Override
        public boolean isChildLocation(DockableProperty dockableProperty) {
            return dockableProperty instanceof SplitDockFullScreenProperty;
        }
    };

    public CGridPerspective(String string) {
        this(string, null);
    }

    public CGridPerspective(String string, Path path) {
        this(string, path, false);
    }

    public CGridPerspective(String string, Path path, boolean bl) {
        super(string);
        this.delegate = new CommonSplitDockPerspective();
        this.delegate.setHasFullscreenAction(false);
        this.setWorkingArea(bl);
        this.gridClear();
        if (path == null) {
            path = CGridArea.TYPE_ID;
        }
        this.typeId = path;
    }

    @Override
    public boolean isWorkingArea() {
        return this.workingArea;
    }

    @Override
    public Path getTypeId() {
        return this.typeId;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public void setRoot(boolean bl) {
        this.root = bl;
    }

    public void setWorkingArea(boolean bl) {
        this.workingArea = bl;
    }

    @Override
    protected CommonSplitDockPerspective create() {
        return this.delegate;
    }

    private CommonSplitDockPerspective delegate() {
        return this.intern();
    }

    @Override
    public CommonSplitDockPerspective intern() {
        return (CommonSplitDockPerspective)super.intern();
    }

    @Override
    public void setPerspective(CPerspective cPerspective) {
        if (this.perspective != null) {
            ((CNormalModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.NORMALIZED)).remove(this.normalMode);
            ((CMaximizedModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.MAXIMIZED)).remove(this.maximalMode);
        }
        this.perspective = cPerspective;
        if (this.perspective != null) {
            ((CNormalModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.NORMALIZED)).add(this.normalMode);
            ((CMaximizedModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.MAXIMIZED)).add(this.maximalMode);
        }
    }

    @Override
    public CPerspective getPerspective() {
        return this.perspective;
    }

    protected void maybeDeploy() {
        if (this.isAutoDeploy() && this.gridChanges) {
            this.gridDeploy();
        }
    }

    private PerspectiveDockable[] convert(CDockablePerspective[] cDockablePerspectiveArray) {
        PerspectiveDockable[] perspectiveDockableArray = new PerspectiveDockable[cDockablePerspectiveArray.length];
        int n = 0;
        while (n < perspectiveDockableArray.length) {
            perspectiveDockableArray[n] = cDockablePerspectiveArray[n].intern().asDockable();
            ++n;
        }
        return perspectiveDockableArray;
    }

    public void unpack(double d, double d2, double d3, double d4) {
        this.gridChanges = true;
        this.grid.unpack(d, d2, d3, d4);
    }

    public void gridAdd(double d, double d2, double d3, double d4, CDockablePerspective ... cDockablePerspectiveArray) {
        this.gridChanges = true;
        this.grid.addDockable(d, d2, d3, d4, this.convert(cDockablePerspectiveArray));
    }

    public void gridPlaceholder(double d, double d2, double d3, double d4, CDockablePerspective ... cDockablePerspectiveArray) {
        this.gridChanges = true;
        Path[] pathArray = new Path[cDockablePerspectiveArray.length];
        int n = 0;
        while (n < cDockablePerspectiveArray.length) {
            pathArray[n] = cDockablePerspectiveArray[n].intern().asDockable().getPlaceholder();
            if (pathArray[n] == null) {
                throw new IllegalArgumentException("dockable '" + n + "' does not have a placeholder: " + cDockablePerspectiveArray[n]);
            }
            ++n;
        }
        this.grid.addPlaceholders(d, d2, d3, d4, pathArray);
    }

    public void gridPlaceholder(double d, double d2, double d3, double d4, Path ... pathArray) {
        this.gridChanges = true;
        this.grid.addPlaceholders(d, d2, d3, d4, pathArray);
    }

    public void gridSelect(double d, double d2, double d3, double d4, CDockablePerspective cDockablePerspective) {
        this.gridChanges = true;
        this.grid.setSelected(d, d2, d3, d4, cDockablePerspective == null ? null : cDockablePerspective.intern().asDockable());
    }

    public void gridHorizontal(double d, double d2, double d3) {
        this.gridChanges = true;
        this.grid.addHorizontalDivider(d, d2, d3);
    }

    public void gridVertical(double d, double d2, double d3) {
        this.gridChanges = true;
        this.grid.addVerticalDivider(d, d2, d3);
    }

    public void gridClear() {
        this.grid = new PerspectiveSplitDockGrid();
    }

    public void gridDeploy() {
        if (this.gridChanges) {
            this.gridChanges = false;
            try {
                this.onDeploy = true;
                this.delegate().read(this.grid.toTree(), null);
            }
            finally {
                this.onDeploy = false;
            }
        }
    }

    public void gridPrepare() {
        this.gridChanges = false;
        this.gridClear();
        this.handle(this.delegate().getRoot().getChild(), 0.0, 0.0, 100.0, 100.0);
    }

    private void handle(SplitDockPerspective.Entry entry, double d, double d2, double d3, double d4) {
        if (entry != null) {
            if (entry.asLeaf() != null) {
                PerspectiveDockable perspectiveDockable = entry.asLeaf().getDockable();
                if (perspectiveDockable != null) {
                    this.grid.addDockable(d, d2, d3, d4, perspectiveDockable);
                }
            } else {
                SplitDockPerspective.Node node = entry.asNode();
                double d5 = node.getDivider();
                if (node.getOrientation() == SplitDockStation.Orientation.HORIZONTAL) {
                    this.handle(node.getChildA(), d, d2, d3 * d5, d4);
                    this.handle(node.getChildB(), d + d3 * d5, d2, d3 * (1.0 - d5), d4);
                } else {
                    this.handle(node.getChildA(), d, d2, d3, d4 * d5);
                    this.handle(node.getChildB(), d, d2 + d4 * d5, d3, d4 * (1.0 - d5));
                }
            }
        }
    }

    public PerspectiveSplitDockGrid grid() {
        this.gridChanges = true;
        return this.grid;
    }

    public List<GridNode<PerspectiveDockable>> getGridNodes() {
        return this.grid.getGridNodes();
    }

    public void setAutoDeploy(boolean bl) {
        this.autoDeploy = bl;
    }

    public boolean isAutoDeploy() {
        return this.autoDeploy;
    }

    public SplitDockPerspective.Root getRoot() {
        return this.delegate().getRoot();
    }

    public void maximize(CDockablePerspective cDockablePerspective) {
        this.maximize(cDockablePerspective.intern().asDockable());
    }

    public void maximize(PerspectiveDockable perspectiveDockable) {
        Object object;
        this.maybeDeploy();
        LocationModeManagerPerspective locationModeManagerPerspective = this.perspective.getLocationManager();
        Location location = locationModeManagerPerspective.getLocation(perspectiveDockable);
        Path path = null;
        if (location == null) {
            object = locationModeManagerPerspective.getMode(perspectiveDockable);
            if (object != null) {
                path = ((ExtendedMode)object).getModeIdentifier();
            }
        } else {
            path = location.getMode();
        }
        if (perspectiveDockable.getParent() != this.intern()) {
            if (perspectiveDockable.getParent() != null) {
                perspectiveDockable.getParent().remove(perspectiveDockable);
            }
            object = this.getRoot();
            SplitDockPerspective.Leaf leaf = new SplitDockPerspective.Leaf(perspectiveDockable, null, null, -1L);
            if (((SplitDockPerspective.Root)object).getChild() == null) {
                ((SplitDockPerspective.Root)object).setChild(leaf);
            } else {
                ((SplitDockPerspective.Root)object).setChild(new SplitDockPerspective.Node(SplitDockStation.Orientation.HORIZONTAL, 0.5, leaf, ((SplitDockPerspective.Root)object).getChild(), null, null, -1L));
            }
        }
        this.delegate.setFullscreen(perspectiveDockable);
        this.unmaximizeLocation = location;
        this.unmaximizeMode = path;
    }

    public PerspectiveDockable getMaximized() {
        return this.delegate().getFullscreen();
    }

    @Override
    public CStationPerspective asStation() {
        return this;
    }

    public String getFactoryID() {
        return this.delegate().getFactoryID();
    }

    public PlaceholderMap getPlaceholders() {
        return this.delegate().getPlaceholders();
    }

    public void setPlaceholders(PlaceholderMap placeholderMap) {
        this.delegate().setPlaceholders(placeholderMap);
    }

    public class CommonSplitDockPerspective
    extends SplitDockPerspective
    implements CommonDockStationPerspective {
        @Override
        public CElementPerspective getElement() {
            return CGridPerspective.this;
        }

        @Override
        public String getFactoryID() {
            return "CommonDockStationFactory";
        }

        @Override
        public String getConverterID() {
            return super.getFactoryID();
        }

        @Override
        public void read(PerspectiveSplitDockTree perspectiveSplitDockTree, PerspectiveDockable perspectiveDockable) {
            super.read(perspectiveSplitDockTree, perspectiveDockable);
            if (!CGridPerspective.this.onDeploy) {
                CGridPerspective.this.gridPrepare();
            }
        }

        @Override
        protected PerspectiveDockable combine(PerspectiveDockable[] perspectiveDockableArray, PerspectiveDockable perspectiveDockable) {
            return new CStackPerspective(perspectiveDockableArray, perspectiveDockable);
        }

        @Override
        public Path getPlaceholder() {
            return CPlaceholderStrategy.getSingleDockablePlaceholder(CGridPerspective.this.getUniqueId());
        }

        @Override
        public SplitDockPerspective.Root getRoot() {
            CGridPerspective.this.maybeDeploy();
            return super.getRoot();
        }

        @Override
        public int getDockableCount() {
            CGridPerspective.this.maybeDeploy();
            return super.getDockableCount();
        }

        @Override
        public PerspectiveDockable getDockable(int n) {
            CGridPerspective.this.maybeDeploy();
            return super.getDockable(n);
        }
    }
}

