/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.layout.CControlPerspectiveResource;
import bibliothek.gui.dock.common.perspective.CControlPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.frontend.SettingsBlop;
import bibliothek.gui.dock.support.util.ApplicationResourceManager;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CControlPerspectiveBlop {
    private CControlPerspective control;
    private ApplicationResourceManager resourceManager = new ApplicationResourceManager();
    private CControlPerspectiveResource resource;

    public CControlPerspectiveBlop(CControlPerspective cControlPerspective) {
        if (cControlPerspective == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = cControlPerspective;
        this.resource = new CControlPerspectiveResource(cControlPerspective);
        try {
            this.resourceManager.put("ccontrol.frontend", this.resource);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("This cannot happen", iOException);
        }
    }

    public String[] getPerspectiveNames() {
        return this.resource.getSettings().getNames();
    }

    public CSetting getSetting(String string) {
        return (CSetting)this.resource.getSettings().getSetting(string);
    }

    public CPerspective getPerspective(String string) {
        CSetting cSetting = this.getSetting(string);
        if (cSetting == null) {
            return null;
        }
        return this.control.read(cSetting, false);
    }

    public void putPerspective(String string, CPerspective cPerspective) {
        if (string == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (cPerspective == null) {
            throw new IllegalArgumentException("perspective must not be null");
        }
        CSetting cSetting = this.control.write(cPerspective, false);
        this.putSetting(string, cSetting);
    }

    public void putSetting(String string, CSetting cSetting) {
        this.resource.getSettings().put(string, cSetting);
    }

    public void removePerspective(String string) {
        this.resource.getSettings().remove(string);
    }

    public String getPerspectiveName() {
        return this.resource.getSettings().getCurrentName();
    }

    public void setPerspectiveName(String string) {
        SettingsBlop settingsBlop = this.resource.getSettings();
        settingsBlop.setCurrent(string, settingsBlop.getCurrentSetting());
    }

    public CPerspective getPerspective() {
        CSetting cSetting = this.getSetting();
        if (cSetting == null) {
            return null;
        }
        return this.control.read(cSetting, true);
    }

    public CSetting getSetting() {
        return (CSetting)this.resource.getSettings().getCurrentSetting();
    }

    public void setPerspective(CPerspective cPerspective) {
        CSetting cSetting = this.control.write(cPerspective, true);
        this.setSetting(cSetting);
    }

    public void setSetting(CSetting cSetting) {
        SettingsBlop settingsBlop = this.resource.getSettings();
        settingsBlop.setCurrent(settingsBlop.getCurrentName(), cSetting);
    }

    public void readXML(XElement xElement) throws XException {
        this.resourceManager.readXML(xElement);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.resourceManager.readStream(dataInputStream);
    }

    public void writeXML(XElement xElement) {
        this.resource.writeXML(xElement);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        this.resource.write(dataOutputStream);
    }
}

