/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableLayout;
import bibliothek.gui.dock.common.intern.station.CommonDockStationFactory;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CControlPerspectiveBlop;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.LocationHistory;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationSettingConverter;
import bibliothek.gui.dock.frontend.DockFrontendPerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.RegisteringDockFactory;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.perspective.Perspective;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.perspective.PredefinedPerspective;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CControlPerspective {
    private CControlAccess control;

    public CControlPerspective(CControlAccess cControlAccess) {
        if (cControlAccess == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = cControlAccess;
    }

    public CControl getControl() {
        return this.control.getOwner();
    }

    public CPerspective createEmptyPerspective() {
        CPerspective cPerspective = new CPerspective(this.control);
        for (CStation<?> cStation : this.control.getOwner().getStations()) {
            cPerspective.addStation(cStation.createPerspective());
        }
        return cPerspective;
    }

    public CPerspective getPerspective(boolean bl) {
        Setting setting = this.control.getOwner().intern().getSetting(!bl);
        return this.convert((CSetting)setting, bl);
    }

    public String[] getNames() {
        return this.control.getOwner().layouts();
    }

    public CPerspective getPerspective(String string) {
        return this.getPerspective(string, false);
    }

    public CPerspective getPerspective(String string, boolean bl) {
        Setting setting = this.control.getOwner().intern().getSetting(string);
        if (setting == null) {
            return null;
        }
        return this.convert((CSetting)setting, bl);
    }

    public void setPerspective(CPerspective cPerspective, boolean bl) {
        this.control.getOwner().intern().setSetting(this.convert(cPerspective, bl), !bl);
    }

    public void setPerspective(String string, CPerspective cPerspective) {
        this.setPerspective(string, cPerspective, false);
    }

    public void setPerspective(String string, CPerspective cPerspective, boolean bl) {
        this.control.getOwner().intern().setSetting(string, this.convert(cPerspective, bl));
    }

    public void removePerspective(String string) {
        this.control.getOwner().delete(string);
    }

    public void renamePerspective(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("destination is null");
        }
        CDockFrontend cDockFrontend = this.control.getOwner().intern();
        Setting setting = cDockFrontend.getSetting(string);
        if (setting == null) {
            throw new IllegalArgumentException("no perspective registered with name '" + string + "'");
        }
        cDockFrontend.setSetting(string2, setting);
        cDockFrontend.delete(string);
        if (string.equals(cDockFrontend.getCurrentSetting())) {
            cDockFrontend.setCurrentSettingName(string2);
        }
    }

    public void writeXML(XElement xElement, CPerspective cPerspective) {
        this.writeXML(xElement, cPerspective, true);
    }

    public void writeXML(XElement xElement, CPerspective cPerspective, boolean bl) {
        Object object;
        cPerspective.storeLocations();
        DockFrontendPerspective dockFrontendPerspective = this.conversion(cPerspective, bl);
        PredefinedPerspective predefinedPerspective = dockFrontendPerspective.getPerspective();
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        String[] stringArray = cPerspective.getStationKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            CStationPerspective cStationPerspective = cPerspective.getStation((String)object);
            if (cStationPerspective.asDockable() == null || cStationPerspective.asDockable().getParent() == null) {
                hashMap.put((String)object, predefinedPerspective.convert(cStationPerspective.intern()));
            }
            ++n2;
        }
        ((Perspective)predefinedPerspective).getSituation().writeCompositionsXML(hashMap, xElement.addElement("stations"));
        object = xElement.addElement("invisible");
        PropertyTransformer propertyTransformer = dockFrontendPerspective.getPropertyTransformer();
        String[] stringArray2 = cPerspective.getDockableKeys();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray2[n4];
            CDockablePerspective cDockablePerspective = cPerspective.getDockable(string);
            Location location = this.getInvisibleLocation(cDockablePerspective);
            if (location != null) {
                XElement xElement2 = ((XElement)object).addElement("dockable");
                xElement2.addString("key", string);
                if (cDockablePerspective.getParent() == null) {
                    ((Perspective)predefinedPerspective).getSituation().writeCompositionXML(predefinedPerspective.convert(cDockablePerspective.intern()), xElement2.addElement("content"));
                }
                XElement xElement3 = xElement2.addElement("location");
                xElement3.addString("root", location.getRoot());
                xElement3.addString("mode", cDockablePerspective.getLocationHistory().getLastMode().getModeIdentifier().toString());
                xElement3.addBoolean("applicationDefined", location.isApplicationDefined());
                propertyTransformer.writeXML(location.getLocation(), xElement3);
            }
            ++n4;
        }
        ModeSettings<Location, Location> modeSettings = cPerspective.getLocationManager().writeModes(this.control);
        modeSettings.writeXML(xElement.addElement("modes"));
    }

    public void write(DataOutputStream dataOutputStream, CPerspective cPerspective) throws IOException {
        this.write(dataOutputStream, cPerspective, true);
    }

    public void write(DataOutputStream dataOutputStream, CPerspective cPerspective, boolean bl) throws IOException {
        String[] stringArray;
        cPerspective.storeLocations();
        Version.write(dataOutputStream, Version.VERSION_1_1_2);
        DockFrontendPerspective dockFrontendPerspective = this.conversion(cPerspective, bl);
        PredefinedPerspective predefinedPerspective = dockFrontendPerspective.getPerspective();
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        String[] stringArray2 = cPerspective.getStationKeys();
        int n = stringArray2.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray = stringArray2[n2];
            CStationPerspective cStationPerspective = cPerspective.getStation((String)stringArray);
            hashMap.put((String)stringArray, predefinedPerspective.convert(cStationPerspective.intern()));
            ++n2;
        }
        ((Perspective)predefinedPerspective).getSituation().writeCompositions(hashMap, dataOutputStream);
        stringArray = cPerspective.getDockableKeys();
        dataOutputStream.writeInt(stringArray.length);
        PropertyTransformer propertyTransformer = dockFrontendPerspective.getPropertyTransformer();
        String[] stringArray3 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray3[n4];
            CDockablePerspective cDockablePerspective = cPerspective.getDockable(string);
            Location location = this.getInvisibleLocation(cDockablePerspective);
            if (location != null) {
                dataOutputStream.writeBoolean(true);
                dataOutputStream.writeUTF(string);
                if (cDockablePerspective.getParent() == null) {
                    dataOutputStream.writeBoolean(true);
                    ((Perspective)predefinedPerspective).getSituation().writeComposition(predefinedPerspective.convert(cDockablePerspective.intern()), dataOutputStream);
                } else {
                    dataOutputStream.writeBoolean(false);
                }
                dataOutputStream.writeUTF(location.getRoot());
                dataOutputStream.writeUTF(cDockablePerspective.getLocationHistory().getLastMode().getModeIdentifier().toString());
                dataOutputStream.writeBoolean(location.isApplicationDefined());
                propertyTransformer.write(location.getLocation(), dataOutputStream);
            } else {
                dataOutputStream.writeBoolean(false);
            }
            ++n4;
        }
        ModeSettings<Location, Location> modeSettings = cPerspective.getLocationManager().writeModes(this.control);
        modeSettings.write(dataOutputStream);
    }

    public CSetting write(CPerspective cPerspective, boolean bl) {
        return this.convert(cPerspective, bl);
    }

    public CControlPerspectiveBlop readAllXML(XElement xElement) throws XException {
        CControlPerspectiveBlop cControlPerspectiveBlop = new CControlPerspectiveBlop(this);
        cControlPerspectiveBlop.readXML(xElement);
        return cControlPerspectiveBlop;
    }

    public CPerspective readXML(XElement xElement) throws XException {
        return this.readXML(xElement, true);
    }

    public CPerspective readXML(XElement xElement, boolean bl) throws XException {
        Object n2;
        Object object;
        Object object2;
        CPerspective cPerspective = this.createEmptyPerspective();
        PerspectiveElementFactory perspectiveElementFactory = new PerspectiveElementFactory(cPerspective);
        DockFrontendPerspective dockFrontendPerspective = this.wrap(cPerspective, bl, perspectiveElementFactory);
        PredefinedPerspective predefinedPerspective = dockFrontendPerspective.getPerspective();
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> object42 : this.control.getRegister().getFactories().entrySet()) {
            ((Perspective)predefinedPerspective).getSituation().add(new CommonMultipleDockableFactory(object42.getKey(), object42.getValue(), this.control, cPerspective));
        }
        XElement xElement2 = xElement.getElement("stations");
        if (xElement2 == null) {
            throw new XException("missing element 'stations'");
        }
        Map<String, DockLayoutComposition> map = ((Perspective)predefinedPerspective).getSituation().readCompositionsXML(xElement2);
        perspectiveElementFactory.setStations(map);
        Object object3 = map.values().iterator();
        while (object3.hasNext()) {
            object2 = (DockLayoutComposition)object3.next();
            object = predefinedPerspective.convert((DockLayoutComposition)object2);
            if (!(object instanceof CommonElementPerspective) || (n2 = ((CommonElementPerspective)object).getElement().asStation()) == null) continue;
            cPerspective.addStation((CStationPerspective)n2);
        }
        cPerspective.storeLocations();
        object2 = xElement.getElement("invisible");
        if (object2 != null) {
            object3 = dockFrontendPerspective.getPropertyTransformer();
            XElement[] xElementArray = ((XElement)object2).getElements("dockable");
            int n = xElementArray.length;
            int n3 = 0;
            while (n3 < n) {
                Object object4;
                XElement xElement3;
                object = xElementArray[n3];
                String string = ((XElement)object).getString("key");
                CDockablePerspective cDockablePerspective = cPerspective.getDockable(string);
                if (cDockablePerspective == null && (xElement3 = ((XElement)object).getElement("content")) != null && (object4 = predefinedPerspective.convert(((Perspective)predefinedPerspective).getSituation().readCompositionXML(xElement3))) instanceof CommonElementPerspective && (cDockablePerspective = ((CommonElementPerspective)object4).getElement().asDockable()) != null) {
                    cPerspective.putDockable(cDockablePerspective);
                }
                if (cDockablePerspective != null) {
                    ExtendedMode extendedMode;
                    xElement3 = ((XElement)object).getElement("location");
                    object4 = xElement3.getString("root");
                    DockableProperty dockableProperty = ((PropertyTransformer)object3).readXML(xElement3);
                    Path path = new Path(xElement3.getString("mode"));
                    boolean bl2 = false;
                    if (xElement3.attributeExists("applicationDefined")) {
                        bl2 = xElement3.getBoolean("applicationDefined");
                    }
                    if ((extendedMode = cPerspective.getLocationManager().getMode(path)) != null) {
                        cDockablePerspective.getLocationHistory().add(extendedMode, new Location(path, (String)object4, dockableProperty, bl2));
                    }
                }
                ++n3;
            }
        }
        if ((object3 = xElement.getElement("modes")) == null) {
            throw new XException("missing element 'modes'");
        }
        object = new LocationSettingConverter(this.control.getOwner().getController());
        n2 = this.control.getOwner().getLocationManager().createModeSettings(object);
        ((ModeSettings)n2).readXML((XElement)object3);
        cPerspective.getLocationManager().readModes((ModeSettings<Location, ?>)n2, cPerspective, this.control);
        return cPerspective;
    }

    public CControlPerspectiveBlop readAll(DataInputStream dataInputStream) throws IOException {
        CControlPerspectiveBlop cControlPerspectiveBlop = new CControlPerspectiveBlop(this);
        cControlPerspectiveBlop.read(dataInputStream);
        return cControlPerspectiveBlop;
    }

    public CPerspective read(DataInputStream dataInputStream) throws IOException {
        return this.read(dataInputStream, true);
    }

    public CPerspective read(DataInputStream dataInputStream, boolean bl) throws IOException {
        Object object;
        Object object222;
        Version version = Version.read(dataInputStream);
        boolean bl2 = version.equals(Version.VERSION_1_1_1);
        boolean bl3 = version.equals(Version.VERSION_1_1_1a);
        boolean bl4 = version.equals(Version.VERSION_1_1_2);
        if (!(bl2 || bl3 || bl4)) {
            throw new IOException("unknown version: " + version);
        }
        CPerspective cPerspective = this.createEmptyPerspective();
        PerspectiveElementFactory perspectiveElementFactory = new PerspectiveElementFactory(cPerspective);
        DockFrontendPerspective dockFrontendPerspective = this.wrap(cPerspective, bl, perspectiveElementFactory);
        PredefinedPerspective predefinedPerspective = dockFrontendPerspective.getPerspective();
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> object32 : this.control.getRegister().getFactories().entrySet()) {
            ((Perspective)predefinedPerspective).getSituation().add(new CommonMultipleDockableFactory(object32.getKey(), object32.getValue(), this.control, cPerspective));
        }
        Map<String, DockLayoutComposition> map = ((Perspective)predefinedPerspective).getSituation().readCompositions(dataInputStream);
        perspectiveElementFactory.setStations(map);
        for (Object object222 : map.values()) {
            PerspectiveElement n2 = predefinedPerspective.convert((DockLayoutComposition)object222);
            if (!(n2 instanceof CommonElementPerspective) || (object = ((CommonElementPerspective)n2).getElement().asStation()) == null) continue;
            cPerspective.addStation((CStationPerspective)object);
        }
        if (bl3 || bl4) {
            cPerspective.storeLocations();
            object222 = dockFrontendPerspective.getPropertyTransformer();
            int n = 0;
            int n2 = dataInputStream.readInt();
            while (n < n2) {
                if (dataInputStream.readBoolean()) {
                    Object object2;
                    CDockablePerspective cDockablePerspective;
                    object = dataInputStream.readUTF();
                    DockLayoutComposition dockLayoutComposition = null;
                    if (dataInputStream.readBoolean()) {
                        dockLayoutComposition = ((Perspective)predefinedPerspective).getSituation().readComposition(dataInputStream);
                    }
                    if ((cDockablePerspective = cPerspective.getDockable((String)object)) == null && dockLayoutComposition != null && (object2 = predefinedPerspective.convert(dockLayoutComposition)) instanceof CommonElementPerspective && (cDockablePerspective = ((CommonElementPerspective)object2).getElement().asDockable()) != null) {
                        cPerspective.putDockable(cDockablePerspective);
                    }
                    object2 = dataInputStream.readUTF();
                    String string = dataInputStream.readUTF();
                    boolean bl5 = false;
                    if (bl4) {
                        bl5 = dataInputStream.readBoolean();
                    }
                    DockableProperty dockableProperty = ((PropertyTransformer)object222).read(dataInputStream);
                    if (cDockablePerspective != null) {
                        Path path = new Path(string);
                        ExtendedMode extendedMode = cPerspective.getLocationManager().getMode(path);
                        if (extendedMode != null) {
                            cDockablePerspective.getLocationHistory().add(extendedMode, new Location(path, (String)object2, dockableProperty, bl5));
                        }
                    }
                }
                ++n;
            }
        }
        object222 = new LocationSettingConverter(this.control.getOwner().getController());
        ModeSettings n = this.control.getOwner().getLocationManager().createModeSettings(object222);
        n.read(dataInputStream);
        cPerspective.getLocationManager().readModes(n, cPerspective, this.control);
        return cPerspective;
    }

    public CPerspective read(CSetting cSetting, boolean bl) {
        return this.convert(cSetting, bl);
    }

    private CSetting convert(CPerspective cPerspective, boolean bl) {
        CElementPerspective cElementPerspective;
        Object object;
        cPerspective.storeLocations();
        DockFrontendPerspective dockFrontendPerspective = this.conversion(cPerspective, bl);
        PredefinedPerspective predefinedPerspective = dockFrontendPerspective.getPerspective();
        CSetting cSetting = new CSetting();
        String[] stringArray = cPerspective.getStationKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            cElementPerspective = cPerspective.getStation((String)object);
            if (cElementPerspective.asDockable() == null || cElementPerspective.asDockable().getParent() == null) {
                cSetting.putRoot((String)object, predefinedPerspective.convert(cElementPerspective.intern()));
            }
            ++n2;
        }
        stringArray = cPerspective.getDockableKeys();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            cElementPerspective = cPerspective.getDockable((String)object);
            Location location = this.getInvisibleLocation((CDockablePerspective)cElementPerspective);
            if (location != null) {
                cSetting.addInvisible((String)object, location.getRoot(), null, location.getLocation());
            }
            ++n2;
        }
        object = cPerspective.getLocationManager().writeModes(this.control);
        cSetting.setModes((ModeSettings<Location, Location>)object);
        return cSetting;
    }

    private CPerspective convert(CSetting cSetting, boolean bl) {
        CPerspective cPerspective = this.createEmptyPerspective();
        PerspectiveElementFactory perspectiveElementFactory = new PerspectiveElementFactory(cPerspective);
        DockFrontendPerspective dockFrontendPerspective = this.wrap(cPerspective, bl, perspectiveElementFactory);
        PredefinedPerspective predefinedPerspective = dockFrontendPerspective.getPerspective();
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> object2 : this.control.getRegister().getFactories().entrySet()) {
            ((Perspective)predefinedPerspective).getSituation().add(new CommonMultipleDockableFactory(object2.getKey(), object2.getValue(), this.control, cPerspective));
        }
        HashMap<String, DockLayoutComposition> hashMap = new HashMap<String, DockLayoutComposition>();
        Object object = cSetting.getRootKeys();
        int perspectiveElement = ((String[])object).length;
        int n = 0;
        while (n < perspectiveElement) {
            Object object4 = object[n];
            hashMap.put((String)object4, cSetting.getRoot((String)object4));
            ++n;
        }
        perspectiveElementFactory.setStations(hashMap);
        for (Object object4 : hashMap.values()) {
            PerspectiveElement dockLayoutComposition = predefinedPerspective.convert((DockLayoutComposition)object4);
            if (!(dockLayoutComposition instanceof CommonElementPerspective) || (object = ((CommonElementPerspective)dockLayoutComposition).getElement().asStation()) == null) continue;
            cPerspective.addStation((CStationPerspective)object);
        }
        int n3 = 0;
        int n2 = cSetting.getInvisibleCount();
        while (n3 < n2) {
            CDockablePerspective cDockablePerspective;
            DockLayoutComposition dockLayoutComposition = cSetting.getInvisibleLayout(n3);
            if (dockLayoutComposition != null && (object = predefinedPerspective.convert(dockLayoutComposition)) instanceof CommonElementPerspective && (cDockablePerspective = ((CommonElementPerspective)object).getElement().asDockable()) != null) {
                DockableProperty dockableProperty = cSetting.getInvisibleLocation(n3);
                String string = cSetting.getInvisibleRoot(n3);
                ExtendedMode extendedMode = cPerspective.getLocationManager().getMode(string, dockableProperty);
                if (extendedMode != null) {
                    cDockablePerspective.getLocationHistory().add(extendedMode, new Location(extendedMode.getModeIdentifier(), string, dockableProperty, false));
                }
                cPerspective.putDockable(cDockablePerspective);
            }
            ++n3;
        }
        ModeSettings<Location, Location> modeSettings = cSetting.getModes();
        cPerspective.getLocationManager().readModes(modeSettings, cPerspective, this.control);
        return cPerspective;
    }

    private Location getInvisibleLocation(CDockablePerspective cDockablePerspective) {
        LocationHistory locationHistory = cDockablePerspective.getLocationHistory();
        List<Path> list = locationHistory.getOrder();
        if (!list.isEmpty()) {
            Path path = list.get(list.size() - 1);
            Location location = locationHistory.getLocations().get(path);
            return location;
        }
        return null;
    }

    public DockFrontendPerspective conversion(CPerspective cPerspective, boolean bl) {
        DockFrontendPerspective dockFrontendPerspective = this.wrap(cPerspective, bl);
        PredefinedDockSituation predefinedDockSituation = dockFrontendPerspective.getPerspective().getSituation();
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : this.control.getRegister().getFactories().entrySet()) {
            predefinedDockSituation.add(new CommonMultipleDockableFactory(entry.getKey(), entry.getValue(), this.control, cPerspective));
        }
        return dockFrontendPerspective;
    }

    private DockFrontendPerspective wrap(CPerspective cPerspective, boolean bl) {
        PerspectiveElementFactory perspectiveElementFactory = new PerspectiveElementFactory(cPerspective);
        return this.wrap(cPerspective, bl, perspectiveElementFactory);
    }

    private DockFrontendPerspective wrap(CPerspective cPerspective, boolean bl, PerspectiveElementFactory perspectiveElementFactory) {
        DockFrontendPerspective dockFrontendPerspective = this.control.getOwner().intern().getPerspective(!bl, perspectiveElementFactory);
        PredefinedPerspective predefinedPerspective = dockFrontendPerspective.getPerspective();
        perspectiveElementFactory.setBasePerspective(predefinedPerspective);
        CommonSingleDockableFactory commonSingleDockableFactory = new CommonSingleDockableFactory(this.control.getOwner(), cPerspective);
        predefinedPerspective.getSituation().add(commonSingleDockableFactory);
        predefinedPerspective.getSituation().addBackup(new RegisteringDockFactory<CommonDockable, CommonElementPerspective, CommonSingleDockableLayout>(this.control.getOwner().intern(), commonSingleDockableFactory));
        predefinedPerspective.getSituation().add(new CommonDockStationFactory(this.control.getOwner(), perspectiveElementFactory, commonSingleDockableFactory));
        return dockFrontendPerspective;
    }

    private class PerspectiveElementFactory
    implements FrontendPerspectiveCache {
        private CPerspective perspective;
        private Perspective basePerspective;
        private Map<String, SingleCDockablePerspective> dockables = new HashMap<String, SingleCDockablePerspective>();
        private Map<String, DockLayoutComposition> stations;

        public PerspectiveElementFactory(CPerspective cPerspective) {
            this.perspective = cPerspective;
            Iterator<PerspectiveElement> iterator = cPerspective.elements();
            while (iterator.hasNext()) {
                PerspectiveElement perspectiveElement = iterator.next();
                if (!(perspectiveElement instanceof SingleCDockablePerspective)) continue;
                SingleCDockablePerspective singleCDockablePerspective = (SingleCDockablePerspective)((Object)perspectiveElement);
                this.dockables.put(singleCDockablePerspective.getUniqueId(), singleCDockablePerspective);
            }
        }

        public void setStations(Map<String, DockLayoutComposition> map) {
            this.stations = map;
        }

        public void setBasePerspective(Perspective perspective) {
            this.basePerspective = perspective;
        }

        @Override
        public PerspectiveElement get(String string, DockElement dockElement, boolean bl) {
            if (bl) {
                return this.perspective.getStation(string).intern();
            }
            if (dockElement instanceof CommonDockable) {
                CDockable cDockable = ((CommonDockable)dockElement).getDockable();
                if (cDockable.asStation() != null) {
                    CStationPerspective cStationPerspective = this.perspective.getStation(cDockable.asStation().getUniqueId());
                    if (cStationPerspective == null) {
                        throw new IllegalArgumentException("Found a non-root CStation that is not registered: " + cDockable.asStation().getUniqueId());
                    }
                    return cStationPerspective.intern();
                }
                if (cDockable instanceof SingleCDockable) {
                    String string2 = ((SingleCDockable)cDockable).getUniqueId();
                    SingleCDockablePerspective singleCDockablePerspective = this.dockables.get(string2);
                    if (singleCDockablePerspective == null) {
                        singleCDockablePerspective = new SingleCDockablePerspective(string2);
                        this.dockables.put(string2, singleCDockablePerspective);
                    }
                    return singleCDockablePerspective.intern();
                }
                if (cDockable instanceof MultipleCDockable) {
                    return null;
                }
            }
            throw new IllegalArgumentException("The intern DockFrontend of the CControl has elements registered that are not SingleCDockables: " + string + "=" + dockElement);
        }

        @Override
        public PerspectiveElement get(String string, boolean bl) {
            String string2 = string;
            if (!bl && CControlPerspective.this.control.getRegister().isSingleId(string)) {
                string2 = CControlPerspective.this.control.getRegister().singleToNormalId(string);
            }
            DockLayoutComposition dockLayoutComposition = null;
            if (this.stations != null) {
                dockLayoutComposition = this.stations.get(string2);
            }
            if (dockLayoutComposition == null) {
                dockLayoutComposition = this.getPredefinedStation(string2, this.basePerspective.getSituation());
            }
            if (dockLayoutComposition != null) {
                CStationPerspective cStationPerspective = this.perspective.getStation(string2);
                if (cStationPerspective == null) {
                    return null;
                }
                return cStationPerspective.intern();
            }
            if (CControlPerspective.this.control.getRegister().isSingleId(string)) {
                SingleCDockablePerspective singleCDockablePerspective = this.dockables.get(string2);
                if (singleCDockablePerspective == null) {
                    singleCDockablePerspective = new SingleCDockablePerspective(string2);
                    this.dockables.put(string2, singleCDockablePerspective);
                }
                return singleCDockablePerspective.intern();
            }
            return null;
        }

        protected DockLayoutComposition getPredefinedStation(String string, DockSituation dockSituation) {
            if (this.stations != null) {
                for (DockLayoutComposition dockLayoutComposition : this.stations.values()) {
                    DockLayoutComposition dockLayoutComposition2 = this.getPredefinedStation(string, dockLayoutComposition, dockSituation);
                    if (dockLayoutComposition2 == null) continue;
                    return dockLayoutComposition2;
                }
            }
            return null;
        }

        private DockLayoutComposition getPredefinedStation(String string, DockLayoutComposition dockLayoutComposition, DockSituation dockSituation) {
            List<DockLayoutComposition> list;
            String string2 = dockSituation.getIdentifier(dockLayoutComposition);
            if (string2 != null) {
                if (string.length() == "root".length() + string.length() && string2.startsWith("root") && string2.endsWith(string)) {
                    return dockLayoutComposition;
                }
                if (string2.startsWith("dockable")) {
                    string2 = string2.substring("dockable".length());
                    if (CControlPerspective.this.control.getRegister().isSingleId(string2)) {
                        string2 = CControlPerspective.this.control.getRegister().singleToNormalId(string2);
                    } else if (CControlPerspective.this.control.getRegister().isMultiId(string2)) {
                        string2 = CControlPerspective.this.control.getRegister().multiToNormalId(string2);
                    }
                    if (string2.equals(string)) {
                        return dockLayoutComposition;
                    }
                }
            }
            if ((list = dockLayoutComposition.getChildren()) != null) {
                for (DockLayoutComposition dockLayoutComposition2 : list) {
                    DockLayoutComposition dockLayoutComposition3 = this.getPredefinedStation(string, dockLayoutComposition2, dockSituation);
                    if (dockLayoutComposition3 == null) continue;
                    return dockLayoutComposition3;
                }
            }
            return null;
        }

        @Override
        public String get(PerspectiveElement perspectiveElement) {
            Object object;
            String[] stringArray = this.perspective.getStationKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = stringArray[n2];
                CStationPerspective cStationPerspective = this.perspective.getStation((String)object);
                if (cStationPerspective.intern() == perspectiveElement) {
                    return object;
                }
                ++n2;
            }
            if (perspectiveElement instanceof CommonElementPerspective && (object = ((CommonElementPerspective)perspectiveElement).getElement()) instanceof SingleCDockablePerspective) {
                return CControlPerspective.this.control.getRegister().toSingleId(((SingleCDockablePerspective)object).getUniqueId());
            }
            return null;
        }

        @Override
        public boolean isRootStation(PerspectiveStation perspectiveStation) {
            String[] stringArray = this.perspective.getStationKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                CStationPerspective cStationPerspective = this.perspective.getStation(string);
                if (cStationPerspective.intern() == perspectiveStation) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

