/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.perspective.CGridPerspective;
import bibliothek.gui.dock.common.perspective.CMinimizePerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;

public class CContentPerspective {
    private CPerspective perspective;
    private String id;

    public CContentPerspective(CPerspective cPerspective, String string) {
        if (cPerspective == null) {
            throw new IllegalArgumentException("perspective must not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        this.perspective = cPerspective;
        this.id = string;
        String string2 = CContentArea.getCenterIdentifier(string);
        String string3 = CContentArea.getNorthIdentifier(string);
        String string4 = CContentArea.getSouthIdentifier(string);
        String string5 = CContentArea.getEastIdentifier(string);
        String string6 = CContentArea.getWestIdentifier(string);
        this.ensureType(string2, CGridPerspective.class);
        this.ensureType(string3, CMinimizePerspective.class);
        this.ensureType(string4, CMinimizePerspective.class);
        this.ensureType(string5, CMinimizePerspective.class);
        this.ensureType(string6, CMinimizePerspective.class);
        if (cPerspective.getStation(string2) == null) {
            cPerspective.addStation(new CGridPerspective(string2, CContentArea.TYPE_ID_CENTER, false));
        }
        if (cPerspective.getStation(string3) == null) {
            cPerspective.addStation(new CMinimizePerspective(string3, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (cPerspective.getStation(string4) == null) {
            cPerspective.addStation(new CMinimizePerspective(string4, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (cPerspective.getStation(string5) == null) {
            cPerspective.addStation(new CMinimizePerspective(string5, CContentArea.TYPE_ID_MINIMIZE));
        }
        if (cPerspective.getStation(string6) == null) {
            cPerspective.addStation(new CMinimizePerspective(string6, CContentArea.TYPE_ID_MINIMIZE));
        }
    }

    protected void ensureType(String string, Class<?> clazz) {
        CStationPerspective cStationPerspective = this.perspective.getStation(string);
        if (cStationPerspective != null && cStationPerspective.getClass() != clazz) {
            throw new IllegalStateException("present root station '" + string + "' is of type '" + cStationPerspective.getClass() + "' but should be of type '" + clazz + "'");
        }
    }

    public String getId() {
        return this.id;
    }

    public CPerspective getPerspective() {
        return this.perspective;
    }

    public CGridPerspective getCenter() {
        return (CGridPerspective)this.perspective.getStation(CContentArea.getCenterIdentifier(this.id));
    }

    public CMinimizePerspective getNorth() {
        return (CMinimizePerspective)this.perspective.getStation(CContentArea.getNorthIdentifier(this.id));
    }

    public CMinimizePerspective getSouth() {
        return (CMinimizePerspective)this.perspective.getStation(CContentArea.getSouthIdentifier(this.id));
    }

    public CMinimizePerspective getEast() {
        return (CMinimizePerspective)this.perspective.getStation(CContentArea.getEastIdentifier(this.id));
    }

    public CMinimizePerspective getWest() {
        return (CMinimizePerspective)this.perspective.getStation(CContentArea.getWestIdentifier(this.id));
    }
}

