/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CSplitDockStation;
import bibliothek.gui.dock.common.location.CMaximizedLocation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CNormalModeArea;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.util.CDockUtilities;
import bibliothek.gui.dock.control.relocator.DockRelocatorEvent;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorAdapter;
import bibliothek.gui.dock.control.relocator.VetoableDockRelocatorListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.ModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.DockableSplitDockTree;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CSplitDockStationHandle {
    private CStation<CSplitDockStation> station;
    private Normal normal = new Normal();
    private Maximal maximal = new Maximal();
    private LocationMode normalMode;
    private MaximizedMode<?> maximizedMode;
    private CLocationModeManager manager;
    private List<ModeAreaListenerWrapper> listeners = new ArrayList<ModeAreaListenerWrapper>();
    private SplitDockListener fullScreenListener = new SplitDockListener(){

        @Override
        public void fullScreenDockableChanged(SplitDockStation splitDockStation, Dockable dockable, Dockable dockable2) {
            ModeAreaListenerWrapper[] modeAreaListenerWrapperArray;
            HashSet<Dockable> hashSet = new HashSet<Dockable>();
            if (dockable != null) {
                hashSet.add(dockable);
            }
            if (dockable2 != null) {
                hashSet.add(dockable2);
            }
            ModeAreaListenerWrapper[] modeAreaListenerWrapperArray2 = modeAreaListenerWrapperArray = CSplitDockStationHandle.this.listeners.toArray(new ModeAreaListenerWrapper[CSplitDockStationHandle.this.listeners.size()]);
            int n = modeAreaListenerWrapperArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModeAreaListenerWrapper modeAreaListenerWrapper = modeAreaListenerWrapperArray2[n2];
                modeAreaListenerWrapper.fire(hashSet);
                ++n2;
            }
        }
    };
    private VetoableDockRelocatorListener relocatorListener = new VetoableDockRelocatorAdapter(){

        @Override
        public void dropped(DockRelocatorEvent dockRelocatorEvent) {
            MaximizedModeArea maximizedModeArea;
            if (!dockRelocatorEvent.isMove() && (maximizedModeArea = CSplitDockStationHandle.this.maximizedMode.getNextMaximizeArea(dockRelocatorEvent.getTarget())) == CSplitDockStationHandle.this.maximal) {
                CSplitDockStationHandle.this.manager.runTransaction(new AffectingRunnable(){

                    @Override
                    public void run(AffectedSet affectedSet) {
                        CSplitDockStationHandle.this.maximizedMode.unmaximize(CSplitDockStationHandle.this.getStation(), affectedSet);
                    }
                });
            }
        }
    };

    public CSplitDockStationHandle(CStation<CSplitDockStation> cStation, CLocationModeManager cLocationModeManager) {
        this.station = cStation;
        this.manager = cLocationModeManager;
    }

    protected void add(ModeAreaListenerWrapper modeAreaListenerWrapper) {
        if (modeAreaListenerWrapper == null) {
            throw new IllegalArgumentException("listener must not be empty");
        }
        if (this.listeners.isEmpty()) {
            this.station.getStation().addSplitDockStationListener(this.fullScreenListener);
        }
        this.listeners.add(modeAreaListenerWrapper);
    }

    protected void remove(ModeAreaListenerWrapper modeAreaListenerWrapper) {
        this.listeners.remove(modeAreaListenerWrapper);
        if (this.listeners.isEmpty()) {
            this.station.getStation().removeSplitDockStationListener(this.fullScreenListener);
        }
    }

    public SplitDockStation getStation() {
        return this.station.getStation();
    }

    public CStation<CSplitDockStation> getCStation() {
        return this.station;
    }

    public CNormalModeArea asNormalModeArea() {
        return this.normal;
    }

    public CMaximizedModeArea asMaximziedModeArea() {
        return this.maximal;
    }

    protected LocationMode getNormalMode() {
        return this.normalMode;
    }

    private Path normalModeIdentifier() {
        return this.normalExtendedMode().getModeIdentifier();
    }

    private ExtendedMode normalExtendedMode() {
        return this.getNormalMode().getExtendedMode();
    }

    public void dropAside(Dockable dockable) {
        if (dockable.getDockParent() == this.station.getStation()) {
            throw new IllegalStateException("dockable already a child");
        }
        DockableSplitDockTree dockableSplitDockTree = this.getStation().createTree();
        if (dockableSplitDockTree.getRoot() == null) {
            dockableSplitDockTree.root(dockable);
        } else {
            dockableSplitDockTree.root(dockableSplitDockTree.horizontal(dockableSplitDockTree.put(dockable), dockableSplitDockTree.unroot()));
        }
        this.getStation().dropTree(dockableSplitDockTree, false);
    }

    protected class Maximal
    implements CMaximizedModeArea {
        private DockController controller;

        protected Maximal() {
        }

        @Override
        public void addModeAreaListener(ModeAreaListener modeAreaListener) {
            CSplitDockStationHandle.this.add(new ModeAreaListenerWrapper(this, modeAreaListener));
        }

        @Override
        public void removeModeAreaListener(ModeAreaListener modeAreaListener) {
            CSplitDockStationHandle.this.remove(new ModeAreaListenerWrapper(this, modeAreaListener));
        }

        @Override
        public void setMode(LocationMode locationMode) {
            if (CSplitDockStationHandle.this.maximizedMode != null && locationMode != null) {
                throw new IllegalStateException("handle already in use");
            }
            CSplitDockStationHandle.this.maximizedMode = (MaximizedMode)locationMode;
        }

        @Override
        public void setController(DockController dockController) {
            if (this.controller != null) {
                this.controller.getRelocator().removeVetoableDockRelocatorListener(CSplitDockStationHandle.this.relocatorListener);
            }
            this.controller = dockController;
            if (dockController != null) {
                dockController.getRelocator().addVetoableDockRelocatorListener(CSplitDockStationHandle.this.relocatorListener);
            }
        }

        @Override
        public DockableProperty getLocation(Dockable dockable) {
            DockableProperty dockableProperty = DockUtilities.getPropertyChain(this.getStation(), dockable);
            SplitDockFullScreenProperty splitDockFullScreenProperty = new SplitDockFullScreenProperty();
            splitDockFullScreenProperty.setSuccessor(dockableProperty.getSuccessor());
            return splitDockFullScreenProperty;
        }

        @Override
        public boolean autoDefaultArea() {
            return true;
        }

        @Override
        public boolean isLocationRoot() {
            return true;
        }

        @Override
        public LocationMode getUnmaximizedMode() {
            return CSplitDockStationHandle.this.getNormalMode();
        }

        public void prepareApply(Dockable dockable, AffectedSet affectedSet) {
            CLocationMode cLocationMode = (CLocationMode)CSplitDockStationHandle.this.manager.getMode(CSplitDockStationHandle.this.normalModeIdentifier());
            if (cLocationMode != null) {
                CSplitDockStationHandle.this.manager.apply(dockable, cLocationMode, affectedSet, false);
            }
        }

        @Override
        public void prepareApply(Dockable dockable, Location location, AffectedSet affectedSet) {
            CGroupMovement cGroupMovement;
            CLocationMode cLocationMode;
            boolean bl;
            boolean bl2 = bl = location != null && location.getLocation() instanceof SplitDockFullScreenProperty;
            if (!bl && CSplitDockStationHandle.this.manager.getMode(dockable) != CSplitDockStationHandle.this.normalExtendedMode() && (cLocationMode = (CLocationMode)CSplitDockStationHandle.this.manager.getMode(CSplitDockStationHandle.this.normalModeIdentifier())) != null && (cGroupMovement = CSplitDockStationHandle.this.maximizedMode.getManager().getGroupBehavior().prepare(CSplitDockStationHandle.this.manager, dockable, cLocationMode.getExtendedMode())) != null) {
                CSplitDockStationHandle.this.manager.apply(dockable, cLocationMode.getExtendedMode(), cGroupMovement);
            }
        }

        @Override
        public Runnable onApply(LocationModeEvent locationModeEvent) {
            Object object;
            DockableProperty dockableProperty;
            if (locationModeEvent.isDone()) {
                return null;
            }
            Location location = locationModeEvent.getLocation();
            Dockable dockable = locationModeEvent.getDockable();
            DockableProperty dockableProperty2 = dockableProperty = location == null ? null : location.getLocation();
            if (locationModeEvent.getMode().getUniqueIdentifier().equals(CSplitDockStationHandle.this.normalModeIdentifier()) && dockableProperty != null && dockableProperty.getSuccessor() == null) {
                Object object2;
                object = (CLocationMode)CSplitDockStationHandle.this.manager.getCurrentMode(dockable);
                Object object3 = (CLocationMode)CSplitDockStationHandle.this.manager.getPreviousMode(dockable);
                if (object != null && object3 != null && CSplitDockStationHandle.this.normalModeIdentifier().equals(object3.getUniqueIdentifier()) && MaximizedMode.IDENTIFIER.equals(object.getUniqueIdentifier()) && (object2 = (MaximizedModeArea)CSplitDockStationHandle.this.maximizedMode.get(location.getRoot())) == this) {
                    object2.setMaximized(dockable, false, null, locationModeEvent.getAffected());
                    locationModeEvent.done(true);
                    return null;
                }
            }
            if (location != null && this.getMaximized() != null) {
                object = CSplitDockStationHandle.this.manager.getRepresentations(location.getRoot());
                for (Object object3 : object.values()) {
                    if (!DockUtilities.isAncestor(this.getStation(), (DockElement)object3)) continue;
                    CSplitDockStationHandle.this.maximizedMode.unmaximize(this, locationModeEvent.getAffected());
                    break;
                }
            }
            if (CSplitDockStationHandle.this.maximizedMode != null && locationModeEvent.getMode().getUniqueIdentifier().equals(CSplitDockStationHandle.this.normalModeIdentifier()) && (object = CSplitDockStationHandle.this.maximizedMode.getMaximizeArea(dockable)) == this) {
                CSplitDockStationHandle.this.maximizedMode.unmaximize(dockable, locationModeEvent.getAffected());
            }
            return null;
        }

        @Override
        public Runnable onApply(final LocationModeEvent locationModeEvent, final Dockable dockable) {
            if (locationModeEvent.isDone()) {
                return null;
            }
            if (!locationModeEvent.getMode().getUniqueIdentifier().equals(CSplitDockStationHandle.this.normalModeIdentifier())) {
                CSplitDockStationHandle.this.maximizedMode.unmaximize(this.getStation().getFullScreen(), locationModeEvent.getAffected());
                return new Runnable(){

                    @Override
                    public void run() {
                        if (dockable != null && dockable.getDockParent() != null) {
                            CSplitDockStationHandle.this.maximizedMode.maximize(Maximal.this, dockable, locationModeEvent.getAffected());
                        }
                    }
                };
            }
            return null;
        }

        @Override
        public String getUniqueId() {
            return CSplitDockStationHandle.this.station.getUniqueId();
        }

        @Override
        public boolean isChild(Dockable dockable) {
            return this.getStation().getFullScreen() == dockable;
        }

        @Override
        public SplitDockStation getStation() {
            return (SplitDockStation)CSplitDockStationHandle.this.station.getStation();
        }

        @Override
        public boolean respectWorkingAreas() {
            return false;
        }

        @Override
        public Dockable[] getMaximized() {
            Dockable dockable = this.getStation().getFullScreen();
            if (dockable == null) {
                return null;
            }
            return new Dockable[]{dockable};
        }

        @Override
        public void setMaximized(Dockable dockable, boolean bl, Location location, AffectedSet affectedSet) {
            SplitDockStation splitDockStation = this.getStation();
            if (!bl) {
                if (splitDockStation.getFullScreen() != null && DockUtilities.isAncestor(splitDockStation.getFullScreen(), dockable)) {
                    splitDockStation.setFullScreen(null);
                }
            } else {
                DockableProperty dockableProperty;
                DockableProperty dockableProperty2 = dockableProperty = location == null ? null : location.getLocation();
                if (dockableProperty instanceof SplitDockFullScreenProperty && this.getMaximized() != null && this.getStation().drop(dockable, dockableProperty)) {
                    return;
                }
                if (dockable.getDockParent() == splitDockStation) {
                    splitDockStation.setFullScreen(dockable);
                } else {
                    if (dockable.getDockParent() != null) {
                        dockable.getDockParent().drag(dockable);
                    }
                    CSplitDockStationHandle.this.dropAside(dockable);
                    splitDockStation.setFullScreen(dockable);
                }
            }
            affectedSet.add(dockable);
        }

        @Override
        public boolean isRepresenting(DockStation dockStation) {
            return dockStation == CSplitDockStationHandle.this.station.getStation();
        }

        @Override
        public CLocation getCLocation(Dockable dockable) {
            DockableProperty dockableProperty = DockUtilities.getPropertyChain(this.getStation(), dockable);
            return this.getCLocation(dockableProperty);
        }

        @Override
        public CLocation getCLocation(Dockable dockable, Location location) {
            DockableProperty dockableProperty = location.getLocation();
            return this.getCLocation(dockableProperty);
        }

        private CLocation getCLocation(DockableProperty dockableProperty) {
            CLocation cLocation = CSplitDockStationHandle.this.station.getStationLocation();
            CMaximizedLocation cMaximizedLocation = new CMaximizedLocation(cLocation.findRoot());
            if (dockableProperty != null) {
                dockableProperty = dockableProperty.getSuccessor();
            }
            if (dockableProperty != null) {
                return cMaximizedLocation.expandProperty(((CSplitDockStation)CSplitDockStationHandle.this.station.getStation()).getController(), dockableProperty);
            }
            return cMaximizedLocation;
        }
    }

    protected static class ModeAreaListenerWrapper {
        private ModeAreaListener listener;
        private ModeArea area;

        public ModeAreaListenerWrapper(ModeArea modeArea, ModeAreaListener modeAreaListener) {
            this.area = modeArea;
            this.listener = modeAreaListener;
        }

        public void fire(Set<Dockable> set) {
            this.listener.internalLocationChange(this.area, set);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ModeAreaListenerWrapper) {
                ModeAreaListenerWrapper modeAreaListenerWrapper = (ModeAreaListenerWrapper)object;
                return modeAreaListenerWrapper.area.equals(this.area) && modeAreaListenerWrapper.listener.equals(this.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.area.hashCode() ^ this.listener.hashCode();
        }
    }

    protected class Normal
    implements CNormalModeArea {
        protected Normal() {
        }

        @Override
        public void setMode(LocationMode locationMode) {
            CSplitDockStationHandle.this.normalMode = locationMode;
        }

        @Override
        public void addModeAreaListener(ModeAreaListener modeAreaListener) {
            CSplitDockStationHandle.this.add(new ModeAreaListenerWrapper(this, modeAreaListener));
        }

        @Override
        public void removeModeAreaListener(ModeAreaListener modeAreaListener) {
            CSplitDockStationHandle.this.remove(new ModeAreaListenerWrapper(this, modeAreaListener));
        }

        @Override
        public boolean autoDefaultArea() {
            return true;
        }

        @Override
        public boolean isLocationRoot() {
            return true;
        }

        @Override
        public void setController(DockController dockController) {
        }

        @Override
        public boolean isNormalModeChild(Dockable dockable) {
            if (!this.isChild(dockable)) {
                return false;
            }
            if (this.getStation().getFullScreen() == dockable) {
                return false;
            }
            return this.isWorkingAreaValid(dockable);
        }

        private boolean isWorkingAreaValid(Dockable dockable) {
            if (dockable instanceof CommonDockable) {
                CStation<?> cStation = ((CommonDockable)dockable).getDockable().getWorkingArea();
                if (cStation == null) {
                    return CDockUtilities.getFirstWorkingArea(CSplitDockStationHandle.this.station) == null;
                }
                return CDockUtilities.getFirstWorkingArea(CSplitDockStationHandle.this.station) == cStation;
            }
            return true;
        }

        @Override
        public DockableProperty getLocation(Dockable dockable) {
            return DockUtilities.getPropertyChain(this.getStation(), dockable);
        }

        @Override
        public String getUniqueId() {
            return CSplitDockStationHandle.this.station.getUniqueId();
        }

        @Override
        public boolean isChild(Dockable dockable) {
            return dockable.getDockParent() == this.getStation() && !CSplitDockStationHandle.this.maximal.isChild(dockable);
        }

        @Override
        public SplitDockStation getStation() {
            return (SplitDockStation)CSplitDockStationHandle.this.station.getStation();
        }

        @Override
        public boolean respectWorkingAreas() {
            return true;
        }

        @Override
        public boolean setLocation(Dockable dockable, DockableProperty dockableProperty, AffectedSet affectedSet) {
            affectedSet.add(dockable);
            if (dockable.getDockParent() == CSplitDockStationHandle.this.station.getStation()) {
                if (dockableProperty != null) {
                    this.cleanFullscreen(affectedSet);
                    this.getStation().move(dockable, dockableProperty);
                    return true;
                }
            } else {
                boolean bl = DockUtilities.acceptable(this.getStation(), dockable);
                if (bl) {
                    if (dockable.getDockParent() != null) {
                        dockable.getDockParent().drag(dockable);
                    }
                    this.cleanFullscreen(affectedSet);
                    if (dockableProperty != null && !this.getStation().drop(dockable, dockableProperty)) {
                        dockableProperty = null;
                    }
                    if (dockableProperty == null && !DockUtilities.isAncestor(CSplitDockStationHandle.this.station.getStation(), dockable)) {
                        this.getStation().drop(dockable);
                    }
                    return true;
                }
            }
            return false;
        }

        private void cleanFullscreen(AffectedSet affectedSet) {
            Dockable dockable = this.getStation().getFullScreen();
            if (dockable != null) {
                CSplitDockStationHandle.this.maximal.setMaximized(dockable, false, null, affectedSet);
            }
        }

        @Override
        public CLocation getCLocation(Dockable dockable) {
            DockableProperty dockableProperty = DockUtilities.getPropertyChain(this.getStation(), dockable);
            return CSplitDockStationHandle.this.station.getStationLocation().expandProperty(((CSplitDockStation)CSplitDockStationHandle.this.station.getStation()).getController(), dockableProperty);
        }

        @Override
        public CLocation getCLocation(Dockable dockable, Location location) {
            DockableProperty dockableProperty = location.getLocation();
            if (dockableProperty == null) {
                return CSplitDockStationHandle.this.station.getStationLocation();
            }
            return CSplitDockStationHandle.this.station.getStationLocation().expandProperty(((CSplitDockStation)CSplitDockStationHandle.this.station.getStation()).getController(), dockableProperty);
        }

        @Override
        public CLocation getBaseLocation() {
            return CSplitDockStationHandle.this.station.getStationLocation();
        }

        @Override
        public boolean isWorkingArea() {
            return CSplitDockStationHandle.this.station.isWorkingArea();
        }
    }
}

