/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.facile.action.KeyedActionSource;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.support.mode.Mode;
import java.util.LinkedList;
import java.util.List;

public class KeyedLocationModeActionProvider
extends DefaultLocationModeActionProvider {
    private String key;
    private List<KeyedActionSource> sources = new LinkedList<KeyedActionSource>();

    public KeyedLocationModeActionProvider(String string) {
        if (string == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.key = string;
    }

    public KeyedLocationModeActionProvider(String string, CAction cAction) {
        this(string);
        this.setSelectModeAction(cAction);
    }

    public KeyedLocationModeActionProvider(String string, DockAction dockAction) {
        this(string);
        this.setSelectModeAction(dockAction);
    }

    @Override
    public void setSelectModeAction(DockAction dockAction) {
        super.setSelectModeAction(dockAction);
        for (KeyedActionSource keyedActionSource : this.sources) {
            keyedActionSource.setDefaultAction(dockAction);
        }
    }

    @Override
    public DockActionSource getActions(Dockable dockable, Mode<Location> mode, DockActionSource dockActionSource) {
        if (dockActionSource instanceof KeyedActionSource && ((KeyedActionSource)dockActionSource).getKey().equals(this.key)) {
            return dockActionSource;
        }
        if (dockable instanceof CommonDockable) {
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            KeyedActionSource keyedActionSource = new KeyedActionSource(cDockable, this.key);
            this.sources.add(keyedActionSource);
            keyedActionSource.setDefaultAction(this.getSelectModeAction());
            keyedActionSource.setVisible(true);
            return keyedActionSource;
        }
        return super.getActions(dockable, mode, dockActionSource);
    }

    @Override
    public void destroy(Dockable dockable, DockActionSource dockActionSource) {
        if (this.sources.remove(dockActionSource)) {
            ((KeyedActionSource)dockActionSource).destroy();
        }
    }
}

