/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.util.CDockUtilities;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.support.mode.HistoryRewriter;
import java.util.List;

public class CStationContainerHistoryRewriter
implements HistoryRewriter<Location, CLocationMode> {
    private CControl control;

    public CStationContainerHistoryRewriter(CControl cControl) {
        this.control = cControl;
    }

    public CControl getControl() {
        return this.control;
    }

    protected CStation<?> getMatchingStation(Dockable dockable, String string) {
        CStation<?> cStation = this.control.getStation(string);
        if (cStation == null) {
            return null;
        }
        CStationContainer cStationContainer = this.getContainer(cStation);
        if (cStationContainer == null) {
            return cStation;
        }
        CStation<?> cStation2 = this.getParent(dockable);
        CStationContainer cStationContainer2 = this.getContainer(cStation2);
        if (cStationContainer2 != null) {
            if (cStationContainer == cStationContainer2) {
                return cStation;
            }
            return cStationContainer2.getMatchingStation(cStationContainer, cStation);
        }
        List list = this.control.getLocationManager().getPropertyHistory(dockable);
        int n = list.size() - 1;
        while (n >= 0) {
            CStation<?> cStation3;
            String string2 = ((Location)list.get(n)).getRoot();
            CStation<?> cStation4 = this.control.getStation(string2);
            if (cStation4 != null && (cStationContainer2 = this.getContainer(cStation4)) != null && (cStation3 = cStationContainer2.getMatchingStation(cStationContainer, cStation)) != null) {
                return cStation3;
            }
            --n;
        }
        return null;
    }

    protected CStation<?> getMatchingStation(Dockable dockable, ExtendedMode extendedMode) {
        CStation<?> cStation = this.getParent(dockable);
        CStation<?> cStation2 = this.getWorkingArea(dockable);
        if (cStation != null && cStation2 != null && !this.isValidParent(cStation, cStation2)) {
            return cStation2;
        }
        CStationContainer cStationContainer = this.getContainer(cStation);
        if (cStationContainer != null) {
            return cStationContainer.getDefaultStation(extendedMode);
        }
        List list = this.control.getLocationManager().getPropertyHistory(dockable);
        int n = list.size() - 1;
        while (n >= 0) {
            CStation<?> cStation3;
            String string = ((Location)list.get(n)).getRoot();
            CStation<?> cStation4 = this.control.getStation(string);
            if (cStation4 != null && (cStationContainer = this.getContainer(cStation4)) != null && (cStation3 = cStationContainer.getDefaultStation(extendedMode)) != null && this.isValidParent(cStation3, cStation2)) {
                return cStation3;
            }
            --n;
        }
        return null;
    }

    private boolean isValidParent(CStation<?> cStation, CStation<?> cStation2) {
        return cStation != null && CDockUtilities.getFirstWorkingArea(cStation) == cStation2;
    }

    protected CStation<?> getWorkingArea(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable().getWorkingArea();
        }
        return null;
    }

    protected CStation<?> getParent(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            if (dockStation instanceof CommonDockStation) {
                return ((CommonDockStation)dockStation).getStation();
            }
            dockStation = dockStation.asDockable() == null ? null : dockStation.asDockable().getDockParent();
        }
        return null;
    }

    protected CStationContainer getContainer(CStation<?> cStation) {
        if (cStation == null) {
            return null;
        }
        Object object = cStation.getStation();
        while (object != null) {
            Object object2;
            if (object instanceof CommonDockStation) {
                object2 = ((CommonDockStation)object).getStation();
                CStationContainer cStationContainer = this.control.getRegister().getContainer((CStation<?>)object2);
                if (cStationContainer != null) {
                    return cStationContainer;
                }
            }
            if ((object2 = object.asDockable()) == null) {
                return null;
            }
            object = object2.getDockParent();
            if (object != null) continue;
            return null;
        }
        return null;
    }

    @Override
    public Location rewrite(Dockable dockable, CLocationMode cLocationMode, Location location) {
        CStation<?> cStation = null;
        if (location != null) {
            cStation = this.getMatchingStation(dockable, location.getRoot());
        }
        if (cStation == null) {
            cStation = this.getMatchingStation(dockable, cLocationMode.getExtendedMode());
        }
        if (cStation == null) {
            return location;
        }
        if (location == null) {
            return new Location(cLocationMode.getUniqueIdentifier(), cStation.getUniqueId(), null, false);
        }
        return new Location(cLocationMode.getUniqueIdentifier(), cStation.getUniqueId(), location.getLocation(), location.isApplicationDefined());
    }
}

