/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.action.predefined.CNormalizeAction;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CModeArea;
import bibliothek.gui.dock.common.mode.CNormalModeArea;
import bibliothek.gui.dock.common.mode.KeyedLocationModeActionProvider;
import bibliothek.gui.dock.common.perspective.mode.CNormalModePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.MappingLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.support.mode.Mode;

public class CNormalMode
extends NormalMode<CNormalModeArea>
implements CLocationMode {
    private LocationModeActionProvider normalize;

    public CNormalMode(CControl cControl) {
        this.normalize = new KeyedLocationModeActionProvider("cdockable.normalize", new CNormalizeAction(cControl));
        this.setActionProvider(new MappingLocationModeActionProvider(){

            @Override
            protected LocationModeActionProvider getProvider(Dockable dockable, Mode<Location> mode, DockActionSource dockActionSource) {
                return CNormalMode.this.normalize;
            }
        });
    }

    @Override
    public CLocation getCLocation(Dockable dockable) {
        CNormalModeArea cNormalModeArea = (CNormalModeArea)this.get(dockable);
        if (cNormalModeArea == null) {
            return null;
        }
        return cNormalModeArea.getCLocation(dockable);
    }

    @Override
    public CLocation getCLocation(Dockable dockable, Location location) {
        CModeArea cModeArea = (CModeArea)this.get(location.getRoot());
        if (cModeArea == null) {
            return null;
        }
        return cModeArea.getCLocation(dockable, location);
    }

    @Override
    public boolean isBasicMode() {
        return true;
    }

    public CLocation getDefaultLocation() {
        CNormalModeArea cNormalModeArea = (CNormalModeArea)this.getDefaultArea();
        if (cNormalModeArea == null || cNormalModeArea.isWorkingArea()) {
            for (CNormalModeArea cNormalModeArea2 : this) {
                if (cNormalModeArea2.isWorkingArea()) continue;
                cNormalModeArea = cNormalModeArea2;
                break;
            }
        }
        if (cNormalModeArea == null) {
            return null;
        }
        return cNormalModeArea.getBaseLocation();
    }

    @Override
    public boolean respectWorkingAreas(DockStation dockStation) {
        CModeArea cModeArea = (CModeArea)this.get(dockStation);
        if (cModeArea == null) {
            return true;
        }
        return cModeArea.respectWorkingAreas();
    }

    @Override
    public LocationModePerspective createPerspective() {
        return new CNormalModePerspective();
    }
}

