/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.action.predefined.CMaximizeAction;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CModeArea;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.mode.KeyedLocationModeActionProvider;
import bibliothek.gui.dock.common.perspective.mode.CMaximizedModePerspective;
import bibliothek.gui.dock.common.perspective.mode.LocationModePerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;

public class CMaximizedMode
extends MaximizedMode<CMaximizedModeArea>
implements CLocationMode {
    private CControl control;

    public CMaximizedMode(CControl cControl) {
        this.control = cControl;
        this.setActionProvider(new KeyedLocationModeActionProvider("cdockable.maximize", new CMaximizeAction(cControl)));
    }

    @Override
    public CLocation getCLocation(Dockable dockable) {
        CMaximizedModeArea cMaximizedModeArea = (CMaximizedModeArea)this.get(dockable);
        if (cMaximizedModeArea == null) {
            return null;
        }
        return cMaximizedModeArea.getCLocation(dockable);
    }

    @Override
    public CLocation getCLocation(Dockable dockable, Location location) {
        CModeArea cModeArea = (CModeArea)this.get(location.getRoot());
        if (cModeArea == null) {
            return null;
        }
        return cModeArea.getCLocation(dockable, location);
    }

    @Override
    public boolean isBasicMode() {
        return false;
    }

    @Override
    public boolean respectWorkingAreas(DockStation dockStation) {
        CModeArea cModeArea = (CModeArea)this.get(dockStation);
        if (cModeArea == null) {
            return true;
        }
        return cModeArea.respectWorkingAreas();
    }

    @Override
    public LocationModePerspective createPerspective() {
        return new CMaximizedModePerspective();
    }

    @Override
    public MaximizedModeArea getMaximizeArea(Dockable dockable, Location location) {
        MaximizedModeArea maximizedModeArea = super.getMaximizeArea(dockable, location);
        if (maximizedModeArea == null) {
            DockStation dockStation = dockable.getDockParent();
            while (dockStation != null) {
                CStation<?> cStation;
                Object object;
                CStation<?> cStation2 = this.control.getStation(dockStation);
                if (cStation2 != null && (object = this.control.getRegister().getContainer(cStation2)) != null && (cStation = object.getDefaultStation(ExtendedMode.MAXIMIZED)) != null) {
                    return this.getMaximizeArea((DockStation)cStation.getStation());
                }
                object = dockStation.asDockable();
                dockStation = object == null ? null : object.getDockParent();
            }
        }
        return maximizedModeArea;
    }
}

