/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockFrontendListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CMinimizedMode;
import bibliothek.gui.dock.common.mode.CNormalMode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.mode.PreviousModeDoubleClickStrategy;
import bibliothek.gui.dock.facile.mode.CLocationModeSettings;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.gui.dock.support.mode.UndoableModeSettings;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import bibliothek.util.container.Single;
import java.util.HashMap;
import java.util.List;

public class CLocationModeManager
extends LocationModeManager<CLocationMode> {
    public static final String ICON_MANAGER_KEY_MINIMIZE = "locationmanager.minimize";
    public static final String ICON_MANAGER_KEY_MAXIMIZE = "locationmanager.maximize";
    public static final String ICON_MANAGER_KEY_NORMALIZE = "locationmanager.normalize";
    public static final String ICON_MANAGER_KEY_EXTERNALIZE = "locationmanager.externalize";
    public static final String ICON_MANAGER_KEY_UNEXTERNALIZE = "locationmanager.unexternalize";
    public static final String ICON_MANAGER_KEY_UNMAXIMIZE_EXTERNALIZED = "locationmanager.unmaximize_externalized";
    private CControlAccess control;
    private CNormalMode normalMode;
    private CMaximizedMode maximizedMode;
    private CMinimizedMode minimizedMode;

    public CLocationModeManager(CControlAccess cControlAccess) {
        super(cControlAccess.getOwner().intern().getController());
        this.control = cControlAccess;
        this.setDoubleClickStrategy(new PreviousModeDoubleClickStrategy(this));
        this.minimizedMode = new CMinimizedMode(cControlAccess.getOwner());
        this.maximizedMode = new CMaximizedMode(cControlAccess.getOwner());
        this.normalMode = new CNormalMode(cControlAccess.getOwner());
        this.putMode(this.minimizedMode);
        this.putMode(this.normalMode);
        this.putMode(this.maximizedMode);
        this.addModeManagerListener(new ModeManagerListener<Location, LocationMode>(){

            @Override
            public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
            }

            @Override
            public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
            }

            @Override
            public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            }

            @Override
            public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable, LocationMode locationMode, LocationMode locationMode2) {
                CDockableAccess cDockableAccess = CLocationModeManager.this.control.access(((CommonDockable)dockable).getDockable());
                if (cDockableAccess != null) {
                    ExtendedMode extendedMode = CLocationModeManager.this.getMode(dockable);
                    cDockableAccess.informMode(extendedMode);
                }
            }

            @Override
            public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            }
        });
    }

    public CNormalMode getNormalMode() {
        return this.normalMode;
    }

    public CMaximizedMode getMaximizedMode() {
        return this.maximizedMode;
    }

    public CMinimizedMode getMinimizedMode() {
        return this.minimizedMode;
    }

    @Override
    public <B> ModeSettings<Location, B> createModeSettings(ModeSettingsConverter<Location, B> modeSettingsConverter) {
        return new CLocationModeSettings<B>(modeSettingsConverter);
    }

    @Override
    public void readSettings(ModeSettings<Location, ?> modeSettings) {
        UndoableModeSettings undoableModeSettings = new UndoableModeSettings(){

            @Override
            public boolean createTemporaryDuringRead(String string) {
                return CLocationModeManager.this.control.getRegister().isMultiId(string);
            }
        };
        final Runnable runnable = this.readSettings(modeSettings, undoableModeSettings);
        this.control.getOwner().intern().addListener(new CDockFrontendListener(){

            @Override
            public void loading(CDockFrontend cDockFrontend, CSetting cSetting) {
            }

            @Override
            public void loaded(CDockFrontend cDockFrontend, CSetting cSetting) {
                runnable.run();
                cDockFrontend.removeListener(this);
            }
        });
    }

    @Override
    public Runnable readSettings(ModeSettings<Location, ?> modeSettings, UndoableModeSettings undoableModeSettings) {
        Runnable runnable = super.readSettings(modeSettings, undoableModeSettings);
        if (modeSettings instanceof CLocationModeSettings) {
            CLocationModeSettings cLocationModeSettings = (CLocationModeSettings)modeSettings;
            cLocationModeSettings.rescue(this.getMaximizedMode());
        }
        return runnable;
    }

    public void setLocation(Dockable dockable, CLocation cLocation) {
        ExtendedMode extendedMode = cLocation.findMode();
        if (extendedMode == null) {
            return;
        }
        CLocationMode cLocationMode = (CLocationMode)this.getMode(extendedMode.getModeIdentifier());
        if (cLocationMode == null) {
            return;
        }
        String string = cLocation.findRoot();
        if (string != null) {
            CStation<?> cStation;
            if (dockable instanceof CommonDockable && (cStation = this.control.getOwner().getStation(string)) != null && cLocationMode.respectWorkingAreas((DockStation)cStation.getStation())) {
                if (cStation.isWorkingArea()) {
                    ((CommonDockable)dockable).getDockable().setWorkingArea(cStation);
                } else {
                    ((CommonDockable)dockable).getDockable().setWorkingArea(null);
                }
            }
            this.setProperties(cLocationMode, dockable, new Location(extendedMode.getModeIdentifier(), string, cLocation.findProperty(), true));
            this.apply(dockable, cLocationMode, true);
        } else {
            this.apply(dockable, cLocationMode, false);
        }
    }

    public void setLocation(Dockable dockable, ExtendedMode extendedMode, CLocation cLocation) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (extendedMode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        if (cLocation != null) {
            String string = cLocation.findRoot();
            if (string == null) {
                throw new IllegalArgumentException("the location is not sufficient to find the root station");
            }
            DockableProperty dockableProperty = cLocation.findProperty();
            if (dockableProperty == null) {
                throw new IllegalArgumentException("the location does not carry enough information to find the location of dockable");
            }
            ExtendedMode extendedMode2 = cLocation.findMode();
            if (extendedMode2 == null) {
                throw new IllegalArgumentException("the location does not carry enough information to find the mode of dockable");
            }
            if (!extendedMode.getModeIdentifier().equals(extendedMode2.getModeIdentifier())) {
                throw new IllegalArgumentException("location and mode do not belong together, they do not have the same identifier");
            }
            this.setProperties((CLocationMode)this.getMode(extendedMode.getModeIdentifier()), dockable, new Location(extendedMode.getModeIdentifier(), string, dockableProperty, true));
        } else {
            this.setProperties((CLocationMode)this.getMode(extendedMode.getModeIdentifier()), dockable, null);
        }
    }

    public CLocation getLocation(Dockable dockable) {
        CLocationMode cLocationMode = (CLocationMode)this.getCurrentMode(dockable);
        if (cLocationMode == null) {
            return null;
        }
        return cLocationMode.getCLocation(dockable);
    }

    public CLocation getLocation(Dockable dockable, ExtendedMode extendedMode) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (extendedMode == null) {
            throw new IllegalArgumentException("mode must not be null");
        }
        CLocationMode cLocationMode = (CLocationMode)this.getMode(extendedMode.getModeIdentifier());
        Location location = (Location)this.getProperties(cLocationMode, dockable);
        if (location == null) {
            return null;
        }
        return cLocationMode.getCLocation(dockable, location);
    }

    public CLocation getDropLocation(CStation<?> cStation) {
        Dockable[] dockableArray = this.control.getOwner().getController().getFocusHistory().getHistory();
        int n = dockableArray.length - 1;
        while (n >= 0) {
            Dockable dockable = dockableArray[n];
            if (dockable instanceof CommonDockable && dockable.asDockStation() != cStation.getStation()) {
                CLocation cLocation;
                CDockable cDockable = ((CommonDockable)dockable).getDockable();
                if (DockUtilities.isAncestor(cStation.getStation(), dockable)) {
                    CLocation cLocation2;
                    boolean bl;
                    if (cStation.isWorkingArea()) {
                        bl = cDockable.getWorkingArea() == cStation;
                    } else {
                        boolean bl2 = bl = cDockable.getWorkingArea() == null;
                    }
                    if (bl && (cLocation2 = cDockable.getBaseLocation()) != null) {
                        return cLocation2.aside();
                    }
                }
                if (cDockable.getWorkingArea() == cStation && (cLocation = cDockable.getBaseLocation()) != null) {
                    return cLocation.aside();
                }
            }
            --n;
        }
        return cStation.getStationLocation();
    }

    @Override
    public void ensureValidLocation(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            this.ensureValidLocation(((CommonDockable)dockable).getDockable());
        }
    }

    public void ensureValidLocation(CDockable cDockable) {
        if (this.isLayouting()) {
            return;
        }
        ExtendedMode extendedMode = this.getMode(cDockable.intern());
        if (extendedMode == ExtendedMode.NORMALIZED) {
            CStation<?> cStation;
            CStation<?> cStation2 = cDockable.getWorkingArea();
            if (cStation2 != (cStation = this.findFirstParentWorkingArea(cDockable.intern()))) {
                if (cStation2 == null) {
                    CLocation cLocation = this.getNormalMode().getDefaultLocation();
                    cDockable.setLocation(cLocation);
                } else {
                    cDockable.setLocation(cStation2.getStationLocation());
                }
            }
            extendedMode = this.getMode(cDockable.intern());
        }
        if (!this.isModeAvailable(cDockable.intern(), extendedMode)) {
            cDockable.setExtendedMode(ExtendedMode.NORMALIZED);
        }
    }

    public boolean ensureBasicModes() {
        if (this.isLayouting()) {
            return false;
        }
        final Single<Boolean> single = new Single<Boolean>(false);
        this.runTransaction(new AffectingRunnable(){

            @Override
            public void run(AffectedSet affectedSet) {
                for (Dockable dockable : CLocationModeManager.this.listDockables()) {
                    CLocationMode cLocationMode = (CLocationMode)CLocationModeManager.this.getCurrentMode(dockable);
                    if (cLocationMode == null || cLocationMode.isBasicMode()) continue;
                    List list = CLocationModeManager.this.getModeHistory(dockable);
                    CLocationMode cLocationMode2 = null;
                    int n = list.size() - 1;
                    while (n >= 0 && cLocationMode2 == null) {
                        CLocationMode cLocationMode3 = (CLocationMode)list.get(n);
                        if (cLocationMode3.isBasicMode() && CLocationModeManager.this.isModeAvailable(dockable, cLocationMode3.getExtendedMode())) {
                            cLocationMode2 = cLocationMode3;
                        }
                        --n;
                    }
                    if (cLocationMode2 == null) {
                        cLocationMode2 = CLocationModeManager.this.getNormalMode();
                    }
                    single.setA(true);
                    CLocationModeManager.this.setMode(dockable, cLocationMode2.getExtendedMode());
                }
            }
        });
        return single.getA();
    }

    public void resetWorkingAreaChildren() {
        this.runTransaction(new AffectingRunnable(){

            @Override
            public void run(AffectedSet affectedSet) {
                for (Dockable dockable : CLocationModeManager.this.listDockables()) {
                    if (!(dockable instanceof CommonDockable)) continue;
                    CDockable cDockable = ((CommonDockable)dockable).getDockable();
                    CLocationModeManager.this.resetWorkingArea(cDockable, affectedSet);
                }
            }
        });
    }

    private void resetWorkingArea(CDockable cDockable, AffectedSet affectedSet) {
        if (cDockable.getWorkingArea() == null) {
            return;
        }
        DockStation dockStation = cDockable.intern().getDockParent();
        if (dockStation == null) {
            return;
        }
        CLocationMode cLocationMode = (CLocationMode)this.getCurrentMode(cDockable.intern());
        if (cLocationMode == null) {
            return;
        }
        if (cLocationMode.respectWorkingAreas(dockStation)) {
            return;
        }
        List list = this.getPropertyHistory(cDockable.intern());
        CLocationMode cLocationMode2 = null;
        int n = list.size() - 1;
        while (n >= 0 && cLocationMode2 == null) {
            CStation<?> cStation;
            CLocationMode cLocationMode3;
            Location location = (Location)list.get(n);
            Path path = location.getMode();
            String string = location.getRoot();
            if (path != null && string != null && (cLocationMode3 = (CLocationMode)this.getMode(path)) != null && (cStation = this.control.getOwner().getStation(string)) != null && cLocationMode3.respectWorkingAreas((DockStation)cStation.getStation()) && cLocationMode3.isRepresenting((DockStation)cStation.getStation()) && this.isModeAvailable(cDockable.intern(), cLocationMode3.getExtendedMode())) {
                cLocationMode2 = cLocationMode3;
            }
            --n;
        }
        if (cLocationMode2 == null) {
            cLocationMode2 = this.getNormalMode();
        }
        this.apply((Dockable)cDockable.intern(), cLocationMode2, affectedSet, false);
    }

    public ExtendedMode childsExtendedMode(DockStation dockStation) {
        while (dockStation != null) {
            CLocationMode cLocationMode = this.getRepresentingMode(dockStation);
            if (cLocationMode != null) {
                return cLocationMode.getExtendedMode();
            }
            Dockable dockable = dockStation.asDockable();
            if (dockable == null) {
                return null;
            }
            dockStation = dockable.getDockParent();
        }
        return null;
    }

    private CStation<?> findFirstParentWorkingArea(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        Dockable dockable2 = dockable = dockStation == null ? null : dockStation.asDockable();
        if (dockable != null) {
            return this.getAreaOf(dockable);
        }
        return null;
    }

    protected CStation<?> getAreaOf(Dockable dockable) {
        CStation<?> cStation2;
        HashMap hashMap = new HashMap();
        for (CStation<?> cStation2 : this.control.getOwner().getStations()) {
            if (!cStation2.isWorkingArea()) continue;
            hashMap.put(cStation2.getStation(), cStation2);
        }
        if (dockable.asDockStation() != null && (cStation2 = (CStation)hashMap.get(dockable.asDockStation())) != null) {
            return cStation2;
        }
        cStation2 = dockable;
        while (cStation2 != null) {
            DockStation dockStation = cStation2.getDockParent();
            cStation2 = dockStation == null ? null : dockStation.asDockable();
            CStation cStation3 = (CStation)hashMap.get(dockStation);
            if (cStation3 == null) continue;
            return cStation3;
        }
        return null;
    }

    private CLocationMode getRepresentingMode(DockStation dockStation) {
        Iterable iterable = this.modes();
        CLocationMode cLocationMode = null;
        for (CLocationMode cLocationMode2 : iterable) {
            if (!cLocationMode2.isRepresenting(dockStation)) continue;
            if (cLocationMode2.isBasicMode()) {
                return cLocationMode2;
            }
            if (cLocationMode != null) continue;
            cLocationMode = cLocationMode2;
        }
        return cLocationMode;
    }
}

