/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractTreeLocation;
import bibliothek.gui.dock.common.location.CFlapIndexLocation;
import bibliothek.gui.dock.common.location.CFlapLocation;
import bibliothek.gui.dock.common.location.CLocationExpandStrategy;
import bibliothek.gui.dock.common.location.CRectangleLocation;
import bibliothek.gui.dock.common.location.CSplitLocation;
import bibliothek.gui.dock.common.location.CStackLocation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;
import bibliothek.gui.dock.station.stack.StackDockProperty;

public class DefaultExpandStrategy
implements CLocationExpandStrategy {
    public DefaultExpandStrategy(DockController dockController) {
    }

    @Override
    public CLocation expand(CLocation cLocation, DockableProperty dockableProperty) {
        if (dockableProperty instanceof FlapDockProperty) {
            return this.expand(cLocation, (FlapDockProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockFullScreenProperty) {
            return this.expand(cLocation, (SplitDockFullScreenProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockPathProperty) {
            return this.expand(cLocation, (SplitDockPathProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockPlaceholderProperty) {
            return this.expand(cLocation, (SplitDockPlaceholderProperty)dockableProperty);
        }
        if (dockableProperty instanceof SplitDockProperty) {
            return this.expand(cLocation, (SplitDockProperty)dockableProperty);
        }
        if (dockableProperty instanceof StackDockProperty) {
            return this.expand(cLocation, (StackDockProperty)dockableProperty);
        }
        return null;
    }

    protected CLocation expand(CLocation cLocation, FlapDockProperty flapDockProperty) {
        if (!(cLocation instanceof CFlapLocation)) {
            cLocation = new CFlapLocation(cLocation);
        }
        return new CFlapIndexLocation((CFlapLocation)cLocation, flapDockProperty.getIndex());
    }

    protected CLocation expand(CLocation cLocation, SplitDockFullScreenProperty splitDockFullScreenProperty) {
        return null;
    }

    protected CLocation expand(CLocation cLocation, SplitDockPathProperty splitDockPathProperty) {
        if (!(cLocation instanceof CSplitLocation)) {
            cLocation = new CSplitLocation(cLocation);
        }
        CSplitLocation cSplitLocation = (CSplitLocation)cLocation;
        if (splitDockPathProperty.size() > 0) {
            AbstractTreeLocation abstractTreeLocation = null;
            SplitDockPathProperty.Node node = splitDockPathProperty.getNode(0);
            switch (node.getLocation()) {
                case BOTTOM: {
                    abstractTreeLocation = cSplitLocation.south(node.getSize(), node.getId());
                    break;
                }
                case LEFT: {
                    abstractTreeLocation = cSplitLocation.west(node.getSize(), node.getId());
                    break;
                }
                case RIGHT: {
                    abstractTreeLocation = cSplitLocation.east(node.getSize(), node.getId());
                    break;
                }
                case TOP: {
                    abstractTreeLocation = cSplitLocation.north(node.getSize(), node.getId());
                }
            }
            int n = 1;
            int n2 = splitDockPathProperty.size();
            while (n < n2) {
                node = splitDockPathProperty.getNode(n);
                switch (node.getLocation()) {
                    case BOTTOM: {
                        abstractTreeLocation = abstractTreeLocation.south(node.getSize(), node.getId());
                        break;
                    }
                    case LEFT: {
                        abstractTreeLocation = abstractTreeLocation.west(node.getSize(), node.getId());
                        break;
                    }
                    case RIGHT: {
                        abstractTreeLocation = abstractTreeLocation.east(node.getSize(), node.getId());
                        break;
                    }
                    case TOP: {
                        abstractTreeLocation = abstractTreeLocation.north(node.getSize(), node.getId());
                    }
                }
                ++n;
            }
            cLocation = abstractTreeLocation.leaf(splitDockPathProperty.getLeafId());
        } else {
            cLocation = cSplitLocation.rectangle(0.0, 0.0, 1.0, 1.0);
        }
        return cLocation;
    }

    protected CLocation expand(CLocation cLocation, SplitDockPlaceholderProperty splitDockPlaceholderProperty) {
        return this.expand(cLocation, splitDockPlaceholderProperty.getBackup());
    }

    protected CLocation expand(CLocation cLocation, SplitDockProperty splitDockProperty) {
        if (!(cLocation instanceof CSplitLocation)) {
            cLocation = new CSplitLocation(cLocation);
        }
        return new CRectangleLocation((CSplitLocation)cLocation, splitDockProperty.getX(), splitDockProperty.getY(), splitDockProperty.getWidth(), splitDockProperty.getHeight());
    }

    protected CLocation expand(CLocation cLocation, StackDockProperty stackDockProperty) {
        return new CStackLocation(cLocation, stackDockProperty.getIndex());
    }
}

