/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.location.CBaseLocation;
import bibliothek.gui.dock.common.location.CFlapLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.mode.ExtendedMode;

public class CMinimizedLocation
extends CFlapLocation {
    private CBaseLocation parent;
    private Side side;

    public CMinimizedLocation(CBaseLocation cBaseLocation, Side side) {
        super(cBaseLocation);
        if (side == null) {
            throw new NullPointerException("side is null");
        }
        this.parent = cBaseLocation;
        this.side = side;
    }

    public Side getSide() {
        return this.side;
    }

    @Override
    public ExtendedMode findMode() {
        return ExtendedMode.MINIMIZED;
    }

    @Override
    public String findRoot() {
        CContentArea cContentArea = this.parent.getContentArea();
        String string = cContentArea == null ? "ccontrol" : cContentArea.getUniqueId();
        switch (this.side) {
            case NORTH: {
                return CContentArea.getNorthIdentifier(string);
            }
            case SOUTH: {
                return CContentArea.getSouthIdentifier(string);
            }
            case EAST: {
                return CContentArea.getEastIdentifier(string);
            }
            case WEST: {
                return CContentArea.getWestIdentifier(string);
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return String.valueOf(String.valueOf(this.parent)) + " [minimized " + (Object)((Object)this.side) + "]";
    }
}

