/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractStackholdingLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.location.TreeLocationLeaf;
import bibliothek.gui.dock.common.location.TreeLocationNode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;

public abstract class AbstractTreeLocation
extends AbstractStackholdingLocation {
    private double size;
    private Side side;
    private long nodeId = -1L;

    public AbstractTreeLocation(double d, Side side, long l) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Size must be at least 0");
        }
        if (d > 1.0) {
            throw new IllegalArgumentException("Size must be no more than 1");
        }
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException("Size must not be NaN");
        }
        if (side == null) {
            throw new NullPointerException("side must not be null");
        }
        this.size = d;
        this.side = side;
        this.nodeId = l;
    }

    public Side getSide() {
        return this.side;
    }

    public double getSize() {
        return this.size;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public TreeLocationNode north(double d) {
        return this.north(d, -1L);
    }

    public TreeLocationNode north(double d, long l) {
        return new TreeLocationNode(this, d, Side.NORTH, l);
    }

    public TreeLocationNode south(double d) {
        return this.south(d, -1L);
    }

    public TreeLocationNode south(double d, long l) {
        return new TreeLocationNode(this, d, Side.SOUTH, l);
    }

    public TreeLocationNode east(double d) {
        return this.east(d, -1L);
    }

    public TreeLocationNode east(double d, long l) {
        return new TreeLocationNode(this, d, Side.EAST, l);
    }

    public TreeLocationNode west(double d) {
        return this.west(d, -1L);
    }

    public TreeLocationNode west(double d, long l) {
        return new TreeLocationNode(this, d, Side.WEST, l);
    }

    public TreeLocationLeaf leaf(long l) {
        return new TreeLocationLeaf(this, l);
    }

    @Override
    public ExtendedMode findMode() {
        return ExtendedMode.NORMALIZED;
    }

    protected abstract SplitDockPathProperty findParentProperty();

    @Override
    public SplitDockPathProperty findProperty(DockableProperty dockableProperty) {
        SplitDockPathProperty splitDockPathProperty = this.findParentProperty();
        splitDockPathProperty.setSuccessor(dockableProperty);
        switch (this.side) {
            case NORTH: {
                splitDockPathProperty.add(SplitDockPathProperty.Location.TOP, this.size, this.nodeId);
                break;
            }
            case SOUTH: {
                splitDockPathProperty.add(SplitDockPathProperty.Location.BOTTOM, this.size, this.nodeId);
                break;
            }
            case EAST: {
                splitDockPathProperty.add(SplitDockPathProperty.Location.RIGHT, this.size, this.nodeId);
                break;
            }
            case WEST: {
                splitDockPathProperty.add(SplitDockPathProperty.Location.LEFT, this.size, this.nodeId);
            }
        }
        return splitDockPathProperty;
    }

    @Override
    @Deprecated
    public CLocation aside() {
        return this.stack(1);
    }

    public String toString() {
        return "[normal " + (Object)((Object)this.side) + " " + this.size + "]";
    }
}

