/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.HashSet;

public class WorkingAreaAcceptance
implements DockAcceptance {
    private CControlAccess control;

    public WorkingAreaAcceptance(CControlAccess cControlAccess) {
        this.control = cControlAccess;
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable, Dockable dockable2) {
        if (this.accept(dockStation, dockable2)) {
            return this.getWorkingArea(dockable) == this.getWorkingArea(dockable2);
        }
        return false;
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        Object object;
        CLocationModeManager cLocationModeManager = this.control.getLocationManager();
        if (cLocationModeManager.isOnTransaction() && ((object = cLocationModeManager.getCurrentAction()) == null || object.forceAccept(dockStation, dockable))) {
            return true;
        }
        object = cLocationModeManager.childsExtendedMode(dockStation);
        if (object == null && (object = cLocationModeManager.getMode(dockable)) == null) {
            return true;
        }
        CLocationMode cLocationMode = (CLocationMode)cLocationModeManager.getMode(((ExtendedMode)object).getModeIdentifier());
        if (cLocationMode == null) {
            return true;
        }
        if (!cLocationMode.respectWorkingAreas(dockStation)) {
            return true;
        }
        CStation<?> cStation = this.searchArea(dockStation);
        return this.match(cStation, dockable);
    }

    private CStation<?> searchArea(DockElement dockElement) {
        DockStation dockStation = dockElement.asDockStation();
        Dockable dockable = dockElement.asDockable();
        while (dockable != null || dockStation != null) {
            CStation cStation;
            if (dockStation != null && dockStation instanceof CommonDockStation && (cStation = ((CommonDockStation)dockStation).getStation()).isWorkingArea()) {
                return cStation;
            }
            dockable = dockStation == null ? null : dockStation.asDockable();
            DockStation dockStation2 = dockStation = dockable == null ? null : dockable.getDockParent();
        }
        return null;
    }

    private boolean match(CStation<?> cStation, Dockable dockable) {
        Object object;
        Object object2;
        if (dockable instanceof CommonDockable) {
            object2 = this.getWorkingArea(dockable);
            object = ((CommonDockable)dockable).getDockable();
            if (object2 != cStation && object2 != object) {
                return false;
            }
        }
        if ((object2 = dockable.asDockStation()) != null) {
            if (dockable instanceof CommonDockable && (object = ((CommonDockable)dockable).getStation()) != null && object.isWorkingArea()) {
                return true;
            }
            return this.match(cStation, (DockStation)object2);
        }
        return true;
    }

    private CStation<?> getWorkingArea(Dockable dockable) {
        final HashSet hashSet = new HashSet();
        DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

            @Override
            public void handleDockable(Dockable dockable) {
                CDockable cDockable;
                CStation<?> cStation;
                if (dockable instanceof CommonDockable && (cStation = (cDockable = ((CommonDockable)dockable).getDockable()).getWorkingArea()) != null) {
                    hashSet.add(cStation);
                }
            }
        });
        if (hashSet.size() == 1) {
            return (CStation)hashSet.iterator().next();
        }
        return null;
    }

    private boolean match(CStation<?> cStation, DockStation dockStation) {
        int n = 0;
        int n2 = dockStation.getDockableCount();
        while (n < n2) {
            boolean bl = this.match(cStation, dockStation.getDockable(n));
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

