/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.util.UIBridge;
import bibliothek.gui.dock.util.UIValue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class UITransmitter<V, U extends UIValue<V>>
implements UIBridge<V, U> {
    private CControl control;
    private Set<String> keys = new HashSet<String>();
    private Map<String, List<U>> values = new HashMap<String, List<U>>();
    private Listener listener = new Listener();

    public UITransmitter(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.keys.add(string);
            ++n2;
        }
    }

    @Override
    public void add(String string, U u) {
        if (this.keys.contains(string)) {
            boolean bl = this.values.isEmpty();
            List<U> list = this.values.get(string);
            if (list == null) {
                list = new LinkedList<U>();
                this.values.put(string, list);
            }
            list.add(u);
            if (bl) {
                this.setListening(true);
            }
        }
    }

    @Override
    public void remove(String string, U u) {
        if (this.keys.contains(string)) {
            boolean bl = this.values.isEmpty();
            List<U> list = this.values.get(string);
            list.remove(u);
            if (list.isEmpty()) {
                this.values.remove(string);
            }
            if (!bl && this.values.isEmpty()) {
                this.setListening(false);
            }
        }
    }

    public void setControl(CControl cControl) {
        if (!this.values.isEmpty()) {
            this.setListening(false);
        }
        this.control = cControl;
        if (!this.values.isEmpty()) {
            this.setListening(true);
        }
    }

    private void setListening(boolean bl) {
        block4: {
            if (this.control == null) break block4;
            if (bl) {
                this.control.addControlListener(this.listener);
                int n = 0;
                int n2 = this.control.getCDockableCount();
                while (n < n2) {
                    this.connect(this.control.getCDockable(n));
                    ++n;
                }
            } else {
                this.control.removeControlListener(this.listener);
                int n = 0;
                int n3 = this.control.getCDockableCount();
                while (n < n3) {
                    this.disconnect(this.control.getCDockable(n));
                    ++n;
                }
            }
        }
    }

    @Override
    public void set(String string, V v, U u) {
        if (this.keys.contains(string)) {
            v = this.get(v, string, u);
        }
        u.set(v);
    }

    protected abstract V get(V var1, String var2, U var3);

    protected abstract void update(CDockable var1, String var2, V var3);

    protected abstract CDockable getDockable(U var1);

    @Override
    protected void set(String string, V v, CDockable cDockable) {
        List<U> list = this.values.get(string);
        if (list != null) {
            for (UIValue uIValue : list) {
                if (cDockable != this.getDockable(uIValue)) continue;
                uIValue.set(v);
            }
        }
    }

    protected abstract void connect(CDockable var1);

    protected abstract void disconnect(CDockable var1);

    private class Listener
    implements CControlListener {
        private Listener() {
        }

        @Override
        public void added(CControl cControl, CDockable cDockable) {
        }

        @Override
        public void removed(CControl cControl, CDockable cDockable) {
        }

        @Override
        public void closed(CControl cControl, CDockable cDockable) {
            UITransmitter.this.disconnect(cDockable);
        }

        @Override
        public void opened(CControl cControl, CDockable cDockable) {
            UITransmitter.this.connect(cDockable);
        }
    }
}

