/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.displayer.SingleTabDecider;
import bibliothek.gui.dock.event.SingleTabDeciderListener;
import java.util.ArrayList;
import java.util.List;

public class CommonSingleTabDecider
implements SingleTabDecider {
    private List<SingleTabDeciderListener> listeners = new ArrayList<SingleTabDeciderListener>();
    private CControl control;
    private CDockablePropertyListener dockableListener = new CDockableAdapter(){

        @Override
        public void singleTabShownChanged(CDockable cDockable) {
            CommonDockable commonDockable = cDockable.intern();
            SingleTabDeciderListener[] singleTabDeciderListenerArray = CommonSingleTabDecider.this.listeners();
            int n = singleTabDeciderListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                SingleTabDeciderListener singleTabDeciderListener = singleTabDeciderListenerArray[n2];
                singleTabDeciderListener.showSingleTabChanged(CommonSingleTabDecider.this, commonDockable);
                ++n2;
            }
        }
    };

    public CommonSingleTabDecider(CControl cControl) {
        this.control = cControl;
    }

    @Override
    public void addSingleTabDeciderListener(SingleTabDeciderListener singleTabDeciderListener) {
        boolean bl = this.listeners.isEmpty();
        this.listeners.add(singleTabDeciderListener);
        if (bl) {
            this.control.addPropertyListener(this.dockableListener);
        }
    }

    @Override
    public void removeSingleTabDeciderListener(SingleTabDeciderListener singleTabDeciderListener) {
        this.listeners.remove(singleTabDeciderListener);
        if (this.listeners.isEmpty()) {
            this.control.removePropertyListener(this.dockableListener);
        }
    }

    protected SingleTabDeciderListener[] listeners() {
        return this.listeners.toArray(new SingleTabDeciderListener[this.listeners.size()]);
    }

    @Override
    public boolean showSingleTab(DockStation dockStation, Dockable dockable) {
        if (dockable.asDockStation() != null) {
            return false;
        }
        if (dockStation instanceof StackDockStation) {
            return false;
        }
        if (dockable instanceof CommonDockable) {
            CDockable cDockable = ((CommonDockable)dockable).getDockable();
            return cDockable.isSingleTabShown();
        }
        return false;
    }
}

