/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.EnableableItem;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.disable.DisablingStrategyListener;
import bibliothek.gui.dock.title.DockTitle;
import java.util.ArrayList;
import java.util.List;

public class CDisablingStrategy
implements DisablingStrategy {
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        @Override
        public void enabledChanged(CDockable cDockable) {
            CommonDockable commonDockable = cDockable.intern();
            DisablingStrategyListener[] disablingStrategyListenerArray = CDisablingStrategy.this.listeners.toArray(new DisablingStrategyListener[CDisablingStrategy.this.listeners.size()]);
            int n = disablingStrategyListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DisablingStrategyListener disablingStrategyListener = disablingStrategyListenerArray[n2];
                disablingStrategyListener.changed(commonDockable);
                ++n2;
            }
        }
    };
    private List<DisablingStrategyListener> listeners = new ArrayList<DisablingStrategyListener>();

    public CDisablingStrategy(CControl cControl) {
        cControl.addPropertyListener(this.propertyListener);
    }

    @Override
    public void addDisablingStrategyListener(DisablingStrategyListener disablingStrategyListener) {
        this.listeners.add(disablingStrategyListener);
    }

    @Override
    public void removeDisablingStrategyListener(DisablingStrategyListener disablingStrategyListener) {
        this.listeners.remove(disablingStrategyListener);
    }

    @Override
    public boolean isDisabled(DockElement dockElement) {
        Dockable dockable = dockElement.asDockable();
        if (dockable != null && dockable instanceof CommonDockable) {
            return !((CommonDockable)dockable).getDockable().isEnabled(EnableableItem.SELF);
        }
        return false;
    }

    @Override
    public boolean isDisabled(Dockable dockable, DockAction dockAction) {
        if (dockable != null && dockable instanceof CommonDockable) {
            return !((CommonDockable)dockable).getDockable().isEnabled(EnableableItem.ACTIONS);
        }
        return false;
    }

    @Override
    public boolean isDisabled(Dockable dockable, DockTitle dockTitle) {
        if (dockable != null && dockable instanceof CommonDockable) {
            return !((CommonDockable)dockable).getDockable().isEnabled(EnableableItem.TITLES);
        }
        return false;
    }

    @Override
    public boolean isTabDisabled(Dockable dockable) {
        if (dockable != null && dockable instanceof CommonDockable) {
            return !((CommonDockable)dockable).getDockable().isEnabled(EnableableItem.TABS);
        }
        return false;
    }
}

